/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ClassName;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class AccessControl {
    private final Class<?> target;
    private final Visibility visibility;

    AccessControl(Class<?> target2, Visibility visibility) {
        this.target = target2;
        this.visibility = visibility;
    }

    public static AccessControl forMember(Member member) {
        return new AccessControl(member.getDeclaringClass(), Visibility.forMember(member));
    }

    public static AccessControl forResolvableType(ResolvableType resolvableType) {
        return new AccessControl(resolvableType.toClass(), Visibility.forResolvableType(resolvableType));
    }

    public static AccessControl forClass(Class<?> type2) {
        return new AccessControl(type2, Visibility.forClass(type2));
    }

    public static AccessControl lowest(AccessControl ... candidates) {
        int index2 = Visibility.lowestIndex((Visibility[])Arrays.stream(candidates).map(AccessControl::getVisibility).toArray(Visibility[]::new));
        return candidates[index2];
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public boolean isAccessibleFrom(ClassName type2) {
        if (this.visibility == Visibility.PRIVATE) {
            return false;
        }
        if (this.visibility == Visibility.PUBLIC) {
            return true;
        }
        return this.target.getPackageName().equals(type2.packageName());
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE_PRIVATE,
        PRIVATE;


        private static Visibility forMember(Member member) {
            Assert.notNull((Object)member, "'member' must not be null");
            Visibility visibility = Visibility.forModifiers(member.getModifiers());
            Visibility declaringClassVisibility = Visibility.forClass(member.getDeclaringClass());
            visibility = Visibility.lowest(visibility, declaringClassVisibility);
            if (visibility != PRIVATE) {
                if (member instanceof Field) {
                    Field field = (Field)member;
                    Visibility fieldVisibility = Visibility.forResolvableType(ResolvableType.forField(field));
                    return Visibility.lowest(visibility, fieldVisibility);
                }
                if (member instanceof Constructor) {
                    Constructor constructor2 = (Constructor)member;
                    Visibility parameterVisibility = Visibility.forParameterTypes(constructor2, i2 -> ResolvableType.forConstructorParameter(constructor2, i2));
                    return Visibility.lowest(visibility, parameterVisibility);
                }
                if (member instanceof Method) {
                    Method method2 = (Method)member;
                    Visibility parameterVisibility = Visibility.forParameterTypes(method2, i2 -> ResolvableType.forMethodParameter(method2, i2));
                    Visibility returnTypeVisibility = Visibility.forResolvableType(ResolvableType.forMethodReturnType(method2));
                    return Visibility.lowest(visibility, parameterVisibility, returnTypeVisibility);
                }
            }
            return PRIVATE;
        }

        private static Visibility forResolvableType(ResolvableType resolvableType) {
            return Visibility.forResolvableType(resolvableType, new HashSet<ResolvableType>());
        }

        private static Visibility forResolvableType(ResolvableType resolvableType, Set<ResolvableType> seen) {
            if (!seen.add(resolvableType)) {
                return PUBLIC;
            }
            Class<?> userClass = ClassUtils.getUserClass(resolvableType.toClass());
            ResolvableType userType = resolvableType.as(userClass);
            Visibility visibility = Visibility.forClass(userType.toClass());
            for (ResolvableType generic : userType.getGenerics()) {
                visibility = Visibility.lowest(visibility, Visibility.forResolvableType(generic, seen));
            }
            return visibility;
        }

        private static Visibility forParameterTypes(Executable executable, IntFunction<ResolvableType> resolvableTypeFactory) {
            Visibility visibility = PUBLIC;
            Class<?>[] parameterTypes = executable.getParameterTypes();
            for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                ResolvableType type2 = resolvableTypeFactory.apply(i2);
                visibility = Visibility.lowest(visibility, Visibility.forResolvableType(type2));
            }
            return visibility;
        }

        private static Visibility forClass(Class<?> clazz) {
            Class<?> enclosingClass;
            clazz = ClassUtils.getUserClass(clazz);
            Visibility visibility = Visibility.forModifiers(clazz.getModifiers());
            if (clazz.isArray()) {
                visibility = Visibility.lowest(visibility, Visibility.forClass(clazz.componentType()));
            }
            if ((enclosingClass = clazz.getEnclosingClass()) != null) {
                visibility = Visibility.lowest(visibility, Visibility.forClass(clazz.getEnclosingClass()));
            }
            return visibility;
        }

        private static Visibility forModifiers(int modifiers) {
            if (Modifier.isPublic(modifiers)) {
                return PUBLIC;
            }
            if (Modifier.isProtected(modifiers)) {
                return PROTECTED;
            }
            if (Modifier.isPrivate(modifiers)) {
                return PRIVATE;
            }
            return PACKAGE_PRIVATE;
        }

        static Visibility lowest(Visibility ... candidates) {
            Visibility visibility = PUBLIC;
            for (Visibility candidate : candidates) {
                if (candidate.ordinal() <= visibility.ordinal()) continue;
                visibility = candidate;
            }
            return visibility;
        }

        static int lowestIndex(Visibility ... candidates) {
            Visibility visibility = PUBLIC;
            int index2 = 0;
            for (int i2 = 0; i2 < candidates.length; ++i2) {
                Visibility candidate = candidates[i2];
                if (candidate.ordinal() <= visibility.ordinal()) continue;
                visibility = candidate;
                index2 = i2;
            }
            return index2;
        }
    }
}

