/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.util.HashSet;
import java.util.Set;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.support.DefaultIntroductionAdvisor;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import org.springframework.aop.target.ThreadLocalTargetSourceStats;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.NamedThreadLocal;

public class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private final ThreadLocal<Object> targetInThread = new NamedThreadLocal<Object>("Thread-local instance of bean"){

        @Override
        public String toString() {
            return super.toString() + " '" + ThreadLocalTargetSource.this.getTargetBeanName() + "'";
        }
    };
    private final Set<Object> targetSet = new HashSet<Object>();
    private int invocationCount;
    private int hitCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target2 = this.targetInThread.get();
        if (target2 == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No target for prototype '" + this.getTargetBeanName() + "' bound to thread: creating one and binding it to thread '" + Thread.currentThread().getName() + "'");
            }
            target2 = this.newPrototypeInstance();
            this.targetInThread.set(target2);
            Set<Object> set2 = this.targetSet;
            synchronized (set2) {
                this.targetSet.add(target2);
            }
        } else {
            ++this.hitCount;
        }
        return target2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.logger.debug("Destroying ThreadLocalTargetSource bindings");
        Set<Object> set2 = this.targetSet;
        synchronized (set2) {
            for (Object target2 : this.targetSet) {
                this.destroyPrototypeInstance(target2);
            }
            this.targetSet.clear();
        }
        this.targetInThread.remove();
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getObjectCount() {
        Set<Object> set2 = this.targetSet;
        synchronized (set2) {
            return this.targetSet.size();
        }
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, ThreadLocalTargetSourceStats.class);
    }
}

