/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import org.springframework.aop.Advisor;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionAwareMethodMatcher;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.CoroutinesUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AopUtils {
    private static final boolean coroutinesReactorPresent = ClassUtils.isPresent("kotlinx.coroutines.reactor.MonoKt", AopUtils.class.getClassLoader());

    public static boolean isAopProxy(@Nullable Object object) {
        return object instanceof SpringProxy && (Proxy.isProxyClass(object.getClass()) || object.getClass().getName().contains("$$"));
    }

    public static boolean isJdkDynamicProxy(@Nullable Object object) {
        return object instanceof SpringProxy && Proxy.isProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(@Nullable Object object) {
        return object instanceof SpringProxy && object.getClass().getName().contains("$$");
    }

    public static Class<?> getTargetClass(Object candidate) {
        Assert.notNull(candidate, "Candidate object must not be null");
        Class<?> result2 = null;
        if (candidate instanceof TargetClassAware) {
            TargetClassAware targetClassAware = (TargetClassAware)candidate;
            result2 = targetClassAware.getTargetClass();
        }
        if (result2 == null) {
            result2 = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result2;
    }

    public static Method selectInvocableMethod(Method method2, @Nullable Class<?> targetType) {
        if (targetType == null) {
            return method2;
        }
        Method methodToUse = MethodIntrospector.selectInvocableMethod(method2, targetType);
        if (Modifier.isPrivate(methodToUse.getModifiers()) && !Modifier.isStatic(methodToUse.getModifiers()) && SpringProxy.class.isAssignableFrom(targetType)) {
            throw new IllegalStateException(String.format("Need to invoke method '%s' found on proxy for target class '%s' but cannot be delegated to target bean. Switch its visibility to package or protected.", method2.getName(), method2.getDeclaringClass().getSimpleName()));
        }
        return methodToUse;
    }

    public static boolean isEqualsMethod(@Nullable Method method2) {
        return ReflectionUtils.isEqualsMethod(method2);
    }

    public static boolean isHashCodeMethod(@Nullable Method method2) {
        return ReflectionUtils.isHashCodeMethod(method2);
    }

    public static boolean isToStringMethod(@Nullable Method method2) {
        return ReflectionUtils.isToStringMethod(method2);
    }

    public static boolean isFinalizeMethod(@Nullable Method method2) {
        return method2 != null && method2.getName().equals("finalize") && method2.getParameterCount() == 0;
    }

    public static Method getMostSpecificMethod(Method method2, @Nullable Class<?> targetClass) {
        Class<?> specificTargetClass = targetClass != null ? ClassUtils.getUserClass(targetClass) : null;
        return BridgeMethodResolver.getMostSpecificMethod(method2, specificTargetClass);
    }

    public static boolean canApply(Pointcut pc, Class<?> targetClass) {
        return AopUtils.canApply(pc, targetClass, false);
    }

    public static boolean canApply(Pointcut pc, Class<?> targetClass, boolean hasIntroductions) {
        Assert.notNull((Object)pc, "Pointcut must not be null");
        if (!pc.getClassFilter().matches(targetClass)) {
            return false;
        }
        MethodMatcher methodMatcher = pc.getMethodMatcher();
        if (methodMatcher == MethodMatcher.TRUE) {
            return true;
        }
        IntroductionAwareMethodMatcher introductionAwareMethodMatcher = null;
        if (methodMatcher instanceof IntroductionAwareMethodMatcher) {
            IntroductionAwareMethodMatcher iamm;
            introductionAwareMethodMatcher = iamm = (IntroductionAwareMethodMatcher)methodMatcher;
        }
        LinkedHashSet classes = new LinkedHashSet();
        if (!Proxy.isProxyClass(targetClass)) {
            classes.add(ClassUtils.getUserClass(targetClass));
        }
        classes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetClass));
        for (Class clazz : classes) {
            Method[] methods2;
            for (Method method2 : methods2 = ReflectionUtils.getAllDeclaredMethods(clazz)) {
                if (!(introductionAwareMethodMatcher != null ? introductionAwareMethodMatcher.matches(method2, targetClass, hasIntroductions) : methodMatcher.matches(method2, targetClass))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canApply(Advisor advisor, Class<?> targetClass) {
        return AopUtils.canApply(advisor, targetClass, false);
    }

    public static boolean canApply(Advisor advisor, Class<?> targetClass, boolean hasIntroductions) {
        if (advisor instanceof IntroductionAdvisor) {
            IntroductionAdvisor ia = (IntroductionAdvisor)advisor;
            return ia.getClassFilter().matches(targetClass);
        }
        if (advisor instanceof PointcutAdvisor) {
            PointcutAdvisor pca = (PointcutAdvisor)advisor;
            return AopUtils.canApply(pca.getPointcut(), targetClass, hasIntroductions);
        }
        return true;
    }

    public static List<Advisor> findAdvisorsThatCanApply(List<Advisor> candidateAdvisors, Class<?> clazz) {
        if (candidateAdvisors.isEmpty()) {
            return candidateAdvisors;
        }
        ArrayList<Advisor> eligibleAdvisors = new ArrayList<Advisor>();
        for (Advisor candidate : candidateAdvisors) {
            if (!(candidate instanceof IntroductionAdvisor) || !AopUtils.canApply(candidate, clazz)) continue;
            eligibleAdvisors.add(candidate);
        }
        boolean hasIntroductions = !eligibleAdvisors.isEmpty();
        for (Advisor candidate : candidateAdvisors) {
            if (candidate instanceof IntroductionAdvisor || !AopUtils.canApply(candidate, clazz, hasIntroductions)) continue;
            eligibleAdvisors.add(candidate);
        }
        return eligibleAdvisors;
    }

    @Nullable
    public static Object invokeJoinpointUsingReflection(@Nullable Object target2, Method method2, Object[] args2) throws Throwable {
        try {
            Method originalMethod = BridgeMethodResolver.findBridgedMethod(method2);
            ReflectionUtils.makeAccessible(originalMethod);
            return coroutinesReactorPresent && KotlinDetector.isSuspendingFunction(originalMethod) ? KotlinDelegate.invokeSuspendingFunction(originalMethod, target2, args2) : originalMethod.invoke(target2, args2);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (IllegalArgumentException ex) {
            throw new AopInvocationException("AOP configuration seems to be invalid: tried calling method [" + method2 + "] on target [" + target2 + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new AopInvocationException("Could not access method [" + method2 + "]", ex);
        }
    }

    private static class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static Object invokeSuspendingFunction(Method method2, @Nullable Object target2, Object ... args2) {
            Continuation continuation = (Continuation)args2[args2.length - 1];
            Assert.state(continuation != null, "No Continuation available");
            CoroutineContext context = continuation.getContext().minusKey((CoroutineContext.Key)Job.Key);
            return CoroutinesUtils.invokeSuspendingFunction(context, method2, target2, args2);
        }
    }
}

