/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(pattern);
    }

    public void setPatterns(String ... patterns) {
        Assert.notEmpty((Object[])patterns, "'patterns' must not be empty");
        this.patterns = new String[patterns.length];
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            this.patterns[i2] = patterns[i2].strip();
        }
        this.initPatternRepresentation(this.patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(excludedPattern);
    }

    public void setExcludedPatterns(String ... excludedPatterns) {
        Assert.notEmpty((Object[])excludedPatterns, "'excludedPatterns' must not be empty");
        this.excludedPatterns = new String[excludedPatterns.length];
        for (int i2 = 0; i2 < excludedPatterns.length; ++i2) {
            this.excludedPatterns[i2] = excludedPatterns[i2].strip();
        }
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    @Override
    public boolean matches(Method method2, Class<?> targetClass) {
        return this.matchesPattern(ClassUtils.getQualifiedMethodName(method2, targetClass)) || targetClass != method2.getDeclaringClass() && this.matchesPattern(ClassUtils.getQualifiedMethodName(method2, method2.getDeclaringClass()));
    }

    protected boolean matchesPattern(String signatureString) {
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            boolean matched = this.matches(signatureString, i2);
            if (!matched) continue;
            for (int j = 0; j < this.excludedPatterns.length; ++j) {
                boolean excluded = this.matchesExclusion(signatureString, j);
                if (!excluded) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AbstractRegexpMethodPointcut)) return false;
        AbstractRegexpMethodPointcut otherPointcut = (AbstractRegexpMethodPointcut)other;
        if (!Arrays.equals(this.patterns, otherPointcut.patterns)) return false;
        if (!Arrays.equals(this.excludedPatterns, otherPointcut.excludedPatterns)) return false;
        return true;
    }

    public int hashCode() {
        int result2 = 27;
        for (String pattern : this.patterns) {
            result2 = 13 * result2 + pattern.hashCode();
        }
        for (String excludedPattern : this.excludedPatterns) {
            result2 = 13 * result2 + excludedPattern.hashCode();
        }
        return result2;
    }

    public String toString() {
        return this.getClass().getName() + ": patterns " + ObjectUtils.nullSafeToString(this.patterns) + ", excluded patterns " + ObjectUtils.nullSafeToString(this.excludedPatterns);
    }
}

