/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.RawTargetAccess;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.CoroutinesUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.cglib.core.ClassLoaderAwareGeneratorStrategy;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Dispatcher;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.cglib.proxy.NoOp;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.SmartClassLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class CglibAopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final boolean coroutinesReactorPresent = ClassUtils.isPresent("kotlinx.coroutines.reactor.MonoKt", CglibAopProxy.class.getClassLoader());
    protected static final Log logger = LogFactory.getLog(CglibAopProxy.class);
    private static final Map<Class<?>, Boolean> validatedClasses = new WeakHashMap();
    protected final AdvisedSupport advised;
    @Nullable
    protected Object[] constructorArgs;
    @Nullable
    protected Class<?>[] constructorArgTypes;
    private final transient AdvisedDispatcher advisedDispatcher;
    private transient Map<Method, Integer> fixedInterceptorMap = Collections.emptyMap();
    private transient int fixedInterceptorOffset;

    public CglibAopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull((Object)config, "AdvisedSupport must not be null");
        this.advised = config;
        this.advisedDispatcher = new AdvisedDispatcher(this.advised);
    }

    public void setConstructorArguments(@Nullable Object[] constructorArgs, @Nullable Class<?>[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    @Override
    public Object getProxy() {
        return this.buildProxy(null, false);
    }

    @Override
    public Object getProxy(@Nullable ClassLoader classLoader) {
        return this.buildProxy(classLoader, false);
    }

    @Override
    public Class<?> getProxyClass(@Nullable ClassLoader classLoader) {
        return (Class)this.buildProxy(classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object buildProxy(@Nullable ClassLoader classLoader, boolean classOnly) {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating CGLIB proxy: " + this.advised.getTargetSource());
        }
        Class<?> rootClass = this.advised.getTargetClass();
        Assert.state(rootClass != null, "Target class must be available for creating a CGLIB proxy");
        Class<?> proxySuperClass = rootClass;
        if (rootClass.getName().contains("$$")) {
            Class<?>[] additionalInterfaces;
            proxySuperClass = rootClass.getSuperclass();
            for (Class<?> additionalInterface : additionalInterfaces = rootClass.getInterfaces()) {
                this.advised.addInterface(additionalInterface);
            }
        }
        this.validateClassIfNecessary(proxySuperClass, classLoader);
        Enhancer enhancer = this.createEnhancer();
        if (classLoader != null) {
            SmartClassLoader smartClassLoader;
            enhancer.setClassLoader(classLoader);
            if (classLoader instanceof SmartClassLoader && (smartClassLoader = (SmartClassLoader)((Object)classLoader)).isClassReloadable(proxySuperClass)) {
                enhancer.setUseCache(false);
            }
        }
        enhancer.setSuperclass(proxySuperClass);
        enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
        enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
        enhancer.setAttemptLoad(true);
        enhancer.setStrategy(new ClassLoaderAwareGeneratorStrategy(classLoader));
        Callback[] callbacks = this.getCallbacks(rootClass);
        Class[] types = new Class[callbacks.length];
        for (int x = 0; x < types.length; ++x) {
            types[x] = callbacks[x].getClass();
        }
        ProxyCallbackFilter filter2 = new ProxyCallbackFilter(this.advised.getConfigurationOnlyCopy(), this.fixedInterceptorMap, this.fixedInterceptorOffset);
        enhancer.setCallbackFilter(filter2);
        enhancer.setCallbackTypes(types);
        try {
            Object object = classOnly ? this.createProxyClass(enhancer) : this.createProxyClassAndInstance(enhancer, callbacks);
            filter2.advised.reduceToAdvisorKey();
            return object;
        }
        catch (Throwable throwable) {
            try {
                filter2.advised.reduceToAdvisorKey();
                throw throwable;
            }
            catch (IllegalArgumentException | CodeGenerationException ex) {
                throw new AopConfigException("Could not generate CGLIB subclass of " + this.advised.getTargetClass() + ": Common causes of this problem include using a final class or a non-visible class", ex);
            }
            catch (Throwable ex) {
                throw new AopConfigException("Unexpected AOP exception", ex);
            }
        }
    }

    protected Class<?> createProxyClass(Enhancer enhancer) {
        enhancer.setInterceptDuringConstruction(false);
        return enhancer.createClass();
    }

    protected Object createProxyClassAndInstance(Enhancer enhancer, Callback[] callbacks) {
        enhancer.setInterceptDuringConstruction(false);
        enhancer.setCallbacks(callbacks);
        return this.constructorArgs != null && this.constructorArgTypes != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClassIfNecessary(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader) {
        if (!this.advised.isOptimize() && logger.isInfoEnabled()) {
            Map<Class<?>, Boolean> map2 = validatedClasses;
            synchronized (map2) {
                validatedClasses.computeIfAbsent(proxySuperClass, clazz -> {
                    this.doValidateClass((Class<?>)clazz, proxyClassLoader, ClassUtils.getAllInterfacesForClassAsSet(clazz));
                    return Boolean.TRUE;
                });
            }
        }
    }

    private void doValidateClass(Class<?> proxySuperClass, @Nullable ClassLoader proxyClassLoader, Set<Class<?>> ifcs) {
        if (proxySuperClass != Object.class) {
            Method[] methods2;
            for (Method method2 : methods2 = proxySuperClass.getDeclaredMethods()) {
                int mod = method2.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isPrivate(mod)) continue;
                if (Modifier.isFinal(mod)) {
                    if (logger.isWarnEnabled() && CglibAopProxy.implementsInterface(method2, ifcs)) {
                        logger.warn("Unable to proxy interface-implementing method [" + method2 + "] because it is marked as final, consider using interface-based JDK proxies instead.");
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Final method [" + method2 + "] cannot get proxied via CGLIB: Calls to this method will NOT be routed to the target instance and might lead to NPEs against uninitialized fields in the proxy instance.");
                    continue;
                }
                if (!logger.isDebugEnabled() || Modifier.isPublic(mod) || Modifier.isProtected(mod) || proxyClassLoader == null || proxySuperClass.getClassLoader() == proxyClassLoader) continue;
                logger.debug("Method [" + method2 + "] is package-visible across different ClassLoaders and cannot get proxied via CGLIB: Declare this method as public or protected if you need to support invocations through the proxy.");
            }
            this.doValidateClass(proxySuperClass.getSuperclass(), proxyClassLoader, ifcs);
        }
    }

    private Callback[] getCallbacks(Class<?> rootClass) throws Exception {
        boolean isStatic = this.advised.getTargetSource().isStatic();
        boolean isFrozen = this.advised.isFrozen();
        boolean exposeProxy = this.advised.isExposeProxy();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(this.advised);
        Serializable targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(this.advised.getTargetSource())) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(this.advised.getTargetSource()));
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised), new HashCodeInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            Method[] methods2 = rootClass.getMethods();
            int methodsCount = methods2.length;
            ArrayList<FixedChainStaticTargetInterceptor> fixedCallbacks = new ArrayList<FixedChainStaticTargetInterceptor>(methodsCount);
            this.fixedInterceptorMap = CollectionUtils.newHashMap(methodsCount);
            int advicedMethodCount = methodsCount;
            for (int x = 0; x < methodsCount; ++x) {
                Method method2 = methods2[x];
                if (method2.getDeclaringClass() == Object.class) {
                    --advicedMethodCount;
                    continue;
                }
                List<Object> chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method2, rootClass);
                fixedCallbacks.add(new FixedChainStaticTargetInterceptor(chain2, this.advised.getTargetSource().getTarget(), this.advised.getTargetClass()));
                this.fixedInterceptorMap.put(method2, x - (methodsCount - advicedMethodCount));
            }
            Callback[] callbacks = new Callback[mainCallbacks.length + advicedMethodCount];
            System.arraycopy(mainCallbacks, 0, callbacks, 0, mainCallbacks.length);
            System.arraycopy(fixedCallbacks.toArray(Callback[]::new), 0, callbacks, mainCallbacks.length, advicedMethodCount);
            this.fixedInterceptorOffset = mainCallbacks.length;
            return callbacks;
        }
        return mainCallbacks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof CglibAopProxy)) return false;
        CglibAopProxy that = (CglibAopProxy)other;
        if (!AopProxyUtils.equalsInProxy(this.advised, that.advised)) return false;
        return true;
    }

    public int hashCode() {
        return CglibAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    private static boolean implementsInterface(Method method2, Set<Class<?>> ifcs) {
        for (Class<?> ifc : ifcs) {
            if (!ClassUtils.hasMethod(ifc, method2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static Object processReturnType(Object proxy2, @Nullable Object target2, Method method2, Object[] arguments, @Nullable Object returnValue) {
        if (returnValue != null && returnValue == target2 && !RawTargetAccess.class.isAssignableFrom(method2.getDeclaringClass())) {
            returnValue = proxy2;
        }
        Class<?> returnType = method2.getReturnType();
        if (returnValue == null && returnType != Void.TYPE && returnType.isPrimitive()) {
            throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method2);
        }
        if (coroutinesReactorPresent && KotlinDetector.isSuspendingFunction(method2)) {
            return COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method2, -1).getParameterType().getName()) ? CoroutinesUtils.asFlow(returnValue) : CoroutinesUtils.awaitSingleOrNull(returnValue, arguments[arguments.length - 1]);
        }
        return returnValue;
    }

    private static class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private final AdvisedSupport advised;

        public AdvisedDispatcher(AdvisedSupport advised) {
            this.advised = advised;
        }

        @Override
        public Object loadObject() {
            return this.advised;
        }
    }

    private static class ProxyCallbackFilter
    implements CallbackFilter {
        final AdvisedSupport advised;
        private final Map<Method, Integer> fixedInterceptorMap;
        private final int fixedInterceptorOffset;

        public ProxyCallbackFilter(AdvisedSupport advised, Map<Method, Integer> fixedInterceptorMap, int fixedInterceptorOffset) {
            this.advised = advised;
            this.fixedInterceptorMap = fixedInterceptorMap;
            this.fixedInterceptorOffset = fixedInterceptorOffset;
        }

        @Override
        public int accept(Method method2) {
            if (AopUtils.isFinalizeMethod(method2)) {
                logger.trace("Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            if (!this.advised.isOpaque() && method2.getDeclaringClass().isInterface() && method2.getDeclaringClass().isAssignableFrom(Advised.class)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Method is declared on Advised interface: " + method2);
                }
                return 4;
            }
            if (AopUtils.isEqualsMethod(method2)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Found 'equals' method: " + method2);
                }
                return 5;
            }
            if (AopUtils.isHashCodeMethod(method2)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Found 'hashCode' method: " + method2);
                }
                return 6;
            }
            Class<?> targetClass = this.advised.getTargetClass();
            List<Object> chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method2, targetClass);
            boolean haveAdvice = !chain2.isEmpty();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            boolean exposeProxy = this.advised.isExposeProxy();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Must expose proxy on advised method: " + method2);
                    }
                    return 0;
                }
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(method2)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Method has advice and optimizations are enabled: " + method2);
                    }
                    int index2 = this.fixedInterceptorMap.get(method2);
                    return index2 + this.fixedInterceptorOffset;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Unable to apply any optimizations to advised method: " + method2);
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method2.getReturnType();
            if (targetClass != null && returnType.isAssignableFrom(targetClass)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Method return type is assignable from target type and may therefore return 'this' - using INVOKE_TARGET: " + method2);
                }
                return 1;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Method return type ensures 'this' cannot be returned - using DISPATCH_TARGET: " + method2);
            }
            return 3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof ProxyCallbackFilter)) return false;
            ProxyCallbackFilter that = (ProxyCallbackFilter)other;
            if (!this.advised.getAdvisorKey().equals(that.advised.getAdvisorKey())) return false;
            if (!AopProxyUtils.equalsProxiedInterfaces(this.advised, that.advised)) return false;
            if (!ObjectUtils.nullSafeEquals(this.advised.getTargetClass(), that.advised.getTargetClass())) return false;
            if (this.advised.getTargetSource().isStatic() != that.advised.getTargetSource().isStatic()) return false;
            if (this.advised.isFrozen() != that.advised.isFrozen()) return false;
            if (this.advised.isExposeProxy() != that.advised.isExposeProxy()) return false;
            if (this.advised.isOpaque() != that.advised.isOpaque()) return false;
            return true;
        }

        public int hashCode() {
            return this.advised.getAdvisorKey().hashCode();
        }
    }

    private static class DynamicAdvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public DynamicAdvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            boolean setProxyContext = false;
            Object target2 = null;
            TargetSource targetSource = this.advised.getTargetSource();
            try {
                Object retVal;
                Class<?> targetClass;
                List<Object> chain2;
                if (this.advised.exposeProxy) {
                    oldProxy = AopContext.setCurrentProxy(proxy2);
                    setProxyContext = true;
                }
                if ((chain2 = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method2, targetClass = (target2 = targetSource.getTarget()) != null ? target2.getClass() : null)).isEmpty()) {
                    Object[] argsToUse = AopProxyUtils.adaptArgumentsIfNecessary(method2, args2);
                    retVal = AopUtils.invokeJoinpointUsingReflection(target2, method2, argsToUse);
                } else {
                    retVal = new CglibMethodInvocation(proxy2, target2, method2, args2, targetClass, chain2, methodProxy).proceed();
                }
                Object object = CglibAopProxy.processReturnType(proxy2, target2, method2, args2, retVal);
                return object;
            }
            finally {
                if (target2 != null && !targetSource.isStatic()) {
                    targetSource.releaseTarget(target2);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof DynamicAdvisedInterceptor)) return false;
            DynamicAdvisedInterceptor dynamicAdvisedInterceptor = (DynamicAdvisedInterceptor)other;
            if (!this.advised.equals(dynamicAdvisedInterceptor.advised)) return false;
            return true;
        }

        public int hashCode() {
            return this.advised.hashCode();
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        @Nullable
        private final Object target;

        public StaticUnadvisedExposedInterceptor(@Nullable Object target2) {
            this.target = target2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy2);
                Object retVal = AopUtils.invokeJoinpointUsingReflection(this.target, method2, args2);
                Object object = CglibAopProxy.processReturnType(proxy2, this.target, method2, args2, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
            }
        }
    }

    private static class DynamicUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedExposedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object oldProxy = null;
            Object target2 = this.targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy2);
                Object retVal = AopUtils.invokeJoinpointUsingReflection(target2, method2, args2);
                Object object = CglibAopProxy.processReturnType(proxy2, target2, method2, args2, retVal);
                return object;
            }
            finally {
                AopContext.setCurrentProxy(oldProxy);
                if (target2 != null) {
                    this.targetSource.releaseTarget(target2);
                }
            }
        }
    }

    private static class StaticUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        @Nullable
        private final Object target;

        public StaticUnadvisedInterceptor(@Nullable Object target2) {
            this.target = target2;
        }

        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object retVal = AopUtils.invokeJoinpointUsingReflection(this.target, method2, args2);
            return CglibAopProxy.processReturnType(proxy2, this.target, method2, args2, retVal);
        }
    }

    private static class DynamicUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            Object target2 = this.targetSource.getTarget();
            try {
                Object retVal = AopUtils.invokeJoinpointUsingReflection(target2, method2, args2);
                Object object = CglibAopProxy.processReturnType(proxy2, target2, method2, args2, retVal);
                return object;
            }
            finally {
                if (target2 != null) {
                    this.targetSource.releaseTarget(target2);
                }
            }
        }
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        @Nullable
        private final Object target;

        public StaticDispatcher(@Nullable Object target2) {
            this.target = target2;
        }

        @Override
        @Nullable
        public Object loadObject() {
            return this.target;
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
    }

    private static class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) {
            boolean bl;
            Object other = args2[0];
            if (proxy2 == other) {
                return true;
            }
            if (!(other instanceof Factory)) return false;
            Factory factory = (Factory)other;
            Callback callback = factory.getCallback(5);
            if (callback instanceof EqualsInterceptor) {
                EqualsInterceptor that = (EqualsInterceptor)callback;
                if (AopProxyUtils.equalsInProxy(this.advised, that.advised)) {
                    bl = true;
                    return bl;
                }
            }
            bl = false;
            return bl;
        }
    }

    private static class HashCodeInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public HashCodeInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        @Override
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) {
            return CglibAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
        }
    }

    private static class FixedChainStaticTargetInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List<Object> adviceChain;
        @Nullable
        private final Object target;
        @Nullable
        private final Class<?> targetClass;

        public FixedChainStaticTargetInterceptor(List<Object> adviceChain, @Nullable Object target2, @Nullable Class<?> targetClass) {
            this.adviceChain = adviceChain;
            this.target = target2;
            this.targetClass = targetClass;
        }

        @Override
        @Nullable
        public Object intercept(Object proxy2, Method method2, Object[] args2, MethodProxy methodProxy) throws Throwable {
            CglibMethodInvocation invocation = new CglibMethodInvocation(proxy2, this.target, method2, args2, this.targetClass, this.adviceChain, methodProxy);
            Object retVal = invocation.proceed();
            retVal = CglibAopProxy.processReturnType(proxy2, this.target, method2, args2, retVal);
            return retVal;
        }
    }

    private static class CglibMethodInvocation
    extends ReflectiveMethodInvocation {
        public CglibMethodInvocation(Object proxy2, @Nullable Object target2, Method method2, Object[] arguments, @Nullable Class<?> targetClass, List<Object> interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy2, target2, method2, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
        }

        @Override
        @Nullable
        public Object proceed() throws Throwable {
            try {
                return super.proceed();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ReflectionUtils.declaresException(this.getMethod(), ex.getClass()) || KotlinDetector.isKotlinType(this.getMethod().getDeclaringClass())) {
                    throw ex;
                }
                throw new UndeclaredThrowableException(ex);
            }
        }
    }
}

