/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.TargetClassAware;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.core.DecoratingProxy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AopProxyUtils {
    @Nullable
    public static Object getSingletonTarget(Object candidate) {
        Advised advised;
        TargetSource targetSource;
        if (candidate instanceof Advised && (targetSource = (advised = (Advised)candidate).getTargetSource()) instanceof SingletonTargetSource) {
            SingletonTargetSource singleTargetSource = (SingletonTargetSource)targetSource;
            return singleTargetSource.getTarget();
        }
        return null;
    }

    public static Class<?> ultimateTargetClass(Object candidate) {
        Assert.notNull(candidate, "Candidate object must not be null");
        Object current2 = candidate;
        Class<?> result2 = null;
        while (current2 instanceof TargetClassAware) {
            TargetClassAware targetClassAware = (TargetClassAware)current2;
            result2 = targetClassAware.getTargetClass();
            current2 = AopProxyUtils.getSingletonTarget(current2);
        }
        if (result2 == null) {
            result2 = AopUtils.isCglibProxy(candidate) ? candidate.getClass().getSuperclass() : candidate.getClass();
        }
        return result2;
    }

    public static Class<?>[] completeJdkProxyInterfaces(Class<?> ... userInterfaces) {
        ArrayList completedInterfaces = new ArrayList(userInterfaces.length + 3);
        for (Class<?> ifc : userInterfaces) {
            Assert.notNull(ifc, "'userInterfaces' must not contain null values");
            Assert.isTrue(ifc.isInterface() && !ifc.isSealed(), () -> ifc.getName() + " must be a non-sealed interface");
            completedInterfaces.add(ifc);
        }
        completedInterfaces.add(SpringProxy.class);
        completedInterfaces.add(Advised.class);
        completedInterfaces.add(DecoratingProxy.class);
        return (Class[])completedInterfaces.toArray(Class[]::new);
    }

    public static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised) {
        return AopProxyUtils.completeProxiedInterfaces(advised, false);
    }

    static Class<?>[] completeProxiedInterfaces(AdvisedSupport advised, boolean decoratingProxy) {
        Class<?> targetClass;
        Class<?>[] specifiedInterfaces = advised.getProxiedInterfaces();
        if (specifiedInterfaces.length == 0 && (targetClass = advised.getTargetClass()) != null) {
            if (targetClass.isInterface()) {
                advised.setInterfaces(targetClass);
            } else if (Proxy.isProxyClass(targetClass) || ClassUtils.isLambdaClass(targetClass)) {
                advised.setInterfaces(targetClass.getInterfaces());
            }
            specifiedInterfaces = advised.getProxiedInterfaces();
        }
        ArrayList proxiedInterfaces = new ArrayList(specifiedInterfaces.length + 3);
        for (Class<?> ifc : specifiedInterfaces) {
            if (ifc.isSealed()) continue;
            proxiedInterfaces.add(ifc);
        }
        if (!advised.isInterfaceProxied(SpringProxy.class)) {
            proxiedInterfaces.add(SpringProxy.class);
        }
        if (!advised.isOpaque() && !advised.isInterfaceProxied(Advised.class)) {
            proxiedInterfaces.add(Advised.class);
        }
        if (decoratingProxy && !advised.isInterfaceProxied(DecoratingProxy.class)) {
            proxiedInterfaces.add(DecoratingProxy.class);
        }
        return ClassUtils.toClassArray(proxiedInterfaces);
    }

    public static Class<?>[] proxiedUserInterfaces(Object proxy2) {
        Class<?>[] proxyInterfaces = proxy2.getClass().getInterfaces();
        int nonUserIfcCount = 0;
        if (proxy2 instanceof SpringProxy) {
            ++nonUserIfcCount;
        }
        if (proxy2 instanceof Advised) {
            ++nonUserIfcCount;
        }
        if (proxy2 instanceof DecoratingProxy) {
            ++nonUserIfcCount;
        }
        Object[] userInterfaces = Arrays.copyOf(proxyInterfaces, proxyInterfaces.length - nonUserIfcCount);
        Assert.notEmpty(userInterfaces, "JDK proxy must implement one or more interfaces");
        return userInterfaces;
    }

    public static boolean equalsInProxy(AdvisedSupport a, AdvisedSupport b2) {
        return a == b2 || AopProxyUtils.equalsProxiedInterfaces(a, b2) && AopProxyUtils.equalsAdvisors(a, b2) && a.getTargetSource().equals(b2.getTargetSource());
    }

    public static boolean equalsProxiedInterfaces(AdvisedSupport a, AdvisedSupport b2) {
        return Arrays.equals(a.getProxiedInterfaces(), b2.getProxiedInterfaces());
    }

    public static boolean equalsAdvisors(AdvisedSupport a, AdvisedSupport b2) {
        return a.getAdvisorCount() == b2.getAdvisorCount() && Arrays.equals(a.getAdvisors(), b2.getAdvisors());
    }

    static Object[] adaptArgumentsIfNecessary(Method method2, @Nullable Object[] arguments) {
        Object varargArray;
        int varargIndex;
        Class<?>[] paramTypes;
        Class<?> varargType;
        if (ObjectUtils.isEmpty(arguments)) {
            return new Object[0];
        }
        if (method2.isVarArgs() && method2.getParameterCount() == arguments.length && (varargType = (paramTypes = method2.getParameterTypes())[varargIndex = paramTypes.length - 1]).isArray() && (varargArray = arguments[varargIndex]) instanceof Object[] && !varargType.isInstance(varargArray)) {
            Object[] newArguments = new Object[arguments.length];
            System.arraycopy(arguments, 0, newArguments, 0, varargIndex);
            TypeDescriptor.OfField targetElementType = varargType.componentType();
            int varargLength = Array.getLength(varargArray);
            Object newVarargArray = Array.newInstance(targetElementType, varargLength);
            System.arraycopy(varargArray, 0, newVarargArray, 0, varargLength);
            newArguments[varargIndex] = newVarargArray;
            return newArguments;
        }
        return arguments;
    }
}

