/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.springframework.core.NamedThreadLocal;
import org.springframework.lang.Nullable;

public final class AopContext {
    private static final ThreadLocal<Object> currentProxy = new NamedThreadLocal<Object>("Current AOP proxy");

    private AopContext() {
    }

    public static Object currentProxy() throws IllegalStateException {
        Object proxy2 = currentProxy.get();
        if (proxy2 == null) {
            throw new IllegalStateException("Cannot find current proxy: Set 'exposeProxy' property on Advised to 'true' to make it available, and ensure that AopContext.currentProxy() is invoked in the same thread as the AOP invocation context.");
        }
        return proxy2;
    }

    @Nullable
    static Object setCurrentProxy(@Nullable Object proxy2) {
        Object old = currentProxy.get();
        if (proxy2 != null) {
            currentProxy.set(proxy2);
        } else {
            currentProxy.remove();
        }
        return old;
    }
}

