/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.safety;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Functions;
import org.jsoup.internal.Normalizer;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;

public class Safelist {
    private static final String All = ":all";
    private final Set<TagName> tagNames = new HashSet<TagName>();
    private final Map<TagName, Set<AttributeKey>> attributes = new HashMap<TagName, Set<AttributeKey>>();
    private final Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes = new HashMap<TagName, Map<AttributeKey, AttributeValue>>();
    private final Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols = new HashMap<TagName, Map<AttributeKey, Set<Protocol>>>();
    private boolean preserveRelativeLinks = false;

    public static Safelist none() {
        return new Safelist();
    }

    public static Safelist simpleText() {
        return new Safelist().addTags("b", "em", "i", "strong", "u");
    }

    public static Safelist basic() {
        return new Safelist().addTags("a", "b", "blockquote", "br", "cite", "code", "dd", "dl", "dt", "em", "i", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "u", "ul").addAttributes("a", "href").addAttributes("blockquote", "cite").addAttributes("q", "cite").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addEnforcedAttribute("a", "rel", "nofollow");
    }

    public static Safelist basicWithImages() {
        return Safelist.basic().addTags("img").addAttributes("img", "align", "alt", "height", "src", "title", "width").addProtocols("img", "src", "http", "https");
    }

    public static Safelist relaxed() {
        return new Safelist().addTags("a", "b", "blockquote", "br", "caption", "cite", "code", "col", "colgroup", "dd", "div", "dl", "dt", "em", "h1", "h2", "h3", "h4", "h5", "h6", "i", "img", "li", "ol", "p", "pre", "q", "small", "span", "strike", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "u", "ul").addAttributes("a", "href", "title").addAttributes("blockquote", "cite").addAttributes("col", "span", "width").addAttributes("colgroup", "span", "width").addAttributes("img", "align", "alt", "height", "src", "title", "width").addAttributes("ol", "start", "type").addAttributes("q", "cite").addAttributes("table", "summary", "width").addAttributes("td", "abbr", "axis", "colspan", "rowspan", "width").addAttributes("th", "abbr", "axis", "colspan", "rowspan", "scope", "width").addAttributes("ul", "type").addProtocols("a", "href", "ftp", "http", "https", "mailto").addProtocols("blockquote", "cite", "http", "https").addProtocols("cite", "cite", "http", "https").addProtocols("img", "src", "http", "https").addProtocols("q", "cite", "http", "https");
    }

    public Safelist() {
    }

    public Safelist(Safelist copy2) {
        this();
        this.tagNames.addAll(copy2.tagNames);
        for (Map.Entry<TagName, Set<AttributeKey>> entry : copy2.attributes.entrySet()) {
            this.attributes.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (Map.Entry<TagName, Object> entry : copy2.enforcedAttributes.entrySet()) {
            this.enforcedAttributes.put(entry.getKey(), new HashMap((Map)entry.getValue()));
        }
        for (Map.Entry<TagName, Object> entry : copy2.protocols.entrySet()) {
            HashMap attributeProtocolsCopy = new HashMap();
            for (Map.Entry attributeProtocols : ((Map)entry.getValue()).entrySet()) {
                attributeProtocolsCopy.put((AttributeKey)attributeProtocols.getKey(), new HashSet((Collection)attributeProtocols.getValue()));
            }
            this.protocols.put(entry.getKey(), attributeProtocolsCopy);
        }
        this.preserveRelativeLinks = copy2.preserveRelativeLinks;
    }

    public Safelist addTags(String ... tags) {
        Validate.notNull(tags);
        for (String tagName : tags) {
            Validate.notEmpty(tagName);
            Validate.isFalse(tagName.equalsIgnoreCase("noscript"), "noscript is unsupported in Safelists, due to incompatibilities between parsers with and without script-mode enabled");
            this.tagNames.add(TagName.valueOf(tagName));
        }
        return this;
    }

    public Safelist removeTags(String ... tags) {
        Validate.notNull(tags);
        for (String tag2 : tags) {
            Validate.notEmpty(tag2);
            TagName tagName = TagName.valueOf(tag2);
            if (!this.tagNames.remove(tagName)) continue;
            this.attributes.remove(tagName);
            this.enforcedAttributes.remove(tagName);
            this.protocols.remove(tagName);
        }
        return this;
    }

    public Safelist addAttributes(String tag2, String ... attributes) {
        Validate.notEmpty(tag2);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "No attribute names supplied.");
        this.addTags(tag2);
        TagName tagName = TagName.valueOf(tag2);
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (String key2 : attributes) {
            Validate.notEmpty(key2);
            attributeSet.add(AttributeKey.valueOf(key2));
        }
        Set currentSet = this.attributes.computeIfAbsent(tagName, Functions.setFunction());
        currentSet.addAll(attributeSet);
        return this;
    }

    public Safelist removeAttributes(String tag2, String ... attributes) {
        Validate.notEmpty(tag2);
        Validate.notNull(attributes);
        Validate.isTrue(attributes.length > 0, "No attribute names supplied.");
        TagName tagName = TagName.valueOf(tag2);
        HashSet<AttributeKey> attributeSet = new HashSet<AttributeKey>();
        for (String key2 : attributes) {
            Validate.notEmpty(key2);
            attributeSet.add(AttributeKey.valueOf(key2));
        }
        if (this.tagNames.contains(tagName) && this.attributes.containsKey(tagName)) {
            Set<AttributeKey> currentSet = this.attributes.get(tagName);
            currentSet.removeAll(attributeSet);
            if (currentSet.isEmpty()) {
                this.attributes.remove(tagName);
            }
        }
        if (tag2.equals(All)) {
            Iterator<Map.Entry<TagName, Set<AttributeKey>>> it = this.attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TagName, Set<AttributeKey>> entry = it.next();
                Set<AttributeKey> currentSet = entry.getValue();
                currentSet.removeAll(attributeSet);
                if (!currentSet.isEmpty()) continue;
                it.remove();
            }
        }
        return this;
    }

    public Safelist addEnforcedAttribute(String tag2, String attribute, String value2) {
        Validate.notEmpty(tag2);
        Validate.notEmpty(attribute);
        Validate.notEmpty(value2);
        TagName tagName = TagName.valueOf(tag2);
        this.tagNames.add(tagName);
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        AttributeValue attrVal = AttributeValue.valueOf(value2);
        Map<AttributeKey, AttributeValue> attrMap = this.enforcedAttributes.computeIfAbsent(tagName, Functions.mapFunction());
        attrMap.put(attrKey, attrVal);
        return this;
    }

    public Safelist removeEnforcedAttribute(String tag2, String attribute) {
        Validate.notEmpty(tag2);
        Validate.notEmpty(attribute);
        TagName tagName = TagName.valueOf(tag2);
        if (this.tagNames.contains(tagName) && this.enforcedAttributes.containsKey(tagName)) {
            AttributeKey attrKey = AttributeKey.valueOf(attribute);
            Map<AttributeKey, AttributeValue> attrMap = this.enforcedAttributes.get(tagName);
            attrMap.remove(attrKey);
            if (attrMap.isEmpty()) {
                this.enforcedAttributes.remove(tagName);
            }
        }
        return this;
    }

    public Safelist preserveRelativeLinks(boolean preserve) {
        this.preserveRelativeLinks = preserve;
        return this;
    }

    public Safelist addProtocols(String tag2, String attribute, String ... protocols) {
        Validate.notEmpty(tag2);
        Validate.notEmpty(attribute);
        Validate.notNull(protocols);
        TagName tagName = TagName.valueOf(tag2);
        AttributeKey attrKey = AttributeKey.valueOf(attribute);
        Map attrMap = this.protocols.computeIfAbsent(tagName, Functions.mapFunction());
        Set protSet = attrMap.computeIfAbsent(attrKey, Functions.setFunction());
        for (String protocol2 : protocols) {
            Validate.notEmpty(protocol2);
            Protocol prot = Protocol.valueOf(protocol2);
            protSet.add(prot);
        }
        return this;
    }

    public Safelist removeProtocols(String tag2, String attribute, String ... removeProtocols) {
        Validate.notEmpty(tag2);
        Validate.notEmpty(attribute);
        Validate.notNull(removeProtocols);
        TagName tagName = TagName.valueOf(tag2);
        AttributeKey attr2 = AttributeKey.valueOf(attribute);
        Validate.isTrue(this.protocols.containsKey(tagName), "Cannot remove a protocol that is not set.");
        Map<AttributeKey, Set<Protocol>> tagProtocols = this.protocols.get(tagName);
        Validate.isTrue(tagProtocols.containsKey(attr2), "Cannot remove a protocol that is not set.");
        Set<Protocol> attrProtocols = tagProtocols.get(attr2);
        for (String protocol2 : removeProtocols) {
            Validate.notEmpty(protocol2);
            attrProtocols.remove(Protocol.valueOf(protocol2));
        }
        if (attrProtocols.isEmpty()) {
            tagProtocols.remove(attr2);
            if (tagProtocols.isEmpty()) {
                this.protocols.remove(tagName);
            }
        }
        return this;
    }

    public boolean isSafeTag(String tag2) {
        return this.tagNames.contains(TagName.valueOf(tag2));
    }

    public boolean isSafeAttribute(String tagName, Element el, Attribute attr2) {
        String attrKey;
        Attributes expect;
        TagName tag2 = TagName.valueOf(tagName);
        AttributeKey key2 = AttributeKey.valueOf(attr2.getKey());
        Set<AttributeKey> okSet = this.attributes.get(tag2);
        if (okSet != null && okSet.contains(key2)) {
            if (this.protocols.containsKey(tag2)) {
                Map<AttributeKey, Set<Protocol>> attrProts = this.protocols.get(tag2);
                return !attrProts.containsKey(key2) || this.testValidProtocol(el, attr2, attrProts.get(key2));
            }
            return true;
        }
        Map<AttributeKey, AttributeValue> enforcedSet = this.enforcedAttributes.get(tag2);
        if (enforcedSet != null && (expect = this.getEnforcedAttributes(tagName)).hasKeyIgnoreCase(attrKey = attr2.getKey())) {
            return expect.getIgnoreCase(attrKey).equals(attr2.getValue());
        }
        return !tagName.equals(All) && this.isSafeAttribute(All, el, attr2);
    }

    private boolean testValidProtocol(Element el, Attribute attr2, Set<Protocol> protocols) {
        String value2 = el.absUrl(attr2.getKey());
        if (value2.length() == 0) {
            value2 = attr2.getValue();
        }
        if (!this.preserveRelativeLinks) {
            attr2.setValue(value2);
        }
        for (Protocol protocol2 : protocols) {
            String prot = protocol2.toString();
            if (prot.equals("#")) {
                if (!this.isValidAnchor(value2)) continue;
                return true;
            }
            prot = prot + ":";
            if (!Normalizer.lowerCase(value2).startsWith(prot)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAnchor(String value2) {
        return value2.startsWith("#") && !value2.matches(".*\\s.*");
    }

    public Attributes getEnforcedAttributes(String tagName) {
        Attributes attrs = new Attributes();
        TagName tag2 = TagName.valueOf(tagName);
        if (this.enforcedAttributes.containsKey(tag2)) {
            Map<AttributeKey, AttributeValue> keyVals = this.enforcedAttributes.get(tag2);
            for (Map.Entry<AttributeKey, AttributeValue> entry : keyVals.entrySet()) {
                attrs.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return attrs;
    }

    static class TagName
    extends TypedValue {
        TagName(String value2) {
            super(value2);
        }

        static TagName valueOf(String value2) {
            return new TagName(Normalizer.lowerCase(value2));
        }
    }

    static class AttributeKey
    extends TypedValue {
        AttributeKey(String value2) {
            super(value2);
        }

        static AttributeKey valueOf(String value2) {
            return new AttributeKey(Normalizer.lowerCase(value2));
        }
    }

    static class AttributeValue
    extends TypedValue {
        AttributeValue(String value2) {
            super(value2);
        }

        static AttributeValue valueOf(String value2) {
            return new AttributeValue(value2);
        }
    }

    static class Protocol
    extends TypedValue {
        Protocol(String value2) {
            super(value2);
        }

        static Protocol valueOf(String value2) {
            return new Protocol(value2);
        }
    }

    static abstract class TypedValue {
        private final String value;

        TypedValue(String value2) {
            Validate.notNull(value2);
            this.value = value2;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.value == null ? 0 : this.value.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }

        public String toString() {
            return this.value;
        }
    }
}

