/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.parser.CharacterReader;

public class ParseError {
    private final int pos;
    private final String cursorPos;
    private final String errorMsg;

    ParseError(CharacterReader reader, String errorMsg) {
        this.pos = reader.pos();
        this.cursorPos = reader.posLineCol();
        this.errorMsg = errorMsg;
    }

    ParseError(CharacterReader reader, String errorFormat, Object ... args2) {
        this.pos = reader.pos();
        this.cursorPos = reader.posLineCol();
        this.errorMsg = String.format(errorFormat, args2);
    }

    ParseError(int pos2, String errorMsg) {
        this.pos = pos2;
        this.cursorPos = String.valueOf(pos2);
        this.errorMsg = errorMsg;
    }

    ParseError(int pos2, String errorFormat, Object ... args2) {
        this.pos = pos2;
        this.cursorPos = String.valueOf(pos2);
        this.errorMsg = String.format(errorFormat, args2);
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int getPosition() {
        return this.pos;
    }

    public String getCursorPos() {
        return this.cursorPos;
    }

    public String toString() {
        return "<" + this.cursorPos + ">: " + this.errorMsg;
    }
}

