/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import org.jsoup.UncheckedIOException;
import org.jsoup.helper.Validate;
import org.jspecify.annotations.Nullable;

public final class CharacterReader {
    static final char EOF = '\uffff';
    private static final int maxStringCacheLen = 12;
    static final int maxBufferLen = 32768;
    static final int readAheadLimit = 24576;
    private static final int minReadAheadLen = 1024;
    private char[] charBuf;
    private Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark = -1;
    private static final int stringCacheSize = 512;
    private String[] stringCache = new String[512];
    private @Nullable ArrayList<Integer> newlinePositions = null;
    private int lineNumberOffset = 1;
    private boolean readFully;
    private @Nullable String lastIcSeq;
    private int lastIcIndex;

    public CharacterReader(Reader input, int sz) {
        Validate.notNull(input);
        Validate.isTrue(input.markSupported(), "The supplied Reader must support mark(), but does not.");
        this.reader = input;
        this.charBuf = new char[Math.min(sz, 32768)];
        this.bufferUp();
    }

    public CharacterReader(Reader input) {
        this(input, 32768);
    }

    public CharacterReader(String input) {
        this(new StringReader(input), input.length());
    }

    public void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.reader = null;
            this.charBuf = null;
            this.stringCache = null;
        }
    }

    private void bufferUp() {
        int offset2;
        int pos2;
        if (this.readFully || this.bufPos < this.bufSplitPoint) {
            return;
        }
        if (this.bufMark != -1) {
            pos2 = this.bufMark;
            offset2 = this.bufPos - this.bufMark;
        } else {
            pos2 = this.bufPos;
            offset2 = 0;
        }
        try {
            int read2;
            int thisRead;
            long skipped = this.reader.skip(pos2);
            this.reader.mark(32768);
            for (read2 = 0; read2 <= 1024; read2 += thisRead) {
                thisRead = this.reader.read(this.charBuf, read2, this.charBuf.length - read2);
                if (thisRead == -1) {
                    this.readFully = true;
                }
                if (thisRead <= 0) break;
            }
            this.reader.reset();
            if (read2 > 0) {
                Validate.isTrue(skipped == (long)pos2);
                this.bufLength = read2;
                this.readerPos += pos2;
                this.bufPos = offset2;
                if (this.bufMark != -1) {
                    this.bufMark = 0;
                }
                this.bufSplitPoint = Math.min(this.bufLength, 24576);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.scanBufferForNewlines();
        this.lastIcSeq = null;
    }

    public int pos() {
        return this.readerPos + this.bufPos;
    }

    boolean readFully() {
        return this.readFully;
    }

    public void trackNewlines(boolean track) {
        if (track && this.newlinePositions == null) {
            this.newlinePositions = new ArrayList(409);
            this.scanBufferForNewlines();
        } else if (!track) {
            this.newlinePositions = null;
        }
    }

    public boolean isTrackNewlines() {
        return this.newlinePositions != null;
    }

    public int lineNumber() {
        return this.lineNumber(this.pos());
    }

    int lineNumber(int pos2) {
        if (!this.isTrackNewlines()) {
            return 1;
        }
        int i2 = this.lineNumIndex(pos2);
        if (i2 == -1) {
            return this.lineNumberOffset;
        }
        return i2 + this.lineNumberOffset + 1;
    }

    public int columnNumber() {
        return this.columnNumber(this.pos());
    }

    int columnNumber(int pos2) {
        if (!this.isTrackNewlines()) {
            return pos2 + 1;
        }
        int i2 = this.lineNumIndex(pos2);
        if (i2 == -1) {
            return pos2 + 1;
        }
        return pos2 - this.newlinePositions.get(i2) + 1;
    }

    String posLineCol() {
        return this.lineNumber() + ":" + this.columnNumber();
    }

    private int lineNumIndex(int pos2) {
        if (!this.isTrackNewlines()) {
            return 0;
        }
        int i2 = Collections.binarySearch(this.newlinePositions, pos2);
        if (i2 < -1) {
            i2 = Math.abs(i2) - 2;
        }
        return i2;
    }

    private void scanBufferForNewlines() {
        if (!this.isTrackNewlines()) {
            return;
        }
        if (this.newlinePositions.size() > 0) {
            int index2 = this.lineNumIndex(this.readerPos);
            if (index2 == -1) {
                index2 = 0;
            }
            int linePos = this.newlinePositions.get(index2);
            this.lineNumberOffset += index2;
            this.newlinePositions.clear();
            this.newlinePositions.add(linePos);
        }
        for (int i2 = this.bufPos; i2 < this.bufLength; ++i2) {
            if (this.charBuf[i2] != '\n') continue;
            this.newlinePositions.add(1 + this.readerPos + i2);
        }
    }

    public boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public char current() {
        this.bufferUp();
        return this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
    }

    char consume() {
        this.bufferUp();
        char val = this.isEmptyNoBufferUp() ? (char)'\uffff' : this.charBuf[this.bufPos];
        ++this.bufPos;
        return val;
    }

    void unconsume() {
        if (this.bufPos < 1) {
            throw new UncheckedIOException(new IOException("WTF: No buffer left to unconsume."));
        }
        --this.bufPos;
    }

    public void advance() {
        ++this.bufPos;
    }

    void mark() {
        if (this.bufLength - this.bufPos < 1024) {
            this.bufSplitPoint = 0;
        }
        this.bufferUp();
        this.bufMark = this.bufPos;
    }

    void unmark() {
        this.bufMark = -1;
    }

    void rewindToMark() {
        if (this.bufMark == -1) {
            throw new UncheckedIOException(new IOException("Mark invalid"));
        }
        this.bufPos = this.bufMark;
        this.unmark();
    }

    int nextIndexOf(char c) {
        this.bufferUp();
        for (int i2 = this.bufPos; i2 < this.bufLength; ++i2) {
            if (c != this.charBuf[i2]) continue;
            return i2 - this.bufPos;
        }
        return -1;
    }

    int nextIndexOf(CharSequence seq) {
        this.bufferUp();
        char startChar = seq.charAt(0);
        for (int offset2 = this.bufPos; offset2 < this.bufLength; ++offset2) {
            if (startChar != this.charBuf[offset2]) {
                while (++offset2 < this.bufLength && startChar != this.charBuf[offset2]) {
                }
            }
            int i2 = offset2 + 1;
            int last2 = i2 + seq.length() - 1;
            if (offset2 >= this.bufLength || last2 > this.bufLength) continue;
            int j = 1;
            while (i2 < last2 && seq.charAt(j) == this.charBuf[i2]) {
                ++i2;
                ++j;
            }
            if (i2 != last2) continue;
            return offset2 - this.bufPos;
        }
        return -1;
    }

    public String consumeTo(char c) {
        int offset2 = this.nextIndexOf(c);
        if (offset2 != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset2);
            this.bufPos += offset2;
            return consumed;
        }
        return this.consumeToEnd();
    }

    String consumeTo(String seq) {
        int offset2 = this.nextIndexOf(seq);
        if (offset2 != -1) {
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset2);
            this.bufPos += offset2;
            return consumed;
        }
        if (this.bufLength - this.bufPos < seq.length()) {
            return this.consumeToEnd();
        }
        int endPos = this.bufLength - seq.length() + 1;
        String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, endPos - this.bufPos);
        this.bufPos = endPos;
        return consumed;
    }

    public String consumeToAny(char ... chars2) {
        int pos2;
        this.bufferUp();
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        int charLen = chars2.length;
        block0: while (pos2 < remaining) {
            for (int i2 = 0; i2 < charLen; ++i2) {
                if (val[pos2] == chars2[i2]) break block0;
            }
            ++pos2;
        }
        this.bufPos = pos2;
        return pos2 > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2) : "";
    }

    String consumeToAnySorted(char ... chars2) {
        int pos2;
        this.bufferUp();
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (pos2 < remaining && Arrays.binarySearch(chars2, val[pos2]) < 0) {
            ++pos2;
        }
        this.bufPos = pos2;
        return this.bufPos > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2) : "";
    }

    String consumeData() {
        int pos2;
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos2 < remaining) {
            switch (val[pos2]) {
                case '\u0000': 
                case '&': 
                case '<': {
                    break block3;
                }
                default: {
                    ++pos2;
                    continue block3;
                }
            }
        }
        this.bufPos = pos2;
        return pos2 > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2) : "";
    }

    /*
     * Enabled aggressive block sorting
     */
    String consumeAttributeQuoted(boolean single) {
        int pos2;
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block5: while (pos2 < remaining) {
            switch (val[pos2]) {
                case '\u0000': 
                case '&': {
                    break block5;
                }
                case '\'': {
                    if (!single) break;
                    break block5;
                }
                case '\"': {
                    if (!single) break block5;
                }
            }
            ++pos2;
        }
        this.bufPos = pos2;
        if (pos2 <= start2) return "";
        String string2 = CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2);
        return string2;
    }

    String consumeRawData() {
        int pos2;
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos2 < remaining) {
            switch (val[pos2]) {
                case '\u0000': 
                case '<': {
                    break block3;
                }
                default: {
                    ++pos2;
                    continue block3;
                }
            }
        }
        this.bufPos = pos2;
        return pos2 > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2) : "";
    }

    String consumeTagName() {
        int pos2;
        this.bufferUp();
        int start2 = pos2 = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos2 < remaining) {
            switch (val[pos2]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '<': 
                case '>': {
                    break block3;
                }
                default: {
                    ++pos2;
                    continue block3;
                }
            }
        }
        this.bufPos = pos2;
        return pos2 > start2 ? CharacterReader.cacheString(this.charBuf, this.stringCache, start2, pos2 - start2) : "";
    }

    String consumeToEnd() {
        this.bufferUp();
        String data2 = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return data2;
    }

    String consumeLetterSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeLetterThenDigitSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp() && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeHexSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    String consumeDigitSequence() {
        char c;
        this.bufferUp();
        int start2 = this.bufPos;
        while (this.bufPos < this.bufLength && (c = this.charBuf[this.bufPos]) >= '0' && c <= '9') {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start2, this.bufPos - start2);
    }

    boolean matches(char c) {
        return !this.isEmpty() && this.charBuf[this.bufPos] == c;
    }

    boolean matches(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            if (seq.charAt(offset2) == this.charBuf[this.bufPos + offset2]) continue;
            return false;
        }
        return true;
    }

    boolean matchesIgnoreCase(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset2 = 0; offset2 < scanLength; ++offset2) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset2));
            if (upScan == (upTarget = Character.toUpperCase(this.charBuf[this.bufPos + offset2]))) continue;
            return false;
        }
        return true;
    }

    boolean matchesAny(char ... seq) {
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        for (char seek2 : seq) {
            if (seek2 != c) continue;
            return true;
        }
        return false;
    }

    boolean matchesAnySorted(char[] seq) {
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch(seq, this.charBuf[this.bufPos]) >= 0;
    }

    boolean matchesLetter() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c);
    }

    boolean matchesAsciiAlpha() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    boolean matchesDigit() {
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && c <= '9';
    }

    boolean matchConsume(String seq) {
        this.bufferUp();
        if (this.matches(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            this.bufPos += seq.length();
            return true;
        }
        return false;
    }

    boolean containsIgnoreCase(String seq) {
        if (seq.equals(this.lastIcSeq)) {
            if (this.lastIcIndex == -1) {
                return false;
            }
            if (this.lastIcIndex >= this.bufPos) {
                return true;
            }
        }
        this.lastIcSeq = seq;
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        int lo = this.nextIndexOf(loScan);
        if (lo > -1) {
            this.lastIcIndex = this.bufPos + lo;
            return true;
        }
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        int hi = this.nextIndexOf(hiScan);
        boolean found = hi > -1;
        this.lastIcIndex = found ? this.bufPos + hi : -1;
        return found;
    }

    public String toString() {
        if (this.bufLength - this.bufPos < 0) {
            return "";
        }
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    private static String cacheString(char[] charBuf, String[] stringCache, int start2, int count2) {
        if (count2 > 12) {
            return new String(charBuf, start2, count2);
        }
        if (count2 < 1) {
            return "";
        }
        int hash2 = 0;
        for (int i2 = 0; i2 < count2; ++i2) {
            hash2 = 31 * hash2 + charBuf[start2 + i2];
        }
        int index2 = hash2 & 0x1FF;
        String cached = stringCache[index2];
        if (cached != null && CharacterReader.rangeEquals(charBuf, start2, count2, cached)) {
            return cached;
        }
        stringCache[index2] = cached = new String(charBuf, start2, count2);
        return cached;
    }

    static boolean rangeEquals(char[] charBuf, int start2, int count2, String cached) {
        if (count2 == cached.length()) {
            int i2 = start2;
            int j = 0;
            while (count2-- != 0) {
                if (charBuf[i2++] == cached.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean rangeEquals(int start2, int count2, String cached) {
        return CharacterReader.rangeEquals(this.charBuf, start2, count2, cached);
    }
}

