/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.nodes.Node;

public class Range {
    private static final Position UntrackedPos = new Position(-1, -1, -1);
    private final Position start;
    private final Position end;
    static final Range Untracked = new Range(UntrackedPos, UntrackedPos);

    public Range(Position start2, Position end2) {
        this.start = start2;
        this.end = end2;
    }

    public Position start() {
        return this.start;
    }

    public int startPos() {
        return this.start.pos;
    }

    public Position end() {
        return this.end;
    }

    public int endPos() {
        return this.end.pos;
    }

    public boolean isTracked() {
        return this != Untracked;
    }

    public boolean isImplicit() {
        if (!this.isTracked()) {
            return false;
        }
        return this.start.equals(this.end);
    }

    static Range of(Node node, boolean start2) {
        String key2;
        String string2 = key2 = start2 ? "jsoup.start" : "jsoup.end";
        if (!node.hasAttributes()) {
            return Untracked;
        }
        Object range = node.attributes().userData(key2);
        return range != null ? (Range)range : Untracked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (!this.start.equals(range.start)) {
            return false;
        }
        return this.end.equals(range.end);
    }

    public int hashCode() {
        int result2 = this.start.hashCode();
        result2 = 31 * result2 + this.end.hashCode();
        return result2;
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public static class Position {
        private final int pos;
        private final int lineNumber;
        private final int columnNumber;

        public Position(int pos2, int lineNumber, int columnNumber) {
            this.pos = pos2;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public int pos() {
            return this.pos;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public int columnNumber() {
            return this.columnNumber;
        }

        public boolean isTracked() {
            return this != UntrackedPos;
        }

        public String toString() {
            return this.lineNumber + "," + this.columnNumber + ":" + this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            if (this.pos != position.pos) {
                return false;
            }
            if (this.lineNumber != position.lineNumber) {
                return false;
            }
            return this.columnNumber == position.columnNumber;
        }

        public int hashCode() {
            int result2 = this.pos;
            result2 = 31 * result2 + this.lineNumber;
            result2 = 31 * result2 + this.columnNumber;
            return result2;
        }
    }

    public static class AttributeRange {
        static final AttributeRange UntrackedAttr = new AttributeRange(Untracked, Untracked);
        private final Range nameRange;
        private final Range valueRange;

        public AttributeRange(Range nameRange, Range valueRange) {
            this.nameRange = nameRange;
            this.valueRange = valueRange;
        }

        public Range nameRange() {
            return this.nameRange;
        }

        public Range valueRange() {
            return this.valueRange;
        }

        public String toString() {
            return this.nameRange().toString() + "=" + this.valueRange().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeRange that = (AttributeRange)o;
            if (!this.nameRange.equals(that.nameRange)) {
                return false;
            }
            return this.valueRange.equals(that.valueRange);
        }

        public int hashCode() {
            int result2 = this.nameRange.hashCode();
            result2 = 31 * result2 + this.valueRange.hashCode();
            return result2;
        }
    }
}

