/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Node;
import org.jspecify.annotations.Nullable;

public class NodeIterator<T extends Node>
implements Iterator<T> {
    private Node root;
    private @Nullable T next;
    private Node current;
    private Node previous;
    private @Nullable Node currentParent;
    private final Class<T> type;

    public NodeIterator(Node start2, Class<T> type2) {
        Validate.notNull(start2);
        Validate.notNull(type2);
        this.type = type2;
        this.restart(start2);
    }

    public static NodeIterator<Node> from(Node start2) {
        return new NodeIterator<Node>(start2, Node.class);
    }

    public void restart(Node start2) {
        if (this.type.isInstance(start2)) {
            this.next = start2;
        }
        this.previous = this.current = start2;
        this.root = this.current;
        this.currentParent = this.current.parent();
    }

    @Override
    public boolean hasNext() {
        this.maybeFindNext();
        return this.next != null;
    }

    @Override
    public T next() {
        this.maybeFindNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T result2 = this.next;
        this.previous = this.current;
        this.current = this.next;
        this.currentParent = this.current.parent();
        this.next = null;
        return result2;
    }

    private void maybeFindNext() {
        if (this.next != null) {
            return;
        }
        if (this.currentParent != null && !this.current.hasParent()) {
            this.current = this.previous;
        }
        this.next = this.findNextNode();
    }

    private @Nullable T findNextNode() {
        Node node = this.current;
        do {
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
            } else if (this.root.equals(node)) {
                node = null;
            } else if (node.nextSibling() != null) {
                node = node.nextSibling();
            } else {
                do {
                    if ((node = node.parent()) != null && !this.root.equals(node)) continue;
                    return null;
                } while (node.nextSibling() == null);
                node = node.nextSibling();
            }
            if (node != null) continue;
            return null;
        } while (!this.type.isInstance(node));
        return (T)node;
    }

    @Override
    public void remove() {
        this.current.remove();
    }
}

