/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.jsoup.Progress;
import org.jsoup.helper.Validate;
import org.jspecify.annotations.Nullable;

public class ControllableInputStream
extends FilterInputStream {
    private final BufferedInputStream buff;
    private final boolean capped;
    private final int maxSize;
    private long startTime;
    private long timeout = 0L;
    private int remaining;
    private int markPos;
    private boolean interrupted;
    private @Nullable Progress<?> progress;
    private @Nullable Object progressContext;
    private int contentLength = -1;
    private int readPos = 0;

    private ControllableInputStream(BufferedInputStream in, int maxSize) {
        super(in);
        Validate.isTrue(maxSize >= 0);
        this.buff = in;
        this.capped = maxSize != 0;
        this.maxSize = maxSize;
        this.remaining = maxSize;
        this.markPos = -1;
        this.startTime = System.nanoTime();
    }

    public static ControllableInputStream wrap(InputStream in, int bufferSize, int maxSize) {
        if (in instanceof ControllableInputStream) {
            return (ControllableInputStream)in;
        }
        if (in instanceof BufferedInputStream) {
            return new ControllableInputStream((BufferedInputStream)in, maxSize);
        }
        return new ControllableInputStream(new BufferedInputStream(in, bufferSize), maxSize);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.readPos == 0) {
            this.emitProgress();
        }
        if (this.interrupted || this.capped && this.remaining <= 0) {
            return -1;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            return -1;
        }
        if (this.expired()) {
            throw new SocketTimeoutException("Read timeout");
        }
        if (this.capped && len > this.remaining) {
            len = this.remaining;
        }
        try {
            int read2 = super.read(b2, off, len);
            if (read2 == -1) {
                this.contentLength = this.readPos;
            } else {
                this.remaining -= read2;
                this.readPos += read2;
            }
            this.emitProgress();
            return read2;
        }
        catch (SocketTimeoutException e) {
            if (this.expired()) {
                throw e;
            }
            return 0;
        }
    }

    public static ByteBuffer readToByteBuffer(InputStream in, int max2) throws IOException {
        int read2;
        Validate.isTrue(max2 >= 0, "maxSize must be 0 (unlimited) or larger");
        Validate.notNull(in);
        boolean localCapped = max2 > 0;
        int bufferSize = localCapped && max2 < 32768 ? max2 : 32768;
        byte[] readBuffer = new byte[bufferSize];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(bufferSize);
        int remaining = max2;
        while ((read2 = in.read(readBuffer, 0, localCapped ? Math.min(remaining, bufferSize) : bufferSize)) != -1) {
            if (localCapped) {
                if (read2 >= remaining) {
                    outStream.write(readBuffer, 0, remaining);
                    break;
                }
                remaining -= read2;
            }
            outStream.write(readBuffer, 0, read2);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.remaining = this.maxSize - this.markPos;
        this.readPos = this.markPos;
    }

    @Override
    public void mark(int readlimit) {
        super.mark(readlimit);
        this.markPos = this.maxSize - this.remaining;
    }

    public ControllableInputStream timeout(long startTimeNanos, long timeoutMillis) {
        this.startTime = startTimeNanos;
        this.timeout = timeoutMillis * 1000000L;
        return this;
    }

    private void emitProgress() {
        if (this.progress == null) {
            return;
        }
        float percent = this.contentLength > 0 ? Math.min(100.0f, (float)this.readPos * 100.0f / (float)this.contentLength) : 0.0f;
        this.progress.onProgress(this.readPos, this.contentLength, percent, this.progressContext);
        if (percent == 100.0f) {
            this.progress = null;
        }
    }

    public <ProgressContext> ControllableInputStream onProgress(int contentLength, Progress<ProgressContext> callback, ProgressContext context) {
        Validate.notNull(callback);
        Validate.notNull(context);
        this.contentLength = contentLength;
        this.progress = callback;
        this.progressContext = context;
        return this;
    }

    private boolean expired() {
        if (this.timeout == 0L) {
            return false;
        }
        long now2 = System.nanoTime();
        long dur = now2 - this.startTime;
        return dur > this.timeout;
    }

    public BufferedInputStream inputStream() {
        return this.buff;
    }
}

