/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import jnr.posix.JavaSecuredFile;

public class NormalizedFile
extends JavaSecuredFile {
    private static final long serialVersionUID = 7630618150344842227L;

    public NormalizedFile(String pathname2) {
        super(pathname2);
    }

    public NormalizedFile(URI uri) {
        super(uri);
    }

    public NormalizedFile(File parent, String child) {
        super(parent, child);
    }

    public NormalizedFile(String parent, String child) {
        super(parent, child);
    }

    @Override
    public String getAbsolutePath() {
        return new File(super.getPath()).getAbsolutePath().replace(File.separatorChar, '/');
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath().replace(File.separatorChar, '/');
    }

    @Override
    public String getPath() {
        return super.getPath().replace(File.separatorChar, '/');
    }

    @Override
    public String toString() {
        return super.toString().replace(File.separatorChar, '/');
    }

    @Override
    public File getAbsoluteFile() {
        return new NormalizedFile(this.getAbsolutePath());
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new NormalizedFile(this.getCanonicalPath());
    }

    @Override
    public String getParent() {
        return super.getParent().replace(File.separatorChar, '/');
    }

    @Override
    public File getParentFile() {
        return new NormalizedFile(this.getParent());
    }

    public static File[] listRoots() {
        File[] roots = File.listRoots();
        File[] smartRoots = new NormalizedFile[roots.length];
        for (int i2 = 0; i2 < roots.length; ++i2) {
            smartRoots[i2] = new NormalizedFile(roots[i2].getPath());
        }
        return smartRoots;
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File file2 = File.createTempFile(prefix, suffix, directory);
        return new NormalizedFile(file2.getPath());
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file2 = File.createTempFile(prefix, suffix);
        return new NormalizedFile(file2.getPath());
    }

    @Override
    public String[] list() {
        return super.list();
    }

    @Override
    public String[] list(FilenameFilter filter2) {
        String[] files = super.list(filter2);
        if (files == null) {
            return null;
        }
        String[] smartFiles = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = files[i2].replace(File.separatorChar, '/');
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles() {
        File[] files = super.listFiles();
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FileFilter filter2) {
        File[] files = super.listFiles(filter2);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    @Override
    public File[] listFiles(FilenameFilter filter2) {
        File[] files = super.listFiles(filter2);
        if (files == null) {
            return null;
        }
        File[] smartFiles = new NormalizedFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            smartFiles[i2] = new NormalizedFile(files[i2].getPath());
        }
        return smartFiles;
    }

    public static String getFileProperty(String property) {
        String value2 = System.getProperty(property);
        return value2.replace(File.separatorChar, '/');
    }
}

