/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.profile.builtin.FlatProfilePrinter;
import org.jruby.runtime.profile.builtin.GraphProfilePrinter;
import org.jruby.runtime.profile.builtin.HtmlProfilePrinter;
import org.jruby.runtime.profile.builtin.Invocation;
import org.jruby.runtime.profile.builtin.JsonProfilePrinter;
import org.jruby.runtime.profile.builtin.MethodData;
import org.jruby.runtime.profile.builtin.ProfileData;
import org.jruby.runtime.profile.builtin.ProfiledMethod;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.collections.IntHashMap;

public abstract class ProfilePrinter {
    private final ProfileData profileData;
    private final Invocation topInvocation;
    private static final String PROFILER_START_METHOD = "JRuby::Profiler.start";
    private static final String PROFILER_STOP_METHOD = "JRuby::Profiler.stop";
    static final String PROFILER_PROFILE_METHOD = "JRuby::Profiler.profile";
    static final String PROFILER_PROFILED_CODE_METHOD = "JRuby::Profiler.profiled_code";

    public static ProfilePrinter newPrinter(RubyInstanceConfig.ProfilingMode mode2, ProfileData profileData) {
        return ProfilePrinter.newPrinter(mode2, profileData, null);
    }

    static ProfilePrinter newPrinter(RubyInstanceConfig.ProfilingMode mode2, ProfileData profileData, Invocation topInvocation) {
        if (topInvocation == null) {
            topInvocation = profileData.computeResults();
        }
        ProfilePrinter printer = mode2 == RubyInstanceConfig.ProfilingMode.FLAT ? new FlatProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.GRAPH ? new GraphProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.HTML ? new HtmlProfilePrinter(profileData, topInvocation) : (mode2 == RubyInstanceConfig.ProfilingMode.JSON ? new JsonProfilePrinter(profileData, topInvocation) : null)));
        return printer;
    }

    protected ProfilePrinter(ProfileData profileData) {
        this(profileData, profileData.computeResults());
    }

    protected ProfilePrinter(ProfileData profileData, Invocation topInvocation) {
        this.profileData = profileData;
        this.topInvocation = topInvocation;
    }

    public ProfileData getProfileData() {
        return this.profileData;
    }

    protected Invocation getTopInvocation() {
        return this.topInvocation;
    }

    public void printHeader(PrintStream out) {
    }

    public void printFooter(PrintStream out) {
    }

    public void printProfile(PrintStream out) {
        this.printProfile(out, true);
    }

    public abstract void printProfile(PrintStream var1, boolean var2);

    public void printProfile(RubyIO out) {
        this.printProfile(new PrintStream(out.getOutStream()));
    }

    boolean isProfilerInvocation(Invocation inv) {
        return this.isThisProfilerInvocation(inv.getMethodSerialNumber()) || inv.getParent() != null && this.isProfilerInvocation(inv.getParent());
    }

    boolean isThisProfilerInvocation(int serial) {
        String start2 = PROFILER_START_METHOD;
        String stop2 = PROFILER_STOP_METHOD;
        String name2 = this.methodName(serial);
        return name2.hashCode() == PROFILER_START_METHOD.hashCode() && name2.equals(PROFILER_START_METHOD) || name2.hashCode() == PROFILER_STOP_METHOD.hashCode() && name2.equals(PROFILER_STOP_METHOD);
    }

    public String getThreadName() {
        if (this.getProfileData().getThreadContext().getThread() == null) {
            return Thread.currentThread().getName();
        }
        return this.getProfileData().getThreadContext().getThread().getNativeThread().getName();
    }

    public String methodName(int serial) {
        return this.profileData.methodName(serial);
    }

    static String methodName(ProfiledMethod profileMethod) {
        String displayName;
        if (profileMethod != null) {
            DynamicMethod method2 = profileMethod.getMethod();
            String id2 = profileMethod.getName();
            if (id2 == null) {
                id2 = method2.getName();
            }
            displayName = ProfilePrinter.moduleHashMethod(method2.getImplementationClass(), id2.toString());
        } else {
            displayName = "<unknown>";
        }
        return displayName;
    }

    protected static IntHashMap<MethodData> methodData(Invocation top) {
        IntHashMap<MethodData> methods2 = new IntHashMap<MethodData>();
        MethodData data2 = new MethodData(0);
        methods2.put(0, data2);
        data2.invocations.add(top);
        ProfilePrinter.methodData1(methods2, top);
        return methods2;
    }

    private static void methodData1(IntHashMap<MethodData> methods2, Invocation inv) {
        for (IntHashMap.Entry<Invocation> entry : inv.getChildren().entrySet()) {
            Invocation child = entry.getValue();
            int serial = child.getMethodSerialNumber();
            MethodData data2 = methods2.get(serial);
            if (data2 == null) {
                data2 = new MethodData(serial);
                methods2.put(serial, data2);
            }
            data2.invocations.add(child);
            ProfilePrinter.methodData1(methods2, child);
        }
    }

    private static String moduleHashMethod(RubyModule module, String id2) {
        Ruby runtime2 = module.getRuntime();
        if (module instanceof MetaClass) {
            RubyBasicObject obj = ((MetaClass)module).getAttached();
            if (obj instanceof RubyModule) {
                return RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)obj), ".", RubyStringBuilder.ids(runtime2, id2));
            }
            if (obj instanceof RubyObject) {
                return RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)obj.getType()), "(singleton)#", RubyStringBuilder.ids(runtime2, id2));
            }
            return RubyStringBuilder.str(runtime2, "unknown#", RubyStringBuilder.ids(runtime2, id2));
        }
        if (module.isSingleton()) {
            return RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)((RubyClass)module).getRealClass()), "(singleton)#", RubyStringBuilder.ids(runtime2, id2));
        }
        if (module instanceof RubyClass) {
            return RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, module), "#", RubyStringBuilder.ids(runtime2, id2));
        }
        return RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, module), ".", RubyStringBuilder.ids(runtime2, id2));
    }

    protected static void pad(PrintStream out, int size2, String body2) {
        ProfilePrinter.pad(out, size2, body2, true);
    }

    protected static void pad(PrintStream out, int size2, String body2, boolean front) {
        int i2;
        if (front) {
            for (i2 = 0; i2 < size2 - body2.length(); ++i2) {
                out.print(' ');
            }
        }
        out.print(body2);
        if (!front) {
            for (i2 = 0; i2 < size2 - body2.length(); ++i2) {
                out.print(' ');
            }
        }
    }

    protected static String nanoString(long nanoTime) {
        DecimalFormat formatter = new DecimalFormat("##0.00");
        return formatter.format((double)nanoTime / 1.0E9);
    }
}

