/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Handle;

public class StringBootstrap {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Handle BYTELIST_BOOTSTRAP = new Handle(6, CodegenUtils.p(StringBootstrap.class), "bytelist", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class), false);
    public static final Handle STRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(StringBootstrap.class), "string", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE), false);
    public static final Handle EMPTY_STRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(StringBootstrap.class), "emptyString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class), false);
    public static final Handle BUFFER_STRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(StringBootstrap.class), "bufferString", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE), false);
    public static final Handle FSTRING_BOOTSTRAP = new Handle(6, CodegenUtils.p(StringBootstrap.class), "fstring", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE), false);
    private static final MethodHandle STRING_HANDLE = Binder.from(RubyString.class, ThreadContext.class, ByteList.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, StringBootstrap.class, "string");
    private static final MethodHandle FSTRING_HANDLE = Binder.from(RubyString.class, ThreadContext.class, MutableCallSite.class, ByteList.class, Integer.TYPE, String.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, StringBootstrap.class, "frozenString");
    private static final MethodHandle BUFFERSTRING_HANDLE = Binder.from(RubyString.class, ThreadContext.class, Encoding.class, Integer.TYPE, Integer.TYPE).invokeStaticQuiet(LOOKUP, StringBootstrap.class, "bufferString");

    public static CallSite bytelist(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName) {
        return new ConstantCallSite(MethodHandles.constant(ByteList.class, StringBootstrap.bytelist(value2, encodingName)));
    }

    public static CallSite string(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr) {
        return new ConstantCallSite(MethodHandles.insertArguments(STRING_HANDLE, 1, StringBootstrap.bytelist(value2, encodingName), cr));
    }

    public static CallSite emptyString(MethodHandles.Lookup lookup, String name2, MethodType type2, String encodingName) {
        RubyString.EmptyByteListHolder holder = RubyString.getEmptyByteList(StringBootstrap.encodingFromName(encodingName));
        return new ConstantCallSite(MethodHandles.insertArguments(STRING_HANDLE, 1, holder.bytes, holder.cr));
    }

    public static CallSite bufferString(MethodHandles.Lookup lookup, String name2, MethodType type2, String encodingName, int size2) {
        return new ConstantCallSite(MethodHandles.insertArguments(BUFFERSTRING_HANDLE, 1, StringBootstrap.encodingFromName(encodingName), size2, 16));
    }

    public static CallSite fstring(MethodHandles.Lookup lookup, String name2, MethodType type2, String value2, String encodingName, int cr, String file2, int line) {
        MutableCallSite site = new MutableCallSite(type2);
        site.setTarget(MethodHandles.insertArguments(FSTRING_HANDLE, 1, site, StringBootstrap.bytelist(value2, encodingName), cr, file2, line));
        return site;
    }

    public static RubyString string(ThreadContext context, ByteList value2, int cr) {
        return RubyString.newStringShared(context.runtime, value2, cr);
    }

    public static RubyString bufferString(ThreadContext context, Encoding encoding2, int size2, int cr) {
        return RubyString.newString(context.runtime, new ByteList(size2, encoding2), cr);
    }

    public static RubyString frozenString(ThreadContext context, MutableCallSite site, ByteList value2, int cr, String file2, int line) {
        RubyString frozen = IRRuntimeHelpers.newFrozenString(context, value2, cr, file2, line);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyString.class, frozen), 0, new Class[]{ThreadContext.class}));
        return frozen;
    }

    public static ByteList bytelist(String value2, String encodingName) {
        Encoding encoding2 = StringBootstrap.encodingFromName(encodingName);
        if (value2.length() == 0) {
            return RubyString.getEmptyByteList((Encoding)encoding2).bytes;
        }
        return new ByteList(RubyEncoding.encodeISO(value2), encoding2, false);
    }

    public static ByteList bytelist(int size2, String encodingName) {
        Encoding encoding2 = StringBootstrap.encodingFromName(encodingName);
        return new ByteList(size2, encoding2);
    }

    private static Encoding encodingFromName(String encodingName) {
        EncodingDB.Entry entry = EncodingDB.getEncodings().get(encodingName.getBytes());
        if (entry == null) {
            entry = EncodingDB.getAliases().get(encodingName.getBytes());
        }
        if (entry == null) {
            throw new RuntimeException("could not find encoding: " + encodingName);
        }
        Encoding encoding2 = entry.getEncoding();
        return encoding2;
    }
}

