/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Profile;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyInstanceConfigAdapter;
import org.jruby.embed.EmbedRubyInterfaceAdapter;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.ConcurrentLocalContextProvider;
import org.jruby.embed.internal.EmbedRubyInterfaceAdapterImpl;
import org.jruby.embed.internal.EmbedRubyObjectAdapterImpl;
import org.jruby.embed.internal.EmbedRubyRuntimeAdapterImpl;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.embed.internal.SingleThreadLocalContextProvider;
import org.jruby.embed.internal.SingletonLocalContextProvider;
import org.jruby.embed.internal.ThreadSafeLocalContextProvider;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.io.WriterOutputStream;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.builtin.ProfileOutput;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.OutputStrings;

public class ScriptingContainer
implements EmbedRubyInstanceConfigAdapter {
    private final Map<String, String[]> basicProperties;
    private final LocalContextScope scope;
    private final LocalContextProvider provider;
    private final EmbedRubyRuntimeAdapter runtimeAdapter;
    private final EmbedRubyObjectAdapter objectAdapter;
    private final EmbedRubyInterfaceAdapter interfaceAdapter;

    public ScriptingContainer() {
        this(LocalContextScope.SINGLETON, LocalVariableBehavior.TRANSIENT, true);
    }

    public ScriptingContainer(LocalContextScope scope) {
        this(scope, LocalVariableBehavior.TRANSIENT, true);
    }

    public ScriptingContainer(LocalVariableBehavior behavior) {
        this(LocalContextScope.SINGLETON, behavior, true);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior) {
        this(scope, behavior, true);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        this(scope, behavior, lazy, true);
    }

    public ScriptingContainer(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy, boolean wrapExceptions) {
        this.provider = ScriptingContainer.getProviderInstance(scope, behavior, lazy);
        this.scope = scope;
        this.initRubyInstanceConfig();
        this.basicProperties = ScriptingContainer.getBasicProperties();
        this.runtimeAdapter = new EmbedRubyRuntimeAdapterImpl(this, wrapExceptions);
        this.objectAdapter = new EmbedRubyObjectAdapterImpl(this, wrapExceptions);
        this.interfaceAdapter = new EmbedRubyInterfaceAdapterImpl(this);
    }

    static LocalContextProvider getProviderInstance(LocalContextScope scope, LocalVariableBehavior behavior, boolean lazy) {
        switch (scope) {
            case THREADSAFE: {
                return new ThreadSafeLocalContextProvider(behavior, lazy);
            }
            case CONCURRENT: {
                return new ConcurrentLocalContextProvider(behavior, lazy);
            }
            case SINGLETHREAD: {
                return new SingleThreadLocalContextProvider(behavior, lazy);
            }
        }
        return SingletonLocalContextProvider.getProvider(behavior, lazy);
    }

    private void initRubyInstanceConfig() throws RaiseException {
        String home2 = SafePropertyAccessor.getenv("JRUBY_HOME");
        if (home2 != null) {
            this.provider.getRubyInstanceConfig().setJRubyHome(home2);
        }
        this.provider.getRubyInstanceConfig().setScriptFileName("<script>");
    }

    private static Map<String, String[]> getBasicProperties() {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        properties.put("container.ids", new String[]{"ruby", "jruby"});
        properties.put("language.extension", new String[]{"rb"});
        properties.put("language.name", new String[]{"ruby"});
        properties.put("language.mimetypes", new String[]{"application/x-ruby"});
        return properties;
    }

    @Override
    public List<String> getLoadPaths() {
        return this.provider.getRubyInstanceConfig().getLoadPaths();
    }

    @Override
    public void setLoadPaths(List<String> paths) {
        this.provider.getRubyInstanceConfig().setLoadPaths(paths);
    }

    @Override
    public InputStream getInput() {
        return this.provider.getRubyInstanceConfig().getInput();
    }

    @Override
    public void setInput(InputStream istream) {
        this.provider.getRubyInstanceConfig().setInput(istream);
    }

    @Override
    public void setInput(Reader reader) {
        if (reader == null) {
            this.provider.getRubyInstanceConfig().setInput(null);
        } else {
            ReaderInputStream istream = new ReaderInputStream(reader);
            this.provider.getRubyInstanceConfig().setInput(istream);
        }
    }

    @Override
    public PrintStream getOutput() {
        return this.provider.getRubyInstanceConfig().getOutput();
    }

    @Override
    public void setOutput(PrintStream pstream) {
        this.provider.getRubyInstanceConfig().setOutput(pstream);
    }

    @Override
    public void setOutput(Writer writer) {
        if (writer == null) {
            this.provider.getRubyInstanceConfig().setOutput(null);
        } else {
            WriterOutputStream ostream = new WriterOutputStream(writer);
            PrintStream pstream = new PrintStream(ostream);
            this.provider.getRubyInstanceConfig().setOutput(pstream);
        }
    }

    @Override
    public PrintStream getError() {
        return this.provider.getRubyInstanceConfig().getError();
    }

    @Override
    public void setError(PrintStream pstream) {
        this.provider.getRubyInstanceConfig().setError(pstream);
    }

    @Override
    public void setError(Writer writer) {
        if (writer == null) {
            this.provider.getRubyInstanceConfig().setError(null);
        } else {
            WriterOutputStream ostream = new WriterOutputStream(writer);
            PrintStream pstream = new PrintStream(ostream);
            this.provider.getRubyInstanceConfig().setError(pstream);
        }
    }

    @Override
    public RubyInstanceConfig.CompileMode getCompileMode() {
        return this.provider.getRubyInstanceConfig().getCompileMode();
    }

    @Override
    public void setCompileMode(RubyInstanceConfig.CompileMode mode2) {
        this.provider.getRubyInstanceConfig().setCompileMode(mode2);
    }

    @Override
    public boolean isRunRubyInProcess() {
        return this.provider.getRubyInstanceConfig().isRunRubyInProcess();
    }

    @Override
    public void setRunRubyInProcess(boolean inprocess) {
        this.provider.getRubyInstanceConfig().setRunRubyInProcess(inprocess);
    }

    @Override
    public boolean isObjectSpaceEnabled() {
        return this.provider.getRubyInstanceConfig().isObjectSpaceEnabled();
    }

    @Override
    public void setObjectSpaceEnabled(boolean enable2) {
        this.provider.getRubyInstanceConfig().setObjectSpaceEnabled(enable2);
    }

    @Override
    public Map getEnvironment() {
        return this.provider.getRubyInstanceConfig().getEnvironment();
    }

    @Override
    public void setEnvironment(Map environment2) {
        this.provider.getRubyInstanceConfig().setEnvironment(environment2);
    }

    @Override
    public String getCurrentDirectory() {
        if (this.provider.isRuntimeInitialized()) {
            return this.provider.getRuntime().getCurrentDirectory();
        }
        return this.provider.getRubyInstanceConfig().getCurrentDirectory();
    }

    @Override
    public void setCurrentDirectory(String directory) {
        if (this.provider.isRuntimeInitialized()) {
            this.provider.getRuntime().setCurrentDirectory(directory);
        } else {
            this.provider.getRubyInstanceConfig().setCurrentDirectory(directory);
        }
    }

    @Override
    public String getHomeDirectory() {
        return this.provider.getRubyInstanceConfig().getJRubyHome();
    }

    @Override
    public void setHomeDirectory(String home2) {
        this.provider.getRubyInstanceConfig().setJRubyHome(home2);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.provider.getRubyInstanceConfig().getLoader();
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.provider.getRubyInstanceConfig().setLoader(loader);
    }

    @Override
    public Profile getProfile() {
        return this.provider.getRubyInstanceConfig().getProfile();
    }

    @Override
    public void setProfile(Profile profile2) {
        this.provider.getRubyInstanceConfig().setProfile(profile2);
    }

    public ProfileOutput getProfileOutput() {
        return this.provider.getRubyInstanceConfig().getProfileOutput();
    }

    public void setProfileOutput(ProfileOutput out) {
        this.provider.getRubyInstanceConfig().setProfileOutput(out);
    }

    public RubyInstanceConfig.ProfilingMode getProfilingMode() {
        return this.provider.getRubyInstanceConfig().getProfilingMode();
    }

    @Deprecated
    public void setProfile(RubyInstanceConfig.ProfilingMode mode2) {
        this.provider.getRubyInstanceConfig().setProfilingMode(mode2);
    }

    public void setProfilingMode(RubyInstanceConfig.ProfilingMode mode2) {
        this.provider.getRubyInstanceConfig().setProfilingMode(mode2);
    }

    @Override
    public RubyInstanceConfig.LoadServiceCreator getLoadServiceCreator() {
        return this.provider.getRubyInstanceConfig().getLoadServiceCreator();
    }

    @Override
    public void setLoadServiceCreator(RubyInstanceConfig.LoadServiceCreator creator) {
        this.provider.getRubyInstanceConfig().setLoadServiceCreator(creator);
    }

    @Override
    public String[] getArgv() {
        return this.provider.getRubyInstanceConfig().getArgv();
    }

    @Override
    public void setArgv(String[] argv2) {
        this.provider.getRubyInstanceConfig().setArgv(argv2);
    }

    @Override
    public String getScriptFilename() {
        return this.provider.getRubyInstanceConfig().getScriptFileName();
    }

    @Override
    public void setScriptFilename(String filename2) {
        this.provider.getRubyInstanceConfig().setScriptFileName(filename2);
    }

    @Override
    public String getRecordSeparator() {
        return this.provider.getRubyInstanceConfig().getRecordSeparator();
    }

    @Override
    public void setRecordSeparator(String separator) {
        this.provider.getRubyInstanceConfig().setRecordSeparator(separator);
    }

    @Override
    public KCode getKCode() {
        return this.provider.getRubyInstanceConfig().getKCode();
    }

    @Override
    public void setKCode(KCode kcode) {
        this.provider.getRubyInstanceConfig().setKCode(kcode);
    }

    public void setNativeEnabled(boolean b2) {
        this.provider.getRubyInstanceConfig().setNativeEnabled(b2);
    }

    public boolean isNativeEnabled() {
        return this.provider.getRubyInstanceConfig().isNativeEnabled();
    }

    @Override
    public int getJitLogEvery() {
        return this.provider.getRubyInstanceConfig().getJitLogEvery();
    }

    @Override
    public void setJitLogEvery(int logEvery) {
        this.provider.getRubyInstanceConfig().setJitLogEvery(logEvery);
    }

    @Override
    public int getJitThreshold() {
        return this.provider.getRubyInstanceConfig().getJitThreshold();
    }

    @Override
    public void setJitThreshold(int threshold) {
        this.provider.getRubyInstanceConfig().setJitThreshold(threshold);
    }

    @Override
    public int getJitMax() {
        return this.provider.getRubyInstanceConfig().getJitMax();
    }

    @Override
    public void setJitMax(int max2) {
        this.provider.getRubyInstanceConfig().setJitMax(max2);
    }

    @Override
    public int getJitMaxSize() {
        return this.provider.getRubyInstanceConfig().getJitMaxSize();
    }

    @Override
    public void setJitMaxSize(int maxSize) {
        this.provider.getRubyInstanceConfig().setJitMaxSize(maxSize);
    }

    @Override
    public String getSupportedRubyVersion() {
        return OutputStrings.getVersionString().trim();
    }

    public String[] getProperty(String key2) {
        if (this.basicProperties.containsKey(key2)) {
            return this.basicProperties.get(key2);
        }
        return null;
    }

    public LocalContextProvider getProvider() {
        return this.provider;
    }

    @Deprecated
    public Ruby getRuntime() {
        return this.provider.getRuntime();
    }

    public BiVariableMap getVarMap() {
        return this.provider.getVarMap();
    }

    public Map getAttributeMap() {
        return this.provider.getAttributeMap();
    }

    public Object getAttribute(Object key2) {
        return this.provider.getAttributeMap().get(key2);
    }

    public Object setAttribute(Object key2, Object value2) {
        return this.provider.getAttributeMap().put(key2, value2);
    }

    public Object removeAttribute(Object key2) {
        return this.provider.getAttributeMap().remove(key2);
    }

    public Object get(String key2) {
        return this.provider.getVarMap().get(key2);
    }

    public Object get(Object receiver2, String key2) {
        return this.provider.getVarMap().get(receiver2, key2);
    }

    public Object put(String key2, Object value2) {
        return this.provider.getVarMap().put(key2, value2);
    }

    public Object put(Object receiver2, String key2, Object value2) {
        return this.provider.getVarMap().put(receiver2, key2, value2);
    }

    public Object remove(String key2) {
        return this.provider.getVarMap().remove(key2);
    }

    public Object remove(Object receiver2, String key2) {
        return this.provider.getVarMap().removeFrom(receiver2, key2);
    }

    public void clear() {
        this.provider.getVarMap().clear();
    }

    public EmbedEvalUnit parse(String script, int ... lines2) {
        return this.runtimeAdapter.parse(script, lines2);
    }

    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(reader, filename2, lines2);
    }

    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(type2, filename2, lines2);
    }

    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        return this.runtimeAdapter.parse(istream, filename2, lines2);
    }

    public Object runScriptlet(String script) {
        EmbedEvalUnit unit = this.parse(script, new int[0]);
        return this.runUnit(unit);
    }

    private Object runUnit(EmbedEvalUnit unit) {
        if (unit == null) {
            return null;
        }
        IRubyObject ret = unit.run();
        return JavaEmbedUtils.rubyToJava(ret);
    }

    public Object runScriptlet(Reader reader, String filename2) {
        EmbedEvalUnit unit = this.parse(reader, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public Object runScriptlet(InputStream istream, String filename2) {
        EmbedEvalUnit unit = this.parse(istream, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public Object runScriptlet(PathType type2, String filename2) {
        EmbedEvalUnit unit = this.parse(type2, filename2, new int[0]);
        return this.runUnit(unit);
    }

    public EmbedRubyRuntimeAdapter newRuntimeAdapter() {
        return this.runtimeAdapter;
    }

    public EmbedRubyObjectAdapter newObjectAdapter() {
        return this.objectAdapter;
    }

    public Object callMethod(Object receiver2, String methodName, Object ... args2) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2);
    }

    public Object callMethod(Object receiver2, String methodName, Block block, Object ... args2) {
        return this.objectAdapter.callMethod(receiver2, methodName, block, args2);
    }

    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object singleArg, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, singleArg, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, block, returnType);
    }

    public <T> T callMethod(Object receiver2, String methodName, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, returnType, unit);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, returnType, unit);
    }

    public <T> T callMethod(Object receiver2, String methodName, Object[] args2, Block block, Class<T> returnType, EmbedEvalUnit unit) {
        return this.objectAdapter.callMethod(receiver2, methodName, args2, block, returnType, unit);
    }

    public <T> T callSuper(Object receiver2, Object[] args2, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver2, args2, returnType);
    }

    public <T> T callSuper(Object receiver2, Object[] args2, Block block, Class<T> returnType) {
        return this.objectAdapter.callSuper(receiver2, args2, block, returnType);
    }

    public <T> T runRubyMethod(Class<T> returnType, Object receiver2, String methodName, Object ... args2) {
        return this.objectAdapter.runRubyMethod(returnType, receiver2, methodName, Block.NULL_BLOCK, args2);
    }

    public <T> T runRubyMethod(Class<T> returnType, Object receiver2, String methodName, Block block, Object ... args2) {
        return this.objectAdapter.runRubyMethod(returnType, receiver2, methodName, block, args2);
    }

    public <T> T getInstance(Object receiver2, Class<T> clazz) {
        return this.interfaceAdapter.getInstance(receiver2, clazz);
    }

    public void setReader(Reader reader) {
        Reader old;
        if (reader == null) {
            return;
        }
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.READER) && (old = (Reader)map2.get((Object)AttributeName.READER)) == reader) {
            return;
        }
        map2.put(AttributeName.READER, reader);
        ReaderInputStream istream = new ReaderInputStream(reader);
        Ruby runtime2 = this.provider.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, istream);
        io2.getOpenFile().setSync(true);
        runtime2.defineVariable(new RubyGlobal.InputGlobalVariable(runtime2, "$stdin", io2), GlobalVariable.Scope.GLOBAL);
        runtime2.getObject().storeConstant("STDIN", io2);
    }

    public Reader getReader() {
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.READER)) {
            return (Reader)map2.get((Object)AttributeName.READER);
        }
        return null;
    }

    @Deprecated
    public InputStream getIn() {
        return this.getInput();
    }

    public void setWriter(Writer writer) {
        Writer old;
        if (writer == null) {
            return;
        }
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.WRITER) && (old = (Writer)map2.get((Object)AttributeName.WRITER)) == writer) {
            return;
        }
        map2.put(AttributeName.WRITER, writer);
        PrintStream pstream = new PrintStream(new WriterOutputStream(writer));
        this.setOutputStream(pstream);
    }

    private void setOutputStream(PrintStream pstream) {
        if (pstream == null) {
            return;
        }
        Ruby runtime2 = this.provider.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, pstream);
        io2.getOpenFile().setSync(true);
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stdout", io2), GlobalVariable.Scope.GLOBAL);
        runtime2.getObject().storeConstant("STDOUT", io2);
        runtime2.getGlobalVariables().alias("$>", "$stdout");
        runtime2.getGlobalVariables().alias("$defout", "$stdout");
    }

    public void resetWriter() {
        PrintStream pstream = this.provider.getRubyInstanceConfig().getOutput();
        this.setOutputStream(pstream);
    }

    public Writer getWriter() {
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.WRITER)) {
            return (Writer)map2.get((Object)AttributeName.WRITER);
        }
        return null;
    }

    @Deprecated
    public PrintStream getOut() {
        return this.getOutput();
    }

    public void setErrorWriter(Writer errorWriter) {
        Writer old;
        if (errorWriter == null) {
            return;
        }
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.ERROR_WRITER) && (old = (Writer)map2.get((Object)AttributeName.ERROR_WRITER)) == errorWriter) {
            return;
        }
        map2.put(AttributeName.ERROR_WRITER, errorWriter);
        PrintStream pstream = new PrintStream(new WriterOutputStream(errorWriter));
        this.setErrorStream(pstream);
    }

    private void setErrorStream(PrintStream error2) {
        if (error2 == null) {
            return;
        }
        Ruby runtime2 = this.provider.getRuntime();
        RubyIO io2 = new RubyIO(runtime2, error2);
        io2.getOpenFile().setSync(true);
        runtime2.defineVariable(new RubyGlobal.OutputGlobalVariable(runtime2, "$stderr", io2), GlobalVariable.Scope.GLOBAL);
        runtime2.getObject().storeConstant("STDERR", io2);
        runtime2.getGlobalVariables().alias("$deferr", "$stderr");
    }

    public void resetErrorWriter() {
        PrintStream error2 = this.provider.getRubyInstanceConfig().getError();
        this.setErrorStream(error2);
    }

    public Writer getErrorWriter() {
        Map map2 = this.getAttributeMap();
        if (map2.containsKey((Object)AttributeName.ERROR_WRITER)) {
            return (Writer)map2.get((Object)AttributeName.ERROR_WRITER);
        }
        return null;
    }

    @Deprecated
    public PrintStream getErr() {
        return this.getError();
    }

    public void terminate() {
        LocalContextProvider provider = this.getProvider();
        if (provider.isRuntimeInitialized()) {
            provider.getRuntime().tearDown(false);
            provider.getRuntime().releaseClassLoader();
        }
        provider.terminate();
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.scope != LocalContextScope.SINGLETON) {
            this.terminate();
        }
    }

    public void setClassloaderDelegate(boolean classloaderDelegate) {
        this.getProvider().getRubyInstanceConfig().setClassloaderDelegate(classloaderDelegate);
    }

    public boolean getClassloaderDelegate() {
        return this.getProvider().getRubyInstanceConfig().isClassloaderDelegate();
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.getProvider().getRubyInstanceConfig().addLoader(classLoader);
    }

    @Deprecated
    public void addLoadPath(ClassLoader classloader) {
        this.addLoadPath(this.createUri(classloader, "/.jrubydir"));
    }

    @Deprecated
    protected void addLoadPath(String uri) {
        this.runScriptlet("$LOAD_PATH << '" + uri + "' unless $LOAD_PATH.member?( '" + uri + "' )");
    }

    @Deprecated
    public void addGemPath(ClassLoader classloader) {
        this.addGemPath(this.createUri(classloader, "/specifications/.jrubydir"));
    }

    private String createUri(ClassLoader cl, String ref) {
        URL url = cl.getResource(ref);
        if (url == null && ref.startsWith("/")) {
            url = cl.getResource(ref.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("reference " + ref + " not found on classloader " + cl);
        }
        return "uri:" + url.toString().replaceFirst(ref + "$", "");
    }

    protected void addGemPath(String uri) {
        this.runScriptlet("require 'rubygems';Gem::Specification.add_dir '" + uri + "' unless Gem::Specification.dirs.member?( '" + uri + "' )");
    }

    @Override
    @Deprecated
    public CompatVersion getCompatVersion() {
        return this.provider.getRubyInstanceConfig().getCompatVersion();
    }

    @Override
    @Deprecated
    public void setCompatVersion(CompatVersion version) {
    }
}

