/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.Ruby;
import org.jruby.compiler.JITClassGenerator;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.targets.JVMVisitor;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.runtime.MixedModeIRBlockBody;
import org.jruby.util.cli.Options;

public class BlockJITClassGenerator
extends JITClassGenerator {
    private final MixedModeIRBlockBody body;

    public BlockJITClassGenerator(String className, String methodName, String key2, Ruby ruby, MixedModeIRBlockBody body2, JVMVisitor visitor) {
        super(className, methodName, key2, ruby, visitor);
        this.body = body2;
    }

    protected void compile(JVMVisitorMethodContext context) {
        if (this.bytecode != null) {
            return;
        }
        long start2 = System.nanoTime();
        InterpreterContext ic = this.body.ensureInstrsReady();
        int insnCount = ic.getInstructions().length;
        if (insnCount > Options.JIT_MAXSIZE.load()) {
            throw new NotCompilableException("Could not compile " + this.body + "; instruction count " + insnCount + " exceeds threshold of " + Options.JIT_MAXSIZE.load());
        }
        this.bytecode = this.visitor.compileToBytecode(this.body.getIRScope(), context);
        this.compileTime = System.nanoTime() - start2;
    }

    public String toString() {
        return "{} at " + this.body.getFile() + ':' + this.body.getLine();
    }
}

