/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import jakarta.annotation.Generated;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.jruby.CompatVersion;
import org.jruby.anno.AnnotationBinder;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.ExecutableElementDescriptor;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.DescriptorInfo;
import org.jruby.runtime.Visibility;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@SupportedAnnotationTypes(value={"org.jruby.anno.JRubyMethod"})
public class IndyBinder
extends AbstractProcessor {
    public static final String POPULATOR_SUFFIX = "$POPULATOR";
    public static final String SRC_GEN_DIR = "target/classes/org/jruby/gen/";
    public static final int CLASS = 1;
    public static final int BASEMETHOD = 3;
    public static final int MODULEMETHOD = 4;
    public static final int RUNTIME = 5;
    public static final int SINGLETONCLASS = 6;
    public static final int RUBYMODULE = 1;
    private final List<CharSequence> classNames = new ArrayList<CharSequence>();
    private SkinnyMethodAdapter mv;
    private static final boolean DEBUG = false;
    private static final int MAX_ENCODED_ARGS_EXPONENT = 8;
    private static final int MAX_ENCODED_ARGS_MASK = 255;
    private static final int ENCODE_RESTKWARGS_SHIFT = 0;
    private static final int ENCODE_REST_SHIFT = 1;
    private static final int ENCODE_REQKWARGS_SHIFT = 9;
    private static final int ENCODE_KWARGS_SHIFT = 17;
    private static final int ENCODE_POST_SHIFT = 25;
    private static final int ENCODE_OPT_SHIFT = 33;
    private static final int ENCODE_PRE_SHIFT = 41;

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        for (TypeElement element : ElementFilter.typesIn(roundEnvironment.getRootElements())) {
            this.processType(element);
        }
        try {
            FileWriter fw = new FileWriter("target/generated-sources/annotated_classes.txt");
            for (CharSequence name2 : this.classNames) {
                fw.write(name2.toString());
                fw.write(10);
            }
            fw.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    public void processType(TypeElement cd) {
        for (TypeElement innerType : ElementFilter.typesIn(cd.getEnclosedElements())) {
            this.processType(innerType);
        }
        try {
            List<ExecutableElement> complex;
            CharSequence rubyName;
            JRubyMethod anno;
            ExecutableElement decl;
            String qualifiedName = cd.getQualifiedName().toString().replace('.', '$');
            if (!qualifiedName.contains("org$jruby")) {
                return;
            }
            ClassWriter cw = new ClassWriter(3);
            cw.visitAnnotation(CodegenUtils.p(Generated.class), true);
            cw.visit(52, 1, ("org.jruby.gen." + qualifiedName + POPULATOR_SUFFIX).replace('.', '/'), null, "org/jruby/anno/TypePopulator", null);
            this.mv = new SkinnyMethodAdapter(cw, 1, "<init>", "()V", null, null);
            this.mv.start();
            this.mv.aload(0);
            this.mv.invokespecial("org/jruby/anno/TypePopulator", "<init>", "()V");
            this.mv.voidreturn();
            this.mv.end();
            this.mv = new SkinnyMethodAdapter(cw, 1, "populate", "(Lorg/jruby/RubyModule;Ljava/lang/Class;)V", null, null);
            this.mv.start();
            boolean hasAnno = false;
            boolean hasMeta = false;
            boolean hasModule = false;
            for (ExecutableElement method2 : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno2 = method2.getAnnotation(JRubyMethod.class);
                if (anno2 == null) continue;
                hasAnno = true;
                hasMeta |= anno2.meta();
                hasModule |= anno2.module();
            }
            if (!hasAnno) {
                return;
            }
            this.mv.aload(1);
            this.mv.invokevirtual("org/jruby/RubyModule", "getRuntime", "()Lorg/jruby/Ruby;");
            this.mv.astore(5);
            if (hasMeta || hasModule) {
                this.mv.aload(1);
                this.mv.invokevirtual("org/jruby/RubyModule", "getSingletonClass", "()Lorg/jruby/RubyClass;");
                this.mv.astore(6);
            }
            HashMap<CharSequence, List<ExecutableElement>> annotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<CharSequence, List<ExecutableElement>> staticAnnotatedMethods = new HashMap<CharSequence, List<ExecutableElement>>();
            HashMap<Set<FrameField>, List<String>> readGroups = new HashMap<Set<FrameField>, List<String>>();
            HashMap<Set<FrameField>, List<String>> writeGroups = new HashMap<Set<FrameField>, List<String>>();
            int methodCount = 0;
            for (ExecutableElement method3 : ElementFilter.methodsIn(cd.getEnclosedElements())) {
                JRubyMethod anno3 = method3.getAnnotation(JRubyMethod.class);
                if (anno3 == null || anno3.compat() == CompatVersion.RUBY1_8) continue;
                ++methodCount;
                AnnotationBinder.checkForThrows(cd, method3);
                String[] names3 = anno3.name();
                CharSequence name2 = names3.length == 0 ? method3.getSimpleName() : names3[0];
                HashMap<CharSequence, List<ExecutableElement>> methodsHash = method3.getModifiers().contains((Object)Modifier.STATIC) ? staticAnnotatedMethods : annotatedMethods;
                ArrayList<ExecutableElement> methodDescs = (ArrayList<ExecutableElement>)methodsHash.get(name2);
                if (methodDescs == null) {
                    methodDescs = new ArrayList<ExecutableElement>(4);
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(method3);
                AnnotationHelper.groupFrameFields(readGroups, writeGroups, anno3, method3.getSimpleName().toString());
            }
            if (methodCount == 0) {
                return;
            }
            this.classNames.add(IndyBinder.getActualQualifiedName(cd));
            this.processMethodDeclarations(staticAnnotatedMethods);
            ArrayList<ExecutableElement> simpleNames = new ArrayList<ExecutableElement>();
            HashMap<CharSequence, List<ExecutableElement>> complexNames = new HashMap<CharSequence, List<ExecutableElement>>();
            for (Map.Entry entry : staticAnnotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                anno = decl.getAnnotation(JRubyMethod.class);
                if (anno.omit()) continue;
                rubyName = (CharSequence)entry.getKey();
                if (decl.getSimpleName().equals(rubyName) && anno.name().length <= 1) {
                    simpleNames.add(decl);
                    continue;
                }
                complex = (ArrayList<ExecutableElement>)complexNames.get(rubyName);
                if (complex == null) {
                    complex = new ArrayList<ExecutableElement>();
                    complexNames.put(rubyName, complex);
                }
                complex.add(decl);
            }
            this.processMethodDeclarations(annotatedMethods);
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                decl = (ExecutableElement)((List)entry.getValue()).get(0);
                anno = decl.getAnnotation(JRubyMethod.class);
                if (anno.omit()) continue;
                rubyName = (CharSequence)entry.getKey();
                if (decl.getSimpleName().equals(rubyName) && anno.name().length <= 1) {
                    simpleNames.add(decl);
                    continue;
                }
                complex = (List)complexNames.get(rubyName);
                if (complex == null) {
                    complex = new ArrayList();
                    complexNames.put(rubyName, complex);
                }
                complex.add(decl);
            }
            this.addCoreMethodMapping(cd, complexNames);
            this.addSimpleMethodMappings(cd, simpleNames);
            this.mv.voidreturn();
            this.mv.end();
            this.mv = new SkinnyMethodAdapter(cw, 9, "<clinit>", "()V", null, null);
            this.mv.start();
            AnnotationHelper.populateMethodIndex(readGroups, (bits, names2) -> this.emitIndexCode((Integer)bits, (String)names2, "addMethodReadFieldsPacked"));
            AnnotationHelper.populateMethodIndex(writeGroups, (bits, names2) -> this.emitIndexCode((Integer)bits, (String)names2, "addMethodWriteFieldsPacked"));
            this.mv.voidreturn();
            this.mv.end();
            cw.visitEnd();
            new File(SRC_GEN_DIR).mkdirs();
            FileOutputStream fos = new FileOutputStream(SRC_GEN_DIR + qualifiedName + POPULATOR_SUFFIX + ".class");
            fos.write(cw.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void emitIndexCode(Integer bits, String names2, String methodName) {
        this.mv.pushInt(bits);
        this.mv.ldc(names2);
        this.mv.invokestatic("org/jruby/runtime/MethodIndex", methodName, "(ILjava/lang/String;)V");
    }

    public void processMethodDeclarations(Map<CharSequence, List<ExecutableElement>> declarations) {
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : declarations.entrySet()) {
            List<ExecutableElement> list2 = entry.getValue();
            if (list2.size() == 1) {
                this.processMethodDeclaration(list2.get(0));
                continue;
            }
            this.processMethodDeclarationMulti(list2);
        }
    }

    public void processMethodDeclaration(ExecutableElement method2) {
        this.processMethodDeclarationMulti(Collections.singletonList(method2));
    }

    public static long getEncodedSignature(JRubyMethod anno) {
        return IndyBinder.encodeSignature(anno.required(), anno.optional(), 0, 0, 0, anno.rest(), false);
    }

    public void processMethodDeclarationMulti(List<ExecutableElement> methods2) {
        Handle[] handles = new Handle[5];
        ArrayList<ExecutableElementDescriptor> descs = new ArrayList<ExecutableElementDescriptor>();
        boolean meta = false;
        boolean isStatic = false;
        JRubyMethod anno = null;
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        HashMap<Handle, ExecutableElementDescriptor> handleToDesc = new HashMap<Handle, ExecutableElementDescriptor>();
        for (ExecutableElement method2 : methods2) {
            anno = method2.getAnnotation(JRubyMethod.class);
            ExecutableElementDescriptor desc = new ExecutableElementDescriptor(method2);
            descs.add(desc);
            if (anno == null || this.mv == null) continue;
            isStatic |= desc.isStatic;
            String qualifiedName = desc.declaringClassName;
            boolean hasContext = desc.hasContext;
            boolean hasBlock = desc.hasBlock;
            StringBuilder buffer = new StringBuilder(method2.getReturnType().toString()).append(" foo(");
            boolean first2 = true;
            for (VariableElement variableElement : method2.getParameters()) {
                if (!first2) {
                    buffer.append(',');
                }
                first2 = false;
                buffer.append(variableElement.asType().toString());
            }
            buffer.append(')');
            Handle handle = new Handle(isStatic ? 6 : 5, qualifiedName.toString().replace('.', '/'), method2.getSimpleName().toString(), Method.getMethod(buffer.toString()).getDescriptor(), false);
            int n = IndyBinder.calculateHandleOffset(method2.getParameters().size(), anno.required(), anno.optional(), anno.rest(), isStatic, hasContext, hasBlock);
            handles[n] = handle;
            handleToDesc.put(handle, desc);
            meta |= anno.meta();
            int specificArity = desc.calculateSpecificCallArity();
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity <= max2) continue;
                max2 = specificArity;
                continue;
            }
            if (desc.required < min2) {
                min2 = desc.required;
            }
            if (desc.rest) {
                max2 = Integer.MAX_VALUE;
            }
            if (desc.required + desc.optional <= max2) continue;
            max2 = desc.required + desc.optional;
        }
        int implClass = meta ? 6 : 1;
        this.mv.newobj("org/jruby/internal/runtime/methods/HandleMethod");
        this.mv.dup();
        this.mv.aload(implClass);
        String baseName = AnnotationBinder.getBaseName(anno.name(), methods2.get(0));
        this.mv.getstatic(CodegenUtils.p(Visibility.class), anno.visibility().getDefaultVisibilityFor(baseName).name(), CodegenUtils.ci(Visibility.class));
        this.mv.ldc(baseName);
        this.mv.ldc(IndyBinder.encodeSignature(0, 0, 0, 0, 0, true, false));
        this.mv.ldc(true);
        this.mv.ldc(anno.notImplemented());
        DescriptorInfo info = new DescriptorInfo(descs);
        this.mv.ldc(info.getParameterDesc());
        this.mv.ldc(min2);
        this.mv.ldc(max2);
        for (int i2 = 0; i2 < 5; ++i2) {
            if (handles[i2] != null) {
                this.mv.ldc(handles[i2]);
                this.adaptHandle((ExecutableElementDescriptor)handleToDesc.get(handles[i2]), implClass);
                continue;
            }
            this.mv.aconst_null();
        }
        Method handleInit = Method.getMethod("void foo(org.jruby.RubyModule, org.jruby.runtime.Visibility, java.lang.String, long, boolean, boolean, java.lang.String, int, int, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable, java.util.concurrent.Callable)");
        this.mv.invokespecial("org/jruby/internal/runtime/methods/HandleMethod", "<init>", handleInit.getDescriptor());
        this.mv.astore(3);
        this.generateMethodAddCalls(methods2.get(0), anno);
    }

    public void adaptHandle(ExecutableElementDescriptor executableElementDescriptor, int implClass) {
        ExecutableElementDescriptor desc = executableElementDescriptor;
        this.mv.aload(5);
        this.mv.ldc(IndyBinder.calculateActualRequired(desc.method, desc.method.getParameters().size(), desc.optional, desc.rest, desc.isStatic, desc.hasContext, desc.hasBlock));
        this.mv.ldc(desc.required);
        this.mv.ldc(desc.optional);
        this.mv.ldc(desc.rest);
        this.mv.ldc(desc.rubyName);
        this.mv.ldc(Type.getObjectType(desc.declaringClassPath));
        this.mv.ldc(desc.isStatic);
        this.mv.ldc(desc.hasContext);
        this.mv.ldc(desc.hasBlock);
        this.mv.ldc(desc.anno.frame());
        this.mv.aload(implClass);
        this.mv.invokestatic("org/jruby/internal/runtime/methods/InvokeDynamicMethodFactory", "adaptHandle", Method.getMethod("java.util.concurrent.Callable adaptHandle(java.lang.invoke.MethodHandle, org.jruby.Ruby, int, int, int, boolean, java.lang.String, java.lang.Class, boolean, boolean, boolean, boolean, org.jruby.RubyModule)").getDescriptor());
    }

    private void addCoreMethodMapping(TypeElement cls, Map<CharSequence, List<ExecutableElement>> complexNames) {
        StringBuilder encoded = new StringBuilder();
        for (Map.Entry<CharSequence, List<ExecutableElement>> entry : complexNames.entrySet()) {
            Iterator<ExecutableElement> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                if (encoded.length() > 0) {
                    encoded.append(";");
                }
                ExecutableElement elt = iterator.next();
                encoded.append(elt.getSimpleName()).append(";").append(entry.getKey());
            }
        }
        if (encoded.length() == 0) {
            return;
        }
        this.mv.aload(5);
        this.mv.ldc(cls.getQualifiedName().toString());
        this.mv.ldc(encoded.toString());
        this.mv.invokevirtual("org/jruby/Ruby", "addBoundMethodsPacked", "(Ljava/lang/String;Ljava/lang/String;)V");
    }

    private void addSimpleMethodMappings(TypeElement cls, List<ExecutableElement> simpleNames) {
        StringBuilder encoded = new StringBuilder();
        for (ExecutableElement elt : simpleNames) {
            if (encoded.length() > 0) {
                encoded.append(";");
            }
            encoded.append(elt.getSimpleName());
        }
        if (encoded.length() == 0) {
            return;
        }
        this.mv.aload(5);
        this.mv.ldc(cls.getSimpleName().toString());
        this.mv.ldc(encoded.toString());
        this.mv.invokevirtual("org/jruby/Ruby", "addSimpleBoundMethodsPacked", "(Ljava/lang/String;Ljava/lang/String;)V");
    }

    private static CharSequence getActualQualifiedName(TypeElement td) {
        if (td.getNestingKind() == NestingKind.MEMBER) {
            return IndyBinder.getActualQualifiedName((TypeElement)td.getEnclosingElement()) + "$" + td.getSimpleName();
        }
        return td.getQualifiedName().toString();
    }

    public static long encodeSignature(int pre, int opt, int post, int kwargs, int requiredKwargs, boolean rest, boolean restKwargs) {
        return (long)pre << 41 | (long)opt << 33 | (long)post << 25 | (long)kwargs << 17 | (long)requiredKwargs << 9 | (long)((rest ? 1 : 0) << 1) | (long)((restKwargs ? 1 : 0) << 0);
    }

    private static int calculateActualRequired(ExecutableElement md, int paramsLength, int optional, boolean rest, boolean isStatic, boolean hasContext, boolean hasBlock) {
        int actualRequired;
        if (optional == 0 && !rest) {
            int args2 = paramsLength;
            if (args2 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args2;
                }
                if (hasContext) {
                    --args2;
                }
                if (hasBlock) {
                    --args2;
                }
                actualRequired = args2;
            }
        } else {
            int args3 = paramsLength;
            if (args3 == 0) {
                actualRequired = 0;
            } else {
                if (isStatic) {
                    --args3;
                }
                if (hasContext) {
                    --args3;
                }
                if (hasBlock) {
                    --args3;
                }
                actualRequired = --args3;
            }
            if (actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + ((TypeElement)md.getEnclosingElement()).getQualifiedName() + "." + md.toString());
            }
        }
        return actualRequired;
    }

    private static int calculateHandleOffset(int paramsLength, int required, int optional, boolean rest, boolean isStatic, boolean hasContext, boolean hasBlock) {
        if (required < 4 && optional == 0 && !rest) {
            int args2 = paramsLength;
            if (args2 == 0) {
                return 0;
            }
            if (isStatic) {
                --args2;
            }
            if (hasContext) {
                --args2;
            }
            if (hasBlock) {
                --args2;
            }
            return args2;
        }
        return 4;
    }

    public void generateMethodAddCalls(ExecutableElement md, JRubyMethod jrubyMethod) {
        String[] names2 = jrubyMethod.name();
        String[] aliases2 = jrubyMethod.alias();
        if (jrubyMethod.meta()) {
            this.defineMethodOnClass(3, 6, names2, aliases2, md);
        } else {
            this.defineMethodOnClass(3, 1, names2, aliases2, md);
            if (jrubyMethod.module()) {
                this.mv.aload(1);
                this.mv.aload(3);
                this.mv.invokestatic("org/jruby/anno/TypePopulator", "populateModuleMethod", "(Lorg/jruby/RubyModule;Lorg/jruby/internal/runtime/methods/DynamicMethod;)Lorg/jruby/internal/runtime/methods/DynamicMethod;");
                this.mv.astore(4);
                this.defineMethodOnClass(4, 6, names2, aliases2, md);
            }
        }
    }

    private void defineMethodOnClass(int methodVar, int classVar, String[] names2, String[] aliases2, ExecutableElement md) {
        String baseName;
        if (names2.length == 0) {
            baseName = md.getSimpleName().toString();
            this.mv.aload(classVar);
            this.mv.ldc(baseName);
            this.mv.aload(methodVar);
            this.mv.invokevirtual("org/jruby/RubyModule", "addMethodAtBootTimeOnly", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
        } else {
            baseName = names2[0];
            for (String name2 : names2) {
                this.mv.aload(classVar);
                this.mv.ldc(name2);
                this.mv.aload(methodVar);
                this.mv.invokevirtual("org/jruby/RubyModule", "addMethodAtBootTimeOnly", "(Ljava/lang/String;Lorg/jruby/internal/runtime/methods/DynamicMethod;)V");
            }
        }
        if (aliases2.length > 0) {
            for (String alias : aliases2) {
                this.mv.aload(classVar);
                this.mv.ldc(alias);
                this.mv.ldc(baseName);
                this.mv.invokevirtual("org/jruby/RubyModule", "defineAlias", "(Ljava/lang/String;Ljava/lang/String;)V");
            }
        }
    }
}

