/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.backport9.stack.StackWalker;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.jruby.FiberScheduler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThreadGroup;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.AdoptedNativeThread;
import org.jruby.internal.runtime.RubyNativeThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.internal.runtime.ThreadService;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.FrameType;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.io.BlockingIO;
import org.jruby.util.io.OpenFile;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Thread"})
public class RubyThread
extends RubyObject
implements ExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(RubyThread.class);
    private static final StackWalker WALKER = ThreadContext.WALKER;
    private volatile ThreadLike threadImpl = ThreadLike.DUMMY;
    private volatile transient Map<IRubyObject, IRubyObject> fiberLocalVariables;
    private volatile transient Map<IRubyObject, IRubyObject> threadLocalVariables;
    private final Map<Object, IRubyObject> contextVariables = new WeakHashMap<Object, IRubyObject>();
    private volatile boolean abortOnException;
    private volatile boolean reportOnException;
    private volatile IRubyObject finalResult;
    private String file;
    private int line;
    private volatile Throwable exitingException;
    private volatile RubyThreadGroup threadGroup;
    private volatile IRubyObject errorInfo;
    private volatile WeakReference<ThreadContext> contextRef;
    private final Vector<RubyHash> interruptMaskStack = new Vector(4);
    private final SleepTask2 sleepTask = new SleepTask2();
    private final boolean adopted;
    public static final int RUBY_MIN_THREAD_PRIORITY = -3;
    public static final int RUBY_MAX_THREAD_PRIORITY = 3;
    private volatile Status status = Status.RUN;
    private static final AtomicReferenceFieldUpdater<RubyThread, Status> STATUS = AtomicReferenceFieldUpdater.newUpdater(RubyThread.class, Status.class, "status");
    private final Queue<IRubyObject> pendingInterruptQueue = new ConcurrentLinkedQueue<IRubyObject>();
    private volatile Unblocker unblockFunc;
    private volatile Object unblockArg;
    private final List<Lock> heldLocks = new Vector<Lock>();
    private volatile boolean disposed = false;
    private volatile int interruptFlag = 0;
    private volatile int interruptMask;
    private volatile boolean pendingInterruptQueueChecked = false;
    private volatile BlockingTask currentBlockingTask;
    private volatile Selector currentSelector;
    private volatile RubyThread fiberCurrentThread;
    private IRubyObject scheduler;
    private volatile int blockingCount = 1;
    private static final AtomicIntegerFieldUpdater<RubyThread> INTERRUPT_FLAG_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RubyThread.class, "interruptFlag");
    private static final int TIMER_INTERRUPT_MASK = 1;
    private static final int PENDING_INTERRUPT_MASK = 2;
    private static final int POSTPONED_JOB_INTERRUPT_MASK = 4;
    private static final int TRAP_INTERRUPT_MASK = 8;
    private static final int INTERRUPT_NONE = 0;
    private static final int INTERRUPT_IMMEDIATE = 1;
    private static final int INTERRUPT_ON_BLOCKING = 2;
    private static final int INTERRUPT_NEVER = 3;
    private static final RubyHash[] NULL_ARRAY = new RubyHash[0];
    private static final String RUBY_THREAD_PREFIX = "Ruby-";
    private static final RubyHash.VisitorWithState HandleInterruptVisitor = new RubyHash.VisitorWithState<Void>(){

        @Override
        public void visit(ThreadContext context, RubyHash self2, IRubyObject key2, IRubyObject value2, int index2, Void state2) {
            RubyThread.checkInterruptMask(context, value2);
        }
    };
    private volatile BlockingIO.Condition blockingIO = null;

    protected RubyThread(Ruby runtime2, RubyClass type2, boolean adopted) {
        super(runtime2, type2);
        this.finalResult = this.errorInfo = runtime2.getNil();
        this.reportOnException = runtime2.isReportOnException();
        this.scheduler = runtime2.getNil();
        this.adopted = adopted;
    }

    public RubyThread(Ruby runtime2, RubyClass klass, Runnable runnable) {
        this(runtime2, klass, true);
        this.startThread(runtime2.getCurrentContext(), runnable, "<internal>", -1);
    }

    private void executeInterrupts(ThreadContext context, boolean blockingTiming) {
        int interrupt;
        Ruby runtime2 = context.runtime;
        boolean postponedJobInterrupt = false;
        while ((interrupt = this.getInterrupts()) != 0) {
            IRubyObject err;
            boolean timerInterrupt = (interrupt & 1) == 1;
            boolean pendingInterrupt = (interrupt & 2) == 2;
            if (!pendingInterrupt || !this.pendingInterruptActive() || (err = this.pendingInterruptDeque(context, blockingTiming ? 2 : 0)) == UNDEF) continue;
            if (err instanceof RubyFixnum && (((RubyFixnum)err).getLongValue() == 0L || ((RubyFixnum)err).getLongValue() == 1L || ((RubyFixnum)err).getLongValue() == 2L)) {
                this.toKill();
                continue;
            }
            this.afterBlockingCall();
            if (this.getStatus() == Status.SLEEP) {
                this.exitSleep();
            }
            IRubyObject[] args2 = err instanceof RubyException ? Helpers.arrayOf(err, (IRubyObject)RubyHash.newKwargs(runtime2, "cause", ((RubyException)err).cause(context))) : Helpers.arrayOf(err);
            RubyKernel.raise(context, this, args2, Block.NULL_BLOCK);
        }
    }

    private void postponedJobFlush(ThreadContext context) {
    }

    private boolean pendingInterruptActive() {
        if (this.pendingInterruptQueueChecked) {
            return false;
        }
        return !this.pendingInterruptQueue.isEmpty();
    }

    private void toKill() {
        this.pendingInterruptClear();
        STATUS.set(this, Status.ABORTING);
        RubyThread.throwThreadKill();
    }

    private void pendingInterruptClear() {
        this.pendingInterruptQueue.clear();
    }

    private int getInterrupts() {
        int interrupt;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, interrupt = this.interruptFlag, interrupt & this.interruptMask)) {
        }
        return interrupt & ~this.interruptMask;
    }

    private IRubyObject pendingInterruptDeque(ThreadContext context, int timing) {
        Iterator iterator = this.pendingInterruptQueue.iterator();
        while (iterator.hasNext()) {
            IRubyObject err = (IRubyObject)iterator.next();
            int maskTiming = this.pendingInterruptCheckMask(context, err);
            switch (maskTiming) {
                case 2: {
                    if (timing != 2) break;
                }
                case 0: 
                case 1: {
                    iterator.remove();
                    return err;
                }
            }
        }
        this.pendingInterruptQueueChecked = true;
        return UNDEF;
    }

    private int pendingInterruptCheckMask(ThreadContext context, IRubyObject err) {
        int idx = this.interruptMaskStack.size();
        if (idx == 0) {
            return 0;
        }
        List<IRubyObject> ancestors2 = RubyThread.getMetaClass(err).getAncestorList();
        int ancestorsLen = ancestors2.size();
        while (--idx >= 0) {
            RubyHash mask = this.interruptMaskStack.get(idx);
            for (int j = 0; j < ancestorsLen; ++j) {
                IRubyObject klass = ancestors2.get(j);
                IRubyObject sym = mask.op_aref(context, klass);
                if (sym.isNil()) continue;
                return RubyThread.checkInterruptMask(context, sym);
            }
        }
        return 0;
    }

    public IRubyObject getErrorInfo() {
        return this.errorInfo;
    }

    public IRubyObject setErrorInfo(IRubyObject errorInfo) {
        this.errorInfo = errorInfo;
        return errorInfo;
    }

    public void setContext(ThreadContext context) {
        this.contextRef = new WeakReference<ThreadContext>(context);
    }

    public void clearContext() {
        WeakReference<ThreadContext> contextRef = this.contextRef;
        if (contextRef != null) {
            contextRef.clear();
            this.contextRef = null;
        }
    }

    public ThreadContext getContext() {
        WeakReference<ThreadContext> contextRef = this.contextRef;
        return contextRef == null ? null : (ThreadContext)contextRef.get();
    }

    public Thread getNativeThread() {
        return this.threadImpl.nativeThread();
    }

    public void setFiberCurrentThread(RubyThread fiberCurrentThread) {
        this.fiberCurrentThread = fiberCurrentThread;
    }

    public RubyThread getFiberCurrentThread() {
        RubyThread fiberCurrentThread = this.fiberCurrentThread;
        return fiberCurrentThread == null ? this : fiberCurrentThread;
    }

    public void beforeStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            this.threadGroup.remove(this);
            this.unlockAll();
            if (this.scheduler != null && !this.scheduler.isNil()) {
                FiberScheduler.close(this.getContext(), this.scheduler);
            }
            this.beDead();
        }
        this.getRuntime().getThreadService().unregisterThread(this);
    }

    public static RubyClass createThreadClass(Ruby runtime2) {
        RubyClass threadClass = runtime2.defineClass("Thread", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        threadClass.setClassIndex(ClassIndex.THREAD);
        threadClass.setReifiedClass(RubyThread.class);
        threadClass.defineAnnotatedMethods(RubyThread.class);
        RubyThread rubyThread = new RubyThread(runtime2, threadClass, true);
        rubyThread.threadImpl = new AdoptedNativeThread(rubyThread, Thread.currentThread());
        runtime2.getThreadService().setMainThread(Thread.currentThread(), rubyThread);
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        threadClass.setMarshal(ObjectMarshal.NOT_MARSHALABLE_MARSHAL);
        RubyClass backtrace2 = threadClass.defineClassUnder("Backtrace", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass location = backtrace2.defineClassUnder("Location", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        backtrace2.defineAnnotatedMethods(Backtrace.class);
        location.defineAnnotatedMethods(Location.class);
        runtime2.setLocation(location);
        return threadClass;
    }

    @JRubyMethod(name={"new", "fork"}, rest=true, meta=true, keywords=true)
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyThread.startThread(recv2, args2, true, block);
    }

    @JRubyMethod(rest=true, name={"start"}, meta=true)
    public static RubyThread start(IRubyObject recv2, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw recv2.getRuntime().newArgumentError("tried to create Proc object without a block");
        }
        return RubyThread.startThread(recv2, args2, false, block);
    }

    public static RubyThread adopt(IRubyObject recv2, Thread t) {
        Ruby runtime2 = recv2.getRuntime();
        return RubyThread.adoptThread(runtime2, runtime2.getThreadService(), (RubyClass)recv2, t);
    }

    public static RubyThread adopt(Ruby runtime2, ThreadService service, Thread thread2) {
        return RubyThread.adoptThread(runtime2, service, runtime2.getThread(), thread2);
    }

    private static RubyThread adoptThread(Ruby runtime2, ThreadService service, RubyClass recv2, Thread thread2) {
        RubyThread rubyThread = new RubyThread(runtime2, recv2, true);
        rubyThread.threadImpl = new AdoptedNativeThread(rubyThread, thread2);
        ThreadContext context = service.registerNewThread(rubyThread);
        service.associateThread(thread2, rubyThread);
        context.preAdoptThread();
        runtime2.getDefaultThreadGroup().addDirectly(rubyThread);
        return rubyThread;
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        int callInfo = ThreadContext.resetCallInfo(context);
        if (!block.isGiven()) {
            throw context.runtime.newThreadError("must be called with a block");
        }
        if (this.threadImpl != ThreadLike.DUMMY) {
            throw context.runtime.newThreadError("already initialized thread");
        }
        BlockBody body2 = block.getBody();
        this.startThread(context, new RubyRunnable(this, args2, block, callInfo), body2.getFile(), body2.getLine());
        return context.nil;
    }

    private Thread startThread(ThreadContext context, Runnable runnable, String file2, int line) throws RaiseException, OutOfMemoryError {
        Ruby runtime2 = context.runtime;
        try {
            Thread thread2 = new Thread(runnable);
            thread2.setDaemon(true);
            this.file = file2;
            this.line = line;
            RubyThread.initThreadName(runtime2, thread2, file2, line);
            this.threadImpl = new RubyNativeThread(this, thread2);
            this.addToCorrectThreadGroup(context);
            runtime2.getThreadService().associateThread(thread2, this);
            RubyThread.copyInterrupts(context, context.getThread().interruptMaskStack, this.interruptMaskStack);
            thread2.start();
            Thread.yield();
            return thread2;
        }
        catch (OutOfMemoryError oome) {
            if ("unable to create new native thread".equals(oome.getMessage())) {
                throw runtime2.newThreadError(oome.getMessage());
            }
            throw oome;
        }
        catch (SecurityException ex) {
            throw runtime2.newThreadError(ex.getMessage());
        }
    }

    private static void copyInterrupts(ThreadContext context, Vector<RubyHash> sourceStack, Vector<RubyHash> targetStack) {
        for (RubyHash h : sourceStack.toArray(NULL_ARRAY)) {
            targetStack.add(h.dupFast(context));
        }
    }

    private static void initThreadName(Ruby runtime2, Thread thread2, String file2, int line) {
        StringBuilder name2 = new StringBuilder(24);
        name2.append(RUBY_THREAD_PREFIX).append(runtime2.getRuntimeNumber()).append('-').append("Thread-").append(RubyThread.incAndGetThreadCount(runtime2));
        if (file2 != null) {
            name2.append(':').append(' ').append(file2).append(':').append(line + 1);
        }
        String newName = name2.toString();
        thread2.setName(newName);
    }

    private static long incAndGetThreadCount(Ruby runtime2) {
        return runtime2.getThreadService().incrementAndGetThreadCount();
    }

    private static RubyThread startThread(IRubyObject recv2, IRubyObject[] args2, boolean callInit, Block block) {
        Ruby runtime2 = recv2.getRuntime();
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)recv2, false);
        if (callInit) {
            rubyThread.callInit(args2, block);
            if (rubyThread.threadImpl == ThreadLike.DUMMY) {
                throw runtime2.newThreadError(RubyStringBuilder.str(runtime2, "uninitialized thread - check ", RubyStringBuilder.types(runtime2, (RubyModule)((RubyClass)recv2)), "#initialize"));
            }
        } else {
            rubyThread.initialize(runtime2.getCurrentContext(), args2, block);
        }
        return rubyThread;
    }

    protected static RubyThread startWaiterThread(Ruby runtime2, long pid2, Block block) {
        IRubyObject waiter = runtime2.getProcess().getConstantAt("Waiter");
        RubyThread rubyThread = new RubyThread(runtime2, (RubyClass)waiter, false);
        rubyThread.op_aset(runtime2.newSymbol("pid"), runtime2.newFixnum(pid2));
        rubyThread.callInit(IRubyObject.NULL_ARRAY, block);
        return rubyThread;
    }

    public synchronized void cleanTerminate(IRubyObject result2) {
        this.finalResult = result2;
    }

    public void beDead() {
        STATUS.set(this, Status.DEAD);
    }

    public void pollThreadEvents() {
        this.pollThreadEvents(this.metaClass.runtime.getCurrentContext());
    }

    public void pollThreadEvents(ThreadContext context, boolean blocking2) {
        if (blocking2) {
            this.blockingThreadPoll(context);
        } else {
            this.pollThreadEvents(context);
        }
    }

    public void pollThreadEvents(ThreadContext context) {
        if (this.anyInterrupted()) {
            this.executeInterrupts(context, false);
        }
    }

    public void blockingThreadPoll(ThreadContext context) {
        if (this.pendingInterruptQueue.isEmpty() && !this.anyInterrupted()) {
            return;
        }
        this.pendingInterruptQueueChecked = false;
        this.setInterrupt();
        this.executeInterrupts(context, true);
    }

    private boolean anyInterrupted() {
        return Thread.interrupted() || (this.interruptFlag & ~this.interruptMask) != 0;
    }

    private static void throwThreadKill() {
        throw new ThreadKill();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject handle_interrupt(ThreadContext context, IRubyObject self2, IRubyObject _mask, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("block is needed");
        }
        RubyHash mask = _mask.convertToHash().dupFast(context);
        if (mask.isEmpty()) {
            return block.yield(context, context.nil);
        }
        mask.visitAll(context, HandleInterruptVisitor, null);
        mask.setFrozen(true);
        return context.getThread().handleInterrupt(context, mask, block);
    }

    private IRubyObject handleInterrupt(ThreadContext context, RubyHash mask, BiFunction<ThreadContext, IRubyObject, IRubyObject> block) {
        return this.handleInterrupt(context, mask, context.nil, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <StateType> IRubyObject handleInterrupt(ThreadContext context, RubyHash mask, StateType state2, BiFunction<ThreadContext, StateType, IRubyObject> block) {
        Vector<RubyHash> interruptMaskStack = this.interruptMaskStack;
        interruptMaskStack.add(mask);
        Queue<IRubyObject> pendingInterruptQueue = this.pendingInterruptQueue;
        if (!pendingInterruptQueue.isEmpty()) {
            this.pendingInterruptQueueChecked = false;
            this.setInterrupt();
        }
        try {
            this.pollThreadEvents();
            IRubyObject iRubyObject = block.apply(context, state2);
            return iRubyObject;
        }
        finally {
            interruptMaskStack.remove(interruptMaskStack.size() - 1);
            if (!pendingInterruptQueue.isEmpty()) {
                this.pendingInterruptQueueChecked = false;
                this.setInterrupt();
            }
            this.pollThreadEvents(context);
        }
    }

    private static int checkInterruptMask(ThreadContext context, IRubyObject sym) {
        if (sym instanceof RubySymbol) {
            switch (((RubySymbol)sym).idString()) {
                case "immediate": {
                    return 1;
                }
                case "on_blocking": {
                    return 2;
                }
                case "never": {
                    return 3;
                }
            }
        }
        throw context.runtime.newArgumentError("unknown mask signature");
    }

    @JRubyMethod(name={"pending_interrupt?"}, meta=true)
    public static IRubyObject pending_interrupt_p_s(ThreadContext context, IRubyObject self2) {
        return context.getThread().pending_interrupt_p(context);
    }

    @JRubyMethod(name={"pending_interrupt?"}, meta=true)
    public static IRubyObject pending_interrupt_p_s(ThreadContext context, IRubyObject self2, IRubyObject err) {
        return context.getThread().pending_interrupt_p(context, err);
    }

    @JRubyMethod(name={"pending_interrupt?"})
    public IRubyObject pending_interrupt_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, !this.pendingInterruptQueue.isEmpty());
    }

    @JRubyMethod(name={"pending_interrupt?"})
    public IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject err) {
        if (this.pendingInterruptQueue.isEmpty()) {
            return context.fals;
        }
        if (!(err instanceof RubyModule)) {
            throw context.runtime.newTypeError("class or module required for rescue clause");
        }
        return this.pendingInterruptInclude((RubyModule)err) ? context.tru : context.fals;
    }

    private boolean pendingInterruptInclude(RubyModule err) {
        for (IRubyObject e : this.pendingInterruptQueue) {
            if (!e.getMetaClass().isKindOfModule(err)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"name="})
    public IRubyObject setName(IRubyObject name2) {
        Ruby runtime2 = this.getRuntime();
        if (!name2.isNil()) {
            RubyString nameStr = StringSupport.checkEmbeddedNulls(runtime2, name2);
            Encoding enc = nameStr.getEncoding();
            if (!enc.isAsciiCompatible()) {
                throw runtime2.newArgumentError("ASCII incompatible encoding (" + enc + ")");
            }
            this.threadImpl.setRubyName(runtime2.freezeAndDedupString(nameStr).asJavaString());
        } else {
            this.threadImpl.setRubyName(null);
        }
        return name2;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject getName() {
        Ruby runtime2 = this.getRuntime();
        String rubyName = this.threadImpl.getRubyName();
        if (rubyName == null) {
            return runtime2.getNil();
        }
        return RubyString.newString(runtime2, (CharSequence)rubyName);
    }

    @JRubyMethod(meta=true)
    public static RubyThread current(IRubyObject recv2) {
        return recv2.getRuntime().getCurrentContext().getThread();
    }

    @JRubyMethod(meta=true)
    public static RubyThread main(IRubyObject recv2) {
        return recv2.getRuntime().getThreadService().getMainThread();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject pass(ThreadContext context, IRubyObject recv2) {
        Thread.yield();
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static RubyArray list(IRubyObject recv2) {
        Ruby runtime2 = recv2.getRuntime();
        IRubyObject[] activeThreads = runtime2.getThreadService().getActiveRubyThreads();
        return RubyArray.newArrayMayCopy(runtime2, activeThreads);
    }

    @JRubyMethod
    public IRubyObject add_trace_func(ThreadContext context, IRubyObject trace_func, Block block) {
        return this.getContext().addThreadTraceFunction(trace_func, false);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject add_trace_func(ThreadContext context, IRubyObject recv2, IRubyObject trace_func, Block block) {
        return context.addThreadTraceFunction(trace_func, false);
    }

    @JRubyMethod
    public IRubyObject set_trace_func(ThreadContext context, IRubyObject trace_func, Block block) {
        if (trace_func.isNil()) {
            return this.getContext().clearThreadTraceFunctions();
        }
        return this.getContext().setThreadTraceFunction(trace_func);
    }

    private void addToCorrectThreadGroup(ThreadContext context) {
        IRubyObject group2 = context.getThread().group();
        if (!group2.isNil()) {
            ((RubyThreadGroup)group2).addDirectly(this);
        } else {
            context.runtime.getDefaultThreadGroup().addDirectly(this);
        }
    }

    private RubySymbol getSymbolKey(IRubyObject originalKey) {
        if (originalKey instanceof RubySymbol) {
            return (RubySymbol)originalKey;
        }
        Ruby runtime2 = this.getRuntime();
        if (originalKey instanceof RubyString) {
            return runtime2.newSymbol(((RubyString)originalKey).getByteList());
        }
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.ids(runtime2, originalKey), " is not a symbol nor a string"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IRubyObject, IRubyObject> getFiberLocals() {
        Map<IRubyObject, IRubyObject> locals = this.fiberLocalVariables;
        if (locals == null) {
            RubyThread rubyThread = this;
            synchronized (rubyThread) {
                locals = this.fiberLocalVariables;
                if (locals == null) {
                    locals = this.fiberLocalVariables = new HashMap<IRubyObject, IRubyObject>();
                }
            }
        }
        return locals;
    }

    private Map<IRubyObject, IRubyObject> getThreadLocals() {
        return this.getFiberCurrentThread().getThreadLocals0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<IRubyObject, IRubyObject> getThreadLocals0() {
        Map<IRubyObject, IRubyObject> locals = this.threadLocalVariables;
        if (locals == null) {
            RubyThread rubyThread = this;
            synchronized (rubyThread) {
                locals = this.threadLocalVariables;
                if (locals == null) {
                    locals = this.threadLocalVariables = new HashMap<IRubyObject, IRubyObject>();
                }
            }
        }
        return locals;
    }

    @Override
    public final Map<Object, IRubyObject> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isAlive() {
        return this.threadImpl.isAlive() && this.getStatus() != Status.DEAD;
    }

    public boolean isAdopted() {
        return this.adopted;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, Block block) {
        IRubyObject value2 = this.op_aref(context, key2);
        if (value2.isNil()) {
            if (block.isGiven()) {
                return block.yield(context, key2);
            }
            throw context.runtime.newKeyError("key not found: " + key2.inspect(), this, key2);
        }
        return value2;
    }

    @JRubyMethod
    public IRubyObject fetch(ThreadContext context, IRubyObject key2, IRubyObject _default, Block block) {
        IRubyObject value2;
        boolean blockGiven = block.isGiven();
        if (blockGiven) {
            context.runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_BEATS_DEFAULT_VALUE, "block supersedes default value argument");
        }
        if ((value2 = this.op_aref(context, key2)) == context.nil) {
            if (blockGiven) {
                return block.yield(context, key2);
            }
            return _default;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
        Map<IRubyObject, IRubyObject> locals;
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getFiberLocals();
        synchronized (map2) {
            IRubyObject value2 = locals.get(key2);
            return value2 == null ? context.nil : value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"[]="})
    public IRubyObject op_aset(IRubyObject key2, IRubyObject value2) {
        Map<IRubyObject, IRubyObject> locals;
        this.checkFrozen();
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getFiberLocals();
        synchronized (map2) {
            locals.put(key2, value2);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"key?"})
    public RubyBoolean key_p(ThreadContext context, IRubyObject key2) {
        Map<IRubyObject, IRubyObject> locals;
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getFiberLocals();
        synchronized (map2) {
            return RubyBoolean.newBoolean(context, locals.containsKey(key2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public RubyArray keys() {
        IRubyObject[] ary;
        Map<IRubyObject, IRubyObject> locals;
        Map<IRubyObject, IRubyObject> map2 = locals = this.getFiberLocals();
        synchronized (map2) {
            ary = new IRubyObject[locals.size()];
            int i2 = 0;
            for (Map.Entry<IRubyObject, IRubyObject> entry : locals.entrySet()) {
                ary[i2++] = entry.getKey();
            }
        }
        return RubyArray.newArrayMayCopy(this.getRuntime(), ary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"thread_variable?"})
    public IRubyObject thread_variable_p(ThreadContext context, IRubyObject key2) {
        Map<IRubyObject, IRubyObject> locals;
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getThreadLocals();
        synchronized (map2) {
            return RubyBoolean.newBoolean(context, locals.containsKey(key2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"thread_variable_get"})
    public IRubyObject thread_variable_get(ThreadContext context, IRubyObject key2) {
        Map<IRubyObject, IRubyObject> locals;
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getThreadLocals();
        synchronized (map2) {
            IRubyObject value2 = locals.get(key2);
            return value2 == null ? context.nil : value2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"thread_variable_set"})
    public IRubyObject thread_variable_set(ThreadContext context, IRubyObject key2, IRubyObject value2) {
        Map<IRubyObject, IRubyObject> locals;
        this.checkFrozen();
        key2 = this.getSymbolKey(key2);
        Map<IRubyObject, IRubyObject> map2 = locals = this.getThreadLocals();
        synchronized (map2) {
            locals.put(key2, value2);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"thread_variables"})
    public IRubyObject thread_variables(ThreadContext context) {
        IRubyObject[] ary;
        Map<IRubyObject, IRubyObject> locals;
        Map<IRubyObject, IRubyObject> map2 = locals = this.getThreadLocals();
        synchronized (map2) {
            ary = new IRubyObject[locals.size()];
            int i2 = 0;
            for (Map.Entry<IRubyObject, IRubyObject> entry : locals.entrySet()) {
                ary[i2++] = entry.getKey();
            }
        }
        return RubyArray.newArrayMayCopy(context.runtime, ary);
    }

    public boolean isAbortOnException() {
        return this.abortOnException;
    }

    public void setAbortOnException(boolean abortOnException) {
        this.abortOnException = abortOnException;
    }

    @JRubyMethod
    public RubyBoolean abort_on_exception(ThreadContext context) {
        return this.isAbortOnException() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"abort_on_exception="})
    public IRubyObject abort_on_exception_set(IRubyObject val) {
        this.setAbortOnException(val.isTrue());
        return val;
    }

    @JRubyMethod(name={"abort_on_exception"}, meta=true)
    public static RubyBoolean abort_on_exception(ThreadContext context, IRubyObject recv2) {
        return context.runtime.isAbortOnException() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"abort_on_exception="}, meta=true)
    public static IRubyObject abort_on_exception_set(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        context.runtime.setAbortOnException(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"alive?"})
    public RubyBoolean alive_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isAlive());
    }

    @JRubyMethod
    public IRubyObject join(ThreadContext context) {
        long timeoutMillis = Long.MAX_VALUE;
        return this.joinCommon(context, timeoutMillis);
    }

    @JRubyMethod
    public IRubyObject join(ThreadContext context, IRubyObject timeout2) {
        long timeoutMillis = Long.MAX_VALUE;
        if (!timeout2.isNil() && (timeoutMillis = (long)(1000.0 * RubyNumeric.num2dbl(timeout2))) <= 0L) {
            if (this.threadImpl.isAlive()) {
                return context.nil;
            }
            return this;
        }
        return this.joinCommon(context, timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject joinCommon(ThreadContext context, long timeoutMillis) {
        Throwable exception2;
        Ruby runtime2 = context.runtime;
        if (this.isCurrent()) {
            throw runtime2.newThreadError("Target thread must not be current thread");
        }
        RubyThread currentThread = context.getThread();
        try {
            currentThread.enterSleep();
            long timeToWait = Math.min(timeoutMillis, 200L);
            long start2 = System.currentTimeMillis();
            do {
                currentThread.blockingThreadPoll(context);
                this.threadImpl.join(timeToWait);
                if (this.threadImpl.isAlive()) continue;
                break;
            } while (System.currentTimeMillis() - start2 <= timeoutMillis);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            assert (false) : ie;
        }
        catch (ExecutionException ie) {
            ie.printStackTrace();
            assert (false) : ie;
        }
        finally {
            currentThread.exitSleep();
        }
        if ((exception2 = this.exitingException) != null) {
            if (exception2 instanceof RaiseException) {
                runtime2.getGlobalVariables().set("$!", ((RaiseException)exception2).getException());
            } else {
                runtime2.getGlobalVariables().set("$!", JavaUtil.convertJavaToUsableRubyObject(runtime2, exception2));
            }
            Helpers.throwException(exception2);
        }
        currentThread.pollThreadEvents(context);
        if (this.threadImpl.isAlive()) {
            return context.nil;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject value(ThreadContext context) {
        this.join(context);
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            return this.finalResult;
        }
    }

    @JRubyMethod
    public IRubyObject group() {
        RubyThreadGroup group2 = this.threadGroup;
        return group2 == null ? this.getRuntime().getNil() : group2;
    }

    void setThreadGroup(RubyThreadGroup rubyThreadGroup) {
        this.threadGroup = rubyThreadGroup;
    }

    @Override
    public IRubyObject inspect() {
        return this.inspect(this.metaClass.runtime.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inspect", "to_s"})
    public RubyString inspect(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyString result2 = runtime2.newString("#<");
        result2.cat(this.getMetaClass().getRealClass().toRubyString(context));
        result2.cat(58);
        result2.catString(this.identityString());
        RubyThread rubyThread = this;
        synchronized (rubyThread) {
            String id2 = this.threadImpl.getRubyName();
            if (RubyThread.notEmpty(id2)) {
                result2.cat(64);
                result2.cat(runtime2.newSymbol(id2).getBytes());
            }
            if (RubyThread.notEmpty(this.file) && this.line >= 0) {
                result2.cat(32);
                result2.catString(this.file);
                result2.cat(58);
                result2.catString(Integer.toString(this.line + 1));
            }
            result2.cat(32);
            result2.catString(this.getStatus().toString().toLowerCase());
            result2.cat(62);
            return result2;
        }
    }

    private static boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject stop(ThreadContext context, IRubyObject receiver2) {
        RubyThread rubyThread = context.getThread();
        if (context.runtime.getThreadService().getActiveRubyThreads().length == 1) {
            throw context.runtime.newThreadError("stopping only thread\n\tnote: use sleep to stop forever");
        }
        RubyThread rubyThread2 = rubyThread;
        synchronized (rubyThread2) {
            rubyThread.blockingThreadPoll(context);
            Status oldStatus = rubyThread.getStatus();
            try {
                STATUS.set(rubyThread, Status.SLEEP);
                rubyThread.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                rubyThread.pollThreadEvents(context);
                STATUS.set(rubyThread, oldStatus);
            }
        }
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject kill(IRubyObject receiver2, IRubyObject rubyThread, Block block) {
        if (!(rubyThread instanceof RubyThread)) {
            throw receiver2.getRuntime().newTypeError(rubyThread, receiver2.getRuntime().getThread());
        }
        return ((RubyThread)rubyThread).kill();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject exit(IRubyObject receiver2, Block block) {
        RubyThread rubyThread = receiver2.getRuntime().getThreadService().getCurrentContext().getThread();
        return rubyThread.kill();
    }

    @JRubyMethod(name={"stop?"})
    public RubyBoolean stop_p() {
        return this.getRuntime().newBoolean(this.getStatus() == Status.SLEEP || this.getStatus() == Status.DEAD);
    }

    @JRubyMethod
    public synchronized RubyThread wakeup() {
        if (!this.threadImpl.isAlive() && this.getStatus() == Status.DEAD) {
            throw this.getRuntime().newThreadError("killed thread");
        }
        STATUS.set(this, Status.RUN);
        this.interrupt();
        return this;
    }

    @JRubyMethod
    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), RubyThread.javaPriorityToRubyPriority(this.threadImpl.getPriority()));
    }

    @JRubyMethod(name={"priority="})
    public IRubyObject priority_set(IRubyObject priority2) {
        int iPriority = RubyNumeric.fix2int(priority2);
        if (iPriority < -3) {
            iPriority = -3;
        } else if (iPriority > 3) {
            iPriority = 3;
        }
        if (this.threadImpl.isAlive()) {
            int jPriority = RubyThread.rubyPriorityToJavaPriority(iPriority);
            if (jPriority < 1) {
                jPriority = 1;
            } else if (jPriority > 10) {
                jPriority = 10;
            }
            this.threadImpl.setPriority(jPriority);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), iPriority);
    }

    public static int javaPriorityToRubyPriority(int javaPriority) {
        double d = 1.5 * Math.sqrt(8.0 * (double)javaPriority + 41.0) - 13.5;
        return Math.round((float)d);
    }

    public static int rubyPriorityToJavaPriority(int rubyPriority) {
        double d = (double)(rubyPriority * rubyPriority) / 18.0 + 1.5 * (double)rubyPriority + 5.0;
        return Math.round((float)d);
    }

    public final IRubyObject raise(IRubyObject exception2) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return this.genericRaise(context, context.getThread(), exception2);
    }

    public final IRubyObject raise(IRubyObject exception2, RubyString message2) {
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        return this.genericRaise(context, context.getThread(), exception2, message2);
    }

    @JRubyMethod(optional=3, checkArity=false)
    public IRubyObject raise(ThreadContext context, IRubyObject[] args2, Block block) {
        Arity.checkArgumentCount(context, args2, 0, 3);
        return this.genericRaise(context, context.getThread(), args2);
    }

    @JRubyMethod
    public IRubyObject native_thread_id(ThreadContext context) {
        if (!this.isAlive()) {
            return context.nil;
        }
        String encodedString = ManagementFactory.getRuntimeMXBean().getName();
        int atIndex = encodedString.indexOf(64);
        if (atIndex != -1) {
            try {
                int id2 = Integer.parseInt(encodedString.substring(0, atIndex));
                return context.runtime.newFixnum(id2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return context.nil;
    }

    private IRubyObject genericRaise(ThreadContext context, RubyThread currentThread, IRubyObject ... args2) {
        if (!this.isAlive()) {
            return context.nil;
        }
        this.pendingInterruptEnqueue(RubyThread.prepareRaiseException(context, args2));
        this.interrupt();
        if (currentThread == this) {
            this.executeInterrupts(context, false);
        }
        return context.nil;
    }

    public static IRubyObject prepareRaiseException(ThreadContext context, IRubyObject[] args2) {
        IRubyObject cause2;
        IRubyObject tmp;
        Ruby runtime2 = context.runtime;
        IRubyObject errorInfo = context.getErrorInfo();
        if (args2.length == 0) {
            if (errorInfo.isNil()) {
                return RaiseException.from(runtime2, runtime2.getRuntimeError(), "").getException();
            }
            return errorInfo;
        }
        IRubyObject arg2 = args2[0];
        if (args2.length == 1) {
            if (arg2 instanceof RubyString) {
                tmp = runtime2.getRuntimeError().newInstance(context, args2, Block.NULL_BLOCK);
            } else {
                if (arg2 instanceof ConcreteJavaProxy) {
                    return arg2;
                }
                if (!arg2.respondsTo("exception")) {
                    throw runtime2.newTypeError("exception class/object expected");
                }
                tmp = arg2.callMethod(context, "exception");
            }
        } else {
            if (!arg2.respondsTo("exception")) {
                throw runtime2.newTypeError("exception class/object expected");
            }
            tmp = arg2.callMethod(context, "exception", args2[1]);
        }
        if (!runtime2.getException().isInstance(tmp)) {
            throw runtime2.newTypeError("exception object expected");
        }
        RubyException exception2 = (RubyException)tmp;
        if (args2.length == 3) {
            exception2.set_backtrace(args2[2]);
        }
        if ((cause2 = errorInfo) != exception2) {
            exception2.setCause(cause2);
        }
        return exception2;
    }

    @JRubyMethod
    public synchronized IRubyObject run() {
        return this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sleep(long millis) throws InterruptedException {
        assert (this == this.getRuntime().getCurrentContext().getThread());
        this.sleepTask.millis = millis;
        try {
            long timeSlept = this.executeTaskBlocking(this.getContext(), null, this.sleepTask);
            if (millis == 0L || timeSlept >= millis) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sleepTask.semaphore.drainPermits();
        }
    }

    public IRubyObject status() {
        return this.status(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject status(ThreadContext context) {
        Status status2 = this.getStatus();
        if (this.threadImpl.isAlive() && status2 != Status.DEAD) {
            return context.runtime.getThreadStatus(status2);
        }
        return this.exitingException != null ? context.nil : context.fals;
    }

    public Throwable getExitingException() {
        return this.exitingException;
    }

    @Deprecated
    public void executeBlockingTask(BlockingTask task) throws InterruptedException {
        try {
            this.currentBlockingTask = task;
            this.enterSleep();
            this.pollThreadEvents();
            task.run();
        }
        finally {
            this.exitSleep();
            this.currentBlockingTask = null;
            this.pollThreadEvents();
        }
    }

    public <Data, Return> Return executeTaskBlocking(ThreadContext context, Data data2, Task<Data, Return> task) throws InterruptedException {
        return this.executeTask(context, data2, Status.SLEEP, task, true);
    }

    public <Data, Return> Return executeTask(ThreadContext context, Data data2, Task<Data, Return> task) throws InterruptedException {
        return this.executeTask(context, data2, Status.SLEEP, task, false);
    }

    public <Data, Return> Return executeTaskBlocking(ThreadContext context, Data data2, Status status2, Task<Data, Return> task) throws InterruptedException {
        return this.executeTask(context, data2, status2, task, true);
    }

    public <Data, Return> Return executeTask(ThreadContext context, Data data2, Status status2, Task<Data, Return> task) throws InterruptedException {
        return this.executeTask(context, data2, status2, task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Data, Return> Return executeTask(ThreadContext context, Data data2, Status status2, Task<Data, Return> task, boolean blocking2) throws InterruptedException {
        Status oldStatus = STATUS.get(this);
        try {
            this.unblockArg = data2;
            this.unblockFunc = task;
            this.pollThreadEvents(context, blocking2);
            STATUS.set(this, status2);
            Return Return2 = task.run(context, data2);
            return Return2;
        }
        finally {
            STATUS.set(this, oldStatus);
            this.unblockFunc = null;
            this.unblockArg = null;
            this.pollThreadEvents(context, blocking2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data> int executeReadWrite(ThreadContext context, Data data2, byte[] bytes2, int start2, int length2, ReadWrite<Data> task) throws InterruptedException {
        Status oldStatus = STATUS.get(this);
        try {
            this.preReadWrite(context, data2, task);
            int n = task.run(context, data2, bytes2, start2, length2);
            return n;
        }
        finally {
            this.postReadWrite(context, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data> int executeReadWrite(ThreadContext context, Data data2, ByteBuffer bytes2, int start2, int length2, ReadWrite<Data> task) throws InterruptedException {
        Status oldStatus = STATUS.get(this);
        try {
            this.preReadWrite(context, data2, task);
            int n = task.run(context, data2, bytes2, start2, length2);
            return n;
        }
        finally {
            this.postReadWrite(context, oldStatus);
        }
    }

    private void postReadWrite(ThreadContext context, Status oldStatus) {
        STATUS.set(this, oldStatus);
        this.unblockFunc = null;
        this.unblockArg = null;
        this.pollThreadEvents(context);
    }

    private <Data> void preReadWrite(ThreadContext context, Data data2, ReadWrite<Data> task) {
        this.unblockArg = data2;
        this.unblockFunc = task;
        this.blockingThreadPoll(context);
        STATUS.set(this, Status.SLEEP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data> int executeRegexp(ThreadContext context, Matcher matcher, int start2, int range, int option, RegexMatch task) throws InterruptedException {
        Status oldStatus = STATUS.get(this);
        try {
            this.unblockArg = matcher;
            this.unblockFunc = task;
            this.blockingThreadPoll(context);
            STATUS.set(this, Status.SLEEP);
            int n = task.run(matcher, start2, range, option);
            return n;
        }
        finally {
            STATUS.set(this, oldStatus);
            this.unblockFunc = null;
            this.unblockArg = null;
            this.pollThreadEvents(context);
        }
    }

    public void enterSleep() {
        STATUS.set(this, Status.SLEEP);
    }

    public void exitSleep() {
        if (this.getStatus() != Status.ABORTING) {
            STATUS.set(this, Status.RUN);
        }
    }

    private Status getStatus() {
        Status status2 = STATUS.get(this);
        if (status2 != Status.NATIVE) {
            return status2;
        }
        return this.nativeStatus();
    }

    private Status nativeStatus() {
        switch (this.getNativeThread().getState()) {
            default: {
                return Status.RUN;
            }
            case BLOCKED: 
            case WAITING: 
            case TIMED_WAITING: {
                return Status.SLEEP;
            }
            case TERMINATED: 
        }
        return Status.DEAD;
    }

    @JRubyMethod(name={"kill", "exit", "terminate"})
    public IRubyObject kill() {
        Ruby runtime2 = this.getRuntime();
        RubyThread currentThread = runtime2.getCurrentContext().getThread();
        if (currentThread == runtime2.getThreadService().getMainThread()) {
            // empty if block
        }
        STATUS.set(this, Status.ABORTING);
        return this.genericKill(runtime2, currentThread);
    }

    private IRubyObject genericKill(Ruby runtime2, RubyThread currentThread) {
        if (currentThread == this) {
            RubyThread.throwThreadKill();
        }
        this.pendingInterruptEnqueue(RubyFixnum.zero(runtime2));
        this.interrupt();
        return this;
    }

    private void pendingInterruptEnqueue(IRubyObject v) {
        this.pendingInterruptQueue.add(v);
        this.pendingInterruptQueueChecked = false;
        this.getRuntime().getCheckpointInvalidator().invalidate();
    }

    public void dieFromFinalizer() {
        this.genericKill(this.getRuntime(), null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context) {
        return this.backtrace(context, null, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2) {
        return this.backtrace(context, level2, null);
    }

    @JRubyMethod(name={"backtrace"})
    public IRubyObject backtrace(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadContext selfContext = this.getContext();
        Thread nativeThread = this.getNativeThread();
        if (selfContext == null || nativeThread == null || !nativeThread.isAlive()) {
            return context.nil;
        }
        return RubyKernel.withLevelAndLength(selfContext, level2, length2, 0, (ctx, lev, len) -> WALKER.walk(this.getNativeThread().getStackTrace(), stream -> ctx.createCallerBacktrace(lev, len, (Stream<StackWalker.StackFrame>)stream)));
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context) {
        return this.backtrace_locations(context, null, null);
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2) {
        return this.backtrace_locations(context, level2, null);
    }

    @JRubyMethod
    public IRubyObject backtrace_locations(ThreadContext context, IRubyObject level2, IRubyObject length2) {
        ThreadContext selfContext = this.getContext();
        Thread nativeThread = this.getNativeThread();
        if (selfContext == null || nativeThread == null || !nativeThread.isAlive()) {
            return context.nil;
        }
        return RubyKernel.withLevelAndLength(selfContext, level2, length2, 0, (ctx, lev, len) -> WALKER.walk(this.getNativeThread().getStackTrace(), stream -> ctx.createCallerLocations(lev, len, (Stream<StackWalker.StackFrame>)stream)));
    }

    public boolean isReportOnException() {
        return this.reportOnException;
    }

    public void setReportOnException(boolean reportOnException) {
        this.reportOnException = reportOnException;
    }

    @JRubyMethod(name={"report_on_exception="})
    public IRubyObject report_on_exception_set(ThreadContext context, IRubyObject state2) {
        this.setReportOnException(state2.isTrue());
        return state2;
    }

    @JRubyMethod(name={"report_on_exception"})
    public IRubyObject report_on_exception(ThreadContext context) {
        return this.isReportOnException() ? context.tru : context.fals;
    }

    @JRubyMethod(name={"report_on_exception="}, meta=true)
    public static IRubyObject report_on_exception_set(ThreadContext context, IRubyObject self2, IRubyObject state2) {
        Ruby runtime2 = context.runtime;
        if (state2.isNil()) {
            runtime2.setReportOnException(state2);
        } else {
            runtime2.setReportOnException(runtime2.newBoolean(state2.isTrue()));
        }
        return state2;
    }

    @JRubyMethod(name={"report_on_exception"}, meta=true)
    public static IRubyObject report_on_exception(ThreadContext context, IRubyObject self2) {
        return context.runtime.isReportOnException() ? context.tru : context.fals;
    }

    public StackTraceElement[] javaBacktrace() {
        return this.threadImpl.getStackTrace();
    }

    private boolean isCurrent() {
        return this.threadImpl.isCurrent();
    }

    public void exceptionRaised(RaiseException exception2) {
        this.exceptionRaised((Throwable)exception2);
    }

    protected void printReportExceptionWarning() {
        Ruby runtime2 = this.getRuntime();
        String name2 = this.threadImpl.getReportName();
        runtime2.getErrorStream().println("warning: thread \"" + name2 + "\" terminated with exception (report_on_exception is true):");
    }

    public void exceptionRaised(Throwable throwable) {
        IRubyObject rubyException;
        assert (this.isCurrent());
        Ruby runtime2 = this.getRuntime();
        if (throwable instanceof Error || throwable instanceof MainExitException) {
            this.exitingException = throwable;
            Helpers.throwException(throwable);
            return;
        }
        if (throwable instanceof Unrescuable) {
            Helpers.throwException(throwable);
            return;
        }
        if (throwable instanceof RaiseException) {
            RaiseException exception2 = (RaiseException)throwable;
            rubyException = exception2.getException();
        } else {
            rubyException = JavaUtil.convertJavaToUsableRubyObject(runtime2, throwable);
        }
        if (runtime2.getSystemExit().isInstance(rubyException)) {
            runtime2.getThreadService().getMainThread().raise(rubyException);
        } else {
            boolean report = this.reportOnException;
            if (report || this.abortOnException(runtime2)) {
                if (report) {
                    this.printReportExceptionWarning();
                    runtime2.printError(throwable);
                }
                if (this.abortOnException(runtime2)) {
                    runtime2.getThreadService().getMainThread().raise(rubyException);
                }
            } else if (runtime2.isDebug()) {
                runtime2.printError(throwable);
            }
        }
        this.exitingException = throwable;
    }

    private boolean abortOnException(Ruby runtime2) {
        return runtime2.isAbortOnException() || this.abortOnException;
    }

    public static RubyThread mainThread(IRubyObject receiver2) {
        return receiver2.getRuntime().getThreadService().getMainThread();
    }

    public boolean select(RubyIO io2, int ops) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops);
    }

    public boolean select(RubyIO io2, int ops, long timeout2) {
        return this.select(io2.getChannel(), io2.getOpenFile(), ops, timeout2);
    }

    public boolean select(Channel channel, OpenFile fptr, int ops) {
        return this.select(channel, fptr, ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, -1L);
    }

    public boolean select(Channel channel, RubyIO io2, int ops, long timeout2) {
        return this.select(channel, io2 == null ? null : io2.getOpenFile(), ops, timeout2);
    }

    /*
     * Exception decompiling
     */
    public boolean select(Channel channel, OpenFile fptr, int ops, long timeout) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void interrupt() {
        BlockingTask t;
        Unblocker task;
        BlockingIO.Condition iowait;
        this.setInterrupt();
        Selector activeSelector = this.currentSelector;
        if (activeSelector != null) {
            activeSelector.wakeup();
        }
        if ((iowait = this.blockingIO) != null) {
            iowait.cancel();
        }
        if ((task = this.unblockFunc) != null) {
            task.wakeup(this, this.unblockArg);
        }
        if ((t = this.currentBlockingTask) != null) {
            t.wakeup();
        }
        this.notify();
    }

    public void setInterrupt() {
        int oldFlag;
        while (!INTERRUPT_FLAG_UPDATER.compareAndSet(this, oldFlag = this.interruptFlag, oldFlag | 2)) {
        }
    }

    public boolean waitForIO(ThreadContext context, RubyIO io2, int ops) {
        Channel channel = io2.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            return true;
        }
        try {
            io2.addBlockingThread(this);
            this.blockingIO = BlockingIO.newCondition(channel, ops);
            boolean ready = this.blockingIO.await();
            this.blockingThreadPoll(context);
            boolean bl = ready;
            return bl;
        }
        catch (IOException ioe) {
            throw context.runtime.newRuntimeError("Error with selector: " + ioe);
        }
        catch (InterruptedException ex) {
            throw context.runtime.newRuntimeError("Interrupted");
        }
        finally {
            this.blockingIO = null;
            io2.removeBlockingThread(this);
        }
    }

    public void beforeBlockingCall(ThreadContext context) {
        this.blockingThreadPoll(context);
        this.enterSleep();
    }

    @Deprecated
    public void beforeBlockingCall() {
        this.beforeBlockingCall(this.metaClass.runtime.getCurrentContext());
    }

    public void afterBlockingCall() {
        this.exitSleep();
        this.pollThreadEvents();
    }

    public boolean wait_timeout(IRubyObject o, Double timeout2) throws InterruptedException {
        if (timeout2 != null) {
            long end_ns;
            long delay_ns = (long)(timeout2 * 1.0E9);
            long start_ns = System.nanoTime();
            if (delay_ns > 0L) {
                long delay_ms = delay_ns / 1000000L;
                int delay_ns_remainder = (int)(delay_ns % 1000000L);
                this.executeBlockingTask(new SleepTask(o, delay_ms, delay_ns_remainder));
            }
            return (end_ns = System.nanoTime()) - start_ns <= delay_ns;
        }
        this.executeBlockingTask(new SleepTask(o, 0L, 0));
        return true;
    }

    public RubyThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyThread other = (RubyThread)obj;
        return this.threadImpl == other.threadImpl || this.threadImpl != ThreadLike.DUMMY && this.threadImpl.equals(other.threadImpl);
    }

    @Override
    public int hashCode() {
        return 97 * (3 + (this.threadImpl != ThreadLike.DUMMY ? this.threadImpl.hashCode() : 0));
    }

    @Override
    public String toString() {
        return this.threadImpl.toString();
    }

    public void lock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.lock();
        this.heldLocks.add(lock2);
    }

    public void lockInterruptibly(final Lock lock2) throws InterruptedException {
        assert (Thread.currentThread() == this.getNativeThread());
        this.executeTaskBlocking(this.getContext(), lock2, new Task<Lock, Object>(){

            @Override
            public Object run(ThreadContext context, Lock reentrantLock) throws InterruptedException {
                reentrantLock.lockInterruptibly();
                RubyThread.this.heldLocks.add(lock2);
                return reentrantLock;
            }

            @Override
            public void wakeup(RubyThread thread2, Lock reentrantLock) {
                thread2.getNativeThread().interrupt();
            }
        });
    }

    public boolean tryLock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        boolean locked2 = lock2.tryLock();
        if (locked2) {
            this.heldLocks.add(lock2);
        }
        return locked2;
    }

    public void unlock(Lock lock2) {
        assert (Thread.currentThread() == this.getNativeThread());
        lock2.unlock();
        this.heldLocks.remove(lock2);
    }

    public void unlockAll() {
        assert (Thread.currentThread() == this.getNativeThread());
        for (Lock lock2 : this.heldLocks) {
            try {
                lock2.unlock();
            }
            catch (IllegalMonitorStateException imse) {
                this.getRuntime().getWarnings().warn("BUG: attempted to unlock a non-acquired lock " + lock2 + " in thread " + this.toString());
            }
        }
    }

    public void sleep(Lock lock2) throws InterruptedException {
        this.sleep(lock2, 0L);
    }

    public void sleep(Lock lock2, final long millis) throws InterruptedException {
        assert (Thread.currentThread() == this.getNativeThread());
        this.executeTaskBlocking(this.getContext(), lock2.newCondition(), Status.NATIVE, new Task<Condition, Object>(){

            @Override
            public Object run(ThreadContext context, Condition condition) throws InterruptedException {
                if (millis == 0L) {
                    condition.await();
                } else {
                    condition.await(millis, TimeUnit.MILLISECONDS);
                }
                return null;
            }

            @Override
            public void wakeup(RubyThread thread2, Condition condition) {
                thread2.getNativeThread().interrupt();
            }
        });
    }

    private String identityString() {
        return "0x" + Integer.toHexString(System.identityHashCode(this));
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == Object.class) {
            return super.toJava(target2);
        }
        if (target2.isAssignableFrom(Thread.class)) {
            return target2.cast(this.getNativeThread());
        }
        return super.toJava(target2);
    }

    public static <StateType> IRubyObject uninterruptible(ThreadContext context, StateType state2, BiFunction<ThreadContext, StateType, IRubyObject> f) {
        Ruby runtime2 = context.runtime;
        return context.getThread().handleInterrupt(context, RubyHash.newHash(runtime2, runtime2.getObject(), (IRubyObject)runtime2.newSymbol("never")), state2, f);
    }

    public IRubyObject setFiberScheduler(IRubyObject scheduler) {
        scheduler.getClass();
        if (scheduler != null && !scheduler.isNil()) {
            FiberScheduler.verifyInterface(scheduler);
        }
        if (!this.scheduler.isNil()) {
            FiberScheduler.close(this.getContext(), this.scheduler);
        }
        this.scheduler = scheduler;
        return scheduler;
    }

    public IRubyObject getScheduler() {
        return this.scheduler;
    }

    public IRubyObject getSchedulerCurrent() {
        if (!this.isBlocking()) {
            return this.scheduler;
        }
        return this.getRuntime().getNil();
    }

    public void incrementBlocking() {
        ++this.blockingCount;
    }

    public void decrementBlocking() {
        --this.blockingCount;
    }

    public boolean isBlocking() {
        return this.blockingCount > 0;
    }

    @Deprecated
    public IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.pending_interrupt_p(context);
            }
            case 1: {
                return this.pending_interrupt_p(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    @Deprecated
    public static IRubyObject pending_interrupt_p(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        return context.getThread().pending_interrupt_p(context, args2);
    }

    @Deprecated
    public RubyBoolean alive_p() {
        return this.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Deprecated
    public IRubyObject value() {
        return this.value(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject join(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.join(context);
            }
            case 1: {
                return this.join(context, args2[0]);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0, 1);
    }

    public static interface RegexMatch
    extends Unblocker<Matcher> {
        public int run(Matcher var1, int var2, int var3, int var4) throws InterruptedException;

        @Override
        default public void wakeup(RubyThread thread2, Matcher matcher) {
            thread2.getNativeThread().interrupt();
        }
    }

    public static interface ReadWrite<Data>
    extends Unblocker<Data> {
        default public int run(ThreadContext context, Data data2, byte[] bytes2, int start2, int length2) throws InterruptedException {
            return this.run(context, data2, ByteBuffer.wrap(bytes2), start2, length2);
        }

        public int run(ThreadContext var1, Data var2, ByteBuffer var3, int var4, int var5) throws InterruptedException;

        @Override
        public void wakeup(RubyThread var1, Data var2);
    }

    private static class SleepTask2
    implements Task<Object, Long> {
        final Semaphore semaphore = new Semaphore(1);
        long millis;

        private SleepTask2() {
            this.semaphore.drainPermits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long run(ThreadContext context, Object data2) throws InterruptedException {
            long start2 = System.currentTimeMillis();
            try {
                if (this.millis == 0L) {
                    this.semaphore.tryAcquire(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                } else {
                    this.semaphore.tryAcquire(this.millis, TimeUnit.MILLISECONDS);
                }
                Long l = System.currentTimeMillis() - start2;
                return l;
            }
            finally {
                this.semaphore.drainPermits();
            }
        }

        @Override
        public void wakeup(RubyThread thread2, Object data2) {
            this.semaphore.release();
        }
    }

    public static final class SleepTask
    implements BlockingTask {
        private final Object object;
        private final long millis;
        private final int nanos;

        public SleepTask(Object object, long millis, int nanos) {
            this.object = object;
            this.millis = millis;
            this.nanos = nanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws InterruptedException {
            Object object = this.object;
            synchronized (object) {
                this.object.wait(this.millis, this.nanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeup() {
            Object object = this.object;
            synchronized (object) {
                this.object.notify();
            }
        }
    }

    public static interface Task<Data, Return>
    extends Unblocker<Data> {
        public Return run(ThreadContext var1, Data var2) throws InterruptedException;

        @Override
        public void wakeup(RubyThread var1, Data var2);
    }

    public static interface Unblocker<Data> {
        public void wakeup(RubyThread var1, Data var2);
    }

    @Deprecated
    public static interface BlockingTask {
        public void run() throws InterruptedException;

        public void wakeup();
    }

    public static class Location
    extends RubyObject {
        private final RubyStackTraceElement element;
        private transient RubyString baseLabel = null;
        private transient RubyString label = null;

        public Location(Ruby runtime2, RubyClass klass, RubyStackTraceElement element) {
            super(runtime2, klass);
            this.element = element;
        }

        @JRubyMethod
        public IRubyObject absolute_path(ThreadContext context) {
            Ruby runtime2 = context.runtime;
            return runtime2.newString(runtime2.getLoadService().getPathForLocation(this.element.getFileName()));
        }

        @JRubyMethod
        public IRubyObject base_label(ThreadContext context) {
            if (this.baseLabel == null) {
                this.baseLabel = context.runtime.newString(this.element.getMethodName());
            }
            return this.baseLabel;
        }

        @JRubyMethod
        public IRubyObject inspect(ThreadContext context) {
            return this.to_s(context).inspect();
        }

        @JRubyMethod
        public IRubyObject label(ThreadContext context) {
            if (this.element.getFrameType() == FrameType.BLOCK) {
                if (this.label == null) {
                    this.label = context.runtime.newString("block in " + this.element.getMethodName());
                }
                return this.label;
            }
            return this.base_label(context);
        }

        @JRubyMethod
        public IRubyObject lineno(ThreadContext context) {
            return context.runtime.newFixnum(this.element.getLineNumber());
        }

        @JRubyMethod
        public IRubyObject path(ThreadContext context) {
            return context.runtime.newString(this.element.getFileName());
        }

        @JRubyMethod
        public IRubyObject to_s(ThreadContext context) {
            return RubyStackTraceElement.to_s_mri(context, this.element);
        }

        public static RubyArray newLocationArray(Ruby runtime2, RubyStackTraceElement[] elements) {
            return Location.newLocationArray(runtime2, elements, 0, elements.length);
        }

        public static RubyArray newLocationArray(Ruby runtime2, RubyStackTraceElement[] elements, int offset2, int length2) {
            RubyClass locationClass = runtime2.getLocation();
            IRubyObject[] ary = new IRubyObject[length2];
            for (int i2 = 0; i2 < length2; ++i2) {
                ary[i2] = new Location(runtime2, locationClass, elements[i2 + offset2]);
            }
            return RubyArray.newArrayNoCopy(runtime2, ary);
        }
    }

    public static class Backtrace
    extends RubyObject {
        public Backtrace(Ruby runtime2, RubyClass metaClass) {
            super(runtime2, metaClass);
        }

        @JRubyMethod(module=true)
        public static IRubyObject limit(ThreadContext context, IRubyObject self2) {
            return context.runtime.newFixnum(context.runtime.getInstanceConfig().getBacktraceLimit());
        }
    }

    public static enum Status {
        RUN,
        SLEEP,
        ABORTING,
        DEAD,
        NATIVE;

        public final ByteList bytes = new ByteList(this.toString().toLowerCase().getBytes(RubyEncoding.UTF8), false);
    }
}

