/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.log.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;

public class JULLogHandler
implements LogHandler {
    private static final String LOGGER_NAME = "asciidoctor";
    private static final Logger LOGGER = Logger.getLogger("asciidoctor");

    @Override
    public void log(LogRecord logRecord) {
        java.util.logging.LogRecord julLogRecord = new java.util.logging.LogRecord(JULLogHandler.mapSeverity(logRecord.getSeverity()), (String)(logRecord.getCursor() != null ? logRecord.getCursor().toString() + ": " + logRecord.getMessage() : logRecord.getMessage()));
        julLogRecord.setSourceClassName(logRecord.getSourceFileName());
        julLogRecord.setSourceMethodName(logRecord.getSourceMethodName());
        julLogRecord.setParameters(new Object[]{logRecord.getCursor()});
        julLogRecord.setLoggerName(LOGGER_NAME);
        LOGGER.log(julLogRecord);
    }

    private static Level mapSeverity(Severity severity) {
        switch (severity) {
            case DEBUG: {
                return Level.FINEST;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARN: {
                return Level.WARNING;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case FATAL: {
                return Level.SEVERE;
            }
        }
        return Level.INFO;
    }
}

