/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.InputStream;
import org.asciidoctor.jruby.internal.IOUtils;
import org.jruby.Ruby;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyUtils {
    public static <T> T rubyToJava(Ruby runtime2, IRubyObject rubyObject, Class<T> returnType) {
        return JavaEmbedUtils.rubyToJava(runtime2, rubyObject, returnType);
    }

    public static RubySymbol toSymbol(Ruby rubyRuntime, String key2) {
        return RubySymbol.newSymbol(rubyRuntime, key2);
    }

    public static void requireLibrary(Ruby rubyRuntime, String require2) {
        rubyRuntime.evalScriptlet(String.format("require '%s'", require2));
    }

    public static void loadRubyClass(Ruby rubyRuntime, InputStream rubyClassDefinition) {
        String script = IOUtils.readFull(rubyClassDefinition);
        rubyRuntime.evalScriptlet(script);
    }

    public static void setGlobalVariable(Ruby rubyRuntime, String variableName, Object variableValue) {
        String script = String.format("$%s = %s", variableName, variableValue);
        rubyRuntime.evalScriptlet(script);
    }
}

