/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.util.HashMap;
import java.util.Map;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.JavaConverterRegistry;
import org.asciidoctor.converter.OutputFormatWriter;
import org.asciidoctor.jruby.converter.internal.ConverterProxy;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.java.codegen.Reified;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConverterRegistryImpl
implements JavaConverterRegistry {
    private Ruby rubyRuntime;
    private JRubyAsciidoctor asciidoctor;

    public JavaConverterRegistryImpl(JRubyAsciidoctor asciidoctor) {
        this.asciidoctor = asciidoctor;
        this.rubyRuntime = asciidoctor.getRubyRuntime();
    }

    @Override
    public <U, T extends Converter<U> & OutputFormatWriter<U>> void register(Class<T> converterClass, String ... backends) {
        RubyClass clazz = ConverterProxy.register(this.asciidoctor, converterClass);
        ConverterFor converterForAnnotation = converterClass.getAnnotation(ConverterFor.class);
        if (converterForAnnotation != null) {
            String backend = !"".equals(converterForAnnotation.format()) ? converterForAnnotation.format() : converterForAnnotation.value();
            this.getConverterFactory().callMethod("register", clazz, this.rubyRuntime.newString(backend));
        } else if (backends.length == 0) {
            this.getConverterFactory().callMethod("register", clazz, this.rubyRuntime.newString("*"));
        }
        if (backends.length > 0) {
            for (String backend : backends) {
                this.getConverterFactory().callMethod("register", clazz, this.rubyRuntime.newString(backend));
            }
        }
    }

    @Override
    public Class<?> resolve(String backend) {
        RubyClass rubyClass = (RubyClass)this.getConverterFactory().callMethod("for", (IRubyObject)this.rubyRuntime.newString(backend));
        Class<? extends Reified> clazz = rubyClass.getReifiedClass();
        if (clazz != null) {
            return clazz;
        }
        if (rubyClass.getAllocator() instanceof ConverterProxy.Allocator) {
            ConverterProxy.Allocator allocator = (ConverterProxy.Allocator)rubyClass.getAllocator();
            return allocator.getConverterClass();
        }
        return null;
    }

    @Override
    public void unregisterAll() {
        this.getConverterFactory().callMethod("unregister_all");
    }

    private RubyModule getConverterFactory() {
        return this.rubyRuntime.getModule("Asciidoctor").getModule("Converter");
    }

    @Override
    public Map<String, Class<?>> converters() {
        RubyArray rubyKeys = (RubyArray)this.getConverterFactory().callMethod("converters").callMethod(this.rubyRuntime.getCurrentContext(), "keys");
        HashMap converters = new HashMap();
        for (Object rubyBackend : rubyKeys) {
            String backend = rubyBackend.toString();
            converters.put(backend, this.resolve(backend));
        }
        return converters;
    }
}

