/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import org.asciidoctor.Options;
import org.asciidoctor.ast.Document;
import org.asciidoctor.converter.JavaConverterRegistry;
import org.asciidoctor.extension.ExtensionGroup;
import org.asciidoctor.extension.JavaExtensionRegistry;
import org.asciidoctor.extension.RubyExtensionRegistry;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.asciidoctor.jruby.converter.internal.ConverterRegistryExecutor;
import org.asciidoctor.jruby.extension.internal.ExtensionRegistryExecutor;
import org.asciidoctor.jruby.internal.AsciidoctorCoreException;
import org.asciidoctor.jruby.internal.EnvironmentInjector;
import org.asciidoctor.jruby.internal.ExtensionGroupImpl;
import org.asciidoctor.jruby.internal.IOUtils;
import org.asciidoctor.jruby.internal.JavaConverterRegistryImpl;
import org.asciidoctor.jruby.internal.JavaExtensionRegistryImpl;
import org.asciidoctor.jruby.internal.RubyExtensionRegistryImpl;
import org.asciidoctor.jruby.internal.RubyGemsPreloader;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.asciidoctor.jruby.internal.RubyOutputStreamWrapper;
import org.asciidoctor.jruby.internal.RubyUtils;
import org.asciidoctor.jruby.internal.SyntaxHighlighterRegistryImpl;
import org.asciidoctor.jruby.log.internal.JULLogHandler;
import org.asciidoctor.jruby.log.internal.JavaLogger;
import org.asciidoctor.jruby.log.internal.LogHandlerRegistryExecutor;
import org.asciidoctor.jruby.syntaxhighlighter.internal.SyntaxHighlighterRegistryExecutor;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.syntaxhighlighter.SyntaxHighlighterRegistry;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyAsciidoctor
implements AsciidoctorJRuby,
LogHandler {
    private static final Logger logger = Logger.getLogger(JRubyAsciidoctor.class.getName());
    private static final String GEM_PATH = "GEM_PATH";
    protected RubyGemsPreloader rubyGemsPreloader;
    protected Ruby rubyRuntime;
    private RubyClass extensionGroupClass;
    private final List<LogHandler> logHandlers = new ArrayList<LogHandler>();

    public JRubyAsciidoctor() {
        this(JRubyAsciidoctor.createRubyRuntime(Collections.singletonMap(GEM_PATH, null), new ArrayList<String>(), null));
        JRubyAsciidoctor.processRegistrations(this);
    }

    private JRubyAsciidoctor(Ruby rubyRuntime) {
        this.rubyRuntime = rubyRuntime;
        InputStream inputStream = this.getClass().getResourceAsStream("asciidoctorclass.rb");
        String script = IOUtils.readFull(inputStream);
        this.rubyRuntime.evalScriptlet(script);
        this.rubyGemsPreloader = new RubyGemsPreloader(this.rubyRuntime);
        this.logHandlers.add(new JULLogHandler());
        RubyOutputStreamWrapper.createOutputStreamWrapperClass(this.rubyRuntime);
    }

    public static JRubyAsciidoctor create() {
        return JRubyAsciidoctor.create((String)null);
    }

    public static JRubyAsciidoctor create(String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), new ArrayList<String>(), null));
    }

    public static JRubyAsciidoctor create(List<String> loadPaths) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(null, loadPaths, null));
    }

    public static JRubyAsciidoctor create(ClassLoader classloader) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(null, new ArrayList<String>(), classloader));
    }

    public static JRubyAsciidoctor create(ClassLoader classloader, String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), new ArrayList<String>(), classloader));
    }

    public static JRubyAsciidoctor create(List<String> loadPaths, String gemPath) {
        return JRubyAsciidoctor.processRegistrations(JRubyAsciidoctor.createJRubyAsciidoctorInstance(Collections.singletonMap(GEM_PATH, gemPath), loadPaths, null));
    }

    private static JRubyAsciidoctor processRegistrations(JRubyAsciidoctor asciidoctor) {
        JRubyAsciidoctor.registerExtensions(asciidoctor);
        JRubyAsciidoctor.registerConverters(asciidoctor);
        JRubyAsciidoctor.registerSyntaxHighlighters(asciidoctor);
        JRubyAsciidoctor.registerLogHandlers(asciidoctor);
        JavaLogger.install(asciidoctor.getRubyRuntime(), asciidoctor);
        return asciidoctor;
    }

    private static void registerConverters(AsciidoctorJRuby asciidoctor) {
        new ConverterRegistryExecutor(asciidoctor).registerAllConverters();
    }

    private static void registerExtensions(AsciidoctorJRuby asciidoctor) {
        new ExtensionRegistryExecutor(asciidoctor).registerAllExtensions();
    }

    private static void registerSyntaxHighlighters(AsciidoctorJRuby asciidoctor) {
        new SyntaxHighlighterRegistryExecutor(asciidoctor).registerAllSyntaxHighlighter();
    }

    private static void registerLogHandlers(AsciidoctorJRuby asciidoctor) {
        new LogHandlerRegistryExecutor(asciidoctor).registerAllLogHandlers();
    }

    private static JRubyAsciidoctor createJRubyAsciidoctorInstance(Map<String, String> environmentVars, List<String> loadPaths, ClassLoader classloader) {
        Ruby rubyRuntime = JRubyAsciidoctor.createRubyRuntime(environmentVars, loadPaths, classloader);
        return new JRubyAsciidoctor(rubyRuntime);
    }

    private static Ruby createRubyRuntime(Map<String, String> environmentVars, List<String> loadPaths, ClassLoader classloader) {
        HashMap<String, String> env = environmentVars != null ? new HashMap<String, String>(environmentVars) : new HashMap();
        RubyInstanceConfig config = JRubyAsciidoctor.createOptimizedConfiguration();
        if (classloader != null) {
            config.setLoader(classloader);
        }
        JRubyAsciidoctor.injectEnvironmentVariables(config, env);
        return JavaEmbedUtils.initialize(loadPaths, config);
    }

    private static void injectEnvironmentVariables(RubyInstanceConfig config, Map<String, String> environmentVars) {
        EnvironmentInjector environmentInjector = new EnvironmentInjector(config);
        environmentInjector.inject(environmentVars);
    }

    private static RubyInstanceConfig createOptimizedConfiguration() {
        return new RubyInstanceConfig();
    }

    @Override
    public void close() {
        if (this.rubyRuntime != null) {
            this.rubyRuntime.tearDown();
        }
    }

    @Override
    public void registerLogHandler(LogHandler logHandler) {
        if (!this.logHandlers.contains(logHandler)) {
            this.logHandlers.add(logHandler);
        }
    }

    @Override
    public void unregisterLogHandler(LogHandler logHandler) {
        this.logHandlers.remove(logHandler);
    }

    public Ruby getRubyRuntime() {
        return this.rubyRuntime;
    }

    private List<String> convertAllFiles(Options options2, Iterable<File> asciidoctorFiles) {
        ArrayList<String> asciidoctorContent = new ArrayList<String>();
        for (File asciidoctorFile : asciidoctorFiles) {
            String renderedFile = this.convertFile(asciidoctorFile, options2);
            if (renderedFile == null) continue;
            asciidoctorContent.add(renderedFile);
        }
        return asciidoctorContent;
    }

    @Override
    public void requireLibrary(String ... library2) {
        this.requireLibraries(Arrays.asList(library2));
    }

    @Override
    public void requireLibraries(Collection<String> libraries) {
        if (libraries != null) {
            for (String library2 : libraries) {
                RubyUtils.requireLibrary(this.rubyRuntime, library2);
            }
        }
    }

    @Override
    public JavaExtensionRegistry javaExtensionRegistry() {
        return new JavaExtensionRegistryImpl(this);
    }

    @Override
    public RubyExtensionRegistry rubyExtensionRegistry() {
        return new RubyExtensionRegistryImpl(this.rubyRuntime);
    }

    @Override
    public JavaConverterRegistry javaConverterRegistry() {
        return new JavaConverterRegistryImpl(this);
    }

    @Override
    public SyntaxHighlighterRegistry syntaxHighlighterRegistry() {
        return new SyntaxHighlighterRegistryImpl(this);
    }

    @Override
    public void unregisterAllExtensions() {
        this.getExtensionsModule().callMethod("unregister_all");
    }

    @Override
    public void shutdown() {
        this.rubyRuntime.tearDown();
    }

    @Override
    public String asciidoctorVersion() {
        return RubyUtils.rubyToJava(this.rubyRuntime, this.getAsciidoctorModule().getConstant("VERSION"), String.class);
    }

    private RubyModule getExtensionsModule() {
        return this.getAsciidoctorModule().defineOrGetModuleUnder("Extensions");
    }

    private RubyModule getAsciidoctorModule() {
        return this.rubyRuntime.getModule("Asciidoctor");
    }

    public <T> T convert(String content, Map<String, Object> options2, Class<T> expectedResult) {
        Object toFileOption;
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        if (this.containsAttributeWithValue(options2, "source-highlighter", "pygments")) {
            logger.fine("In order to use Pygments with Asciidoctor, you need to install Pygments (and Python, if you don't have it yet). Read https://docs.asciidoctor.org/asciidoctor/latest/syntax-highlighting/pygments.");
        }
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        if (options2.containsKey("base_dir")) {
            this.rubyRuntime.setCurrentDirectory((String)options2.get("base_dir"));
        }
        if ((toFileOption = options2.get("to_file")) instanceof OutputStream) {
            options2.put("to_file", RubyOutputStreamWrapper.wrap(this.getRubyRuntime(), (OutputStream)toFileOption));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        try {
            IRubyObject[] iRubyObjectArray = new IRubyObject[2];
            iRubyObjectArray[0] = Optional.ofNullable(content).map(this.rubyRuntime::newString).orElse(null);
            iRubyObjectArray[1] = rubyHash;
            IRubyObject object = this.getAsciidoctorModule().callMethod("convert", iRubyObjectArray);
            T t = this.adaptReturn(object, expectedResult);
            return t;
        }
        catch (RaiseException e) {
            logger.severe(e.getException().getClass().getCanonicalName());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    private boolean containsAttributeWithValue(Map<String, Object> options2, String attributeName, String attributeValue) {
        return Optional.ofNullable((Map)options2.get("attributes")).map(attributes -> (String)attributes.get(attributeName)).map(value2 -> value2.equals(attributeValue)).orElse(Boolean.FALSE);
    }

    @Override
    public String convert(String content, Options options2) {
        return this.convert(content, options2, String.class);
    }

    @Override
    public <T> T convert(String content, Options options2, Class<T> expectedResult) {
        return this.convert(content, options2.map(), expectedResult);
    }

    @Override
    public void convert(Reader contentReader, Writer rendererWriter, Options options2) throws IOException {
        String content = IOUtils.readFull(contentReader);
        String renderedContent = this.convert(content, options2);
        IOUtils.writeFull(rendererWriter, renderedContent);
    }

    public <T> T convertFile(File file2, Map<String, Object> options2, Class<T> expectedResult) {
        this.rubyGemsPreloader.preloadRequiredLibraries(options2);
        String currentDirectory = this.rubyRuntime.getCurrentDirectory();
        Object toFileOption = options2.get("to_file");
        if (toFileOption instanceof OutputStream) {
            options2.put("to_file", RubyOutputStreamWrapper.wrap(this.getRubyRuntime(), (OutputStream)toFileOption));
        }
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2);
        try {
            IRubyObject object = this.getAsciidoctorModule().callMethod("convert_file", this.rubyRuntime.newString(file2.toString()), rubyHash);
            T t = this.adaptReturn(object, expectedResult);
            return t;
        }
        catch (RaiseException e) {
            logger.severe(e.getMessage());
            throw new AsciidoctorCoreException(e);
        }
        finally {
            this.rubyRuntime.setCurrentDirectory(currentDirectory);
        }
    }

    private <T> T adaptReturn(IRubyObject object, Class<T> expectedType) {
        if (NodeConverter.NodeType.DOCUMENT_CLASS.isInstance(object)) {
            if (Document.class.isAssignableFrom(expectedType)) {
                return (T)NodeConverter.createASTNode(object);
            }
            return null;
        }
        if (RubyString.class.isInstance(object)) {
            if (String.class.isAssignableFrom(expectedType)) {
                return (T)object.asJavaString();
            }
            return null;
        }
        return RubyUtils.rubyToJava(this.rubyRuntime, object, expectedType);
    }

    @Override
    public String convertFile(File file2, Options options2) {
        return this.convertFile(file2, options2, String.class);
    }

    @Override
    public <T> T convertFile(File file2, Options options2, Class<T> expectedResult) {
        return this.convertFile(file2, options2.map(), expectedResult);
    }

    @Override
    public String[] convertDirectory(Iterable<File> directoryWalker, Options options2) {
        List<String> asciidoctorContent = this.convertAllFiles(options2, directoryWalker);
        return asciidoctorContent.toArray(new String[0]);
    }

    @Override
    public String[] convertFiles(Collection<File> asciidoctorFiles, Options options2) {
        List<String> asciidoctorContent = this.convertAllFiles(options2, asciidoctorFiles);
        return asciidoctorContent.toArray(new String[0]);
    }

    @Override
    public Document load(String content, Options options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2.map());
        IRubyObject[] iRubyObjectArray = new IRubyObject[2];
        iRubyObjectArray[0] = Optional.ofNullable(content).map(this.rubyRuntime::newString).orElse(null);
        iRubyObjectArray[1] = rubyHash;
        return (Document)NodeConverter.createASTNode(this.getAsciidoctorModule().callMethod("load", iRubyObjectArray));
    }

    @Override
    public Document loadFile(File file2, Options options2) {
        RubyHash rubyHash = RubyHashUtil.convertMapToRubyHashWithSymbols(this.rubyRuntime, options2.map());
        return (Document)NodeConverter.createASTNode(this.getAsciidoctorModule().callMethod("load_file", this.rubyRuntime.newString(file2.getAbsolutePath()), rubyHash));
    }

    @Override
    public ExtensionGroup createGroup() {
        return this.createGroup(UUID.randomUUID().toString());
    }

    @Override
    public ExtensionGroup createGroup(String groupName) {
        return new ExtensionGroupImpl(groupName, this, this.getExtensionGroupClass());
    }

    private RubyClass getExtensionGroupClass() {
        if (this.extensionGroupClass == null) {
            this.extensionGroupClass = ExtensionGroupImpl.createExtensionGroupClass(this.rubyRuntime);
        }
        return this.extensionGroupClass;
    }

    @Override
    public void log(LogRecord logRecord) {
        for (LogHandler logHandler : this.logHandlers) {
            logHandler.log(logRecord);
        }
    }
}

