/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;

public final class Extensions {
    private Extensions() {
    }

    public static <T> Constructor<T> findConstructorWithMostMatchingArguments(Class<T> clazz, Object ... args2) {
        int numberOfMatchingArguments = -1;
        Constructor<?> bestConstructor = null;
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            int currentNumberOfArguments = constructor2.getParameterTypes().length;
            if (currentNumberOfArguments <= numberOfMatchingArguments || !Extensions.isConstructorCandidate(constructor2, args2)) continue;
            numberOfMatchingArguments = currentNumberOfArguments;
            bestConstructor = constructor2;
        }
        if (bestConstructor != null) {
            return bestConstructor;
        }
        ArrayList expectedTypes = new ArrayList(args2.length);
        for (Object arg2 : args2) {
            if (arg2 == null) {
                expectedTypes.add(Void.class);
                continue;
            }
            expectedTypes.add(arg2.getClass());
        }
        throw new IllegalArgumentException("Extension class " + clazz.getName() + " does not provide a constructor accepting " + expectedTypes);
    }

    private static boolean isConstructorCandidate(Constructor<?> constructor2, Object ... args2) {
        if (constructor2.getParameterTypes().length > args2.length) {
            return false;
        }
        Class<?>[] constructorParameterTypes = constructor2.getParameterTypes();
        for (int i2 = 0; i2 < constructorParameterTypes.length; ++i2) {
            if (args2[i2] == null || constructorParameterTypes[i2].isAssignableFrom(args2[i2].getClass())) continue;
            return false;
        }
        return true;
    }
}

