/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.extension.processorproxies;

import java.util.concurrent.atomic.AtomicInteger;
import org.asciidoctor.jruby.extension.processorproxies.JRubyAsciidoctorObjectAllocator;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;

public final class ProcessorProxyUtil {
    private static AtomicInteger extensionCounter = new AtomicInteger();

    private ProcessorProxyUtil() {
    }

    public static RubyClass getExtensionBaseClass(Ruby rubyRuntime, String processorClassName) {
        RubyModule extensionsModule = ProcessorProxyUtil.getExtensionsModule(rubyRuntime);
        return extensionsModule.getClass(processorClassName);
    }

    private static RubyModule getExtensionsModule(Ruby rubyRuntime) {
        RubyModule asciidoctorModule = rubyRuntime.getModule("Asciidoctor");
        return asciidoctorModule.defineOrGetModuleUnder("Extensions");
    }

    public static RubyClass defineProcessorClass(Ruby rubyRuntime, String baseClassName, JRubyAsciidoctorObjectAllocator objectAllocator) {
        RubyClass baseClass = ProcessorProxyUtil.getExtensionBaseClass(rubyRuntime, baseClassName);
        String rubyClassName = "JavaExtensionProxy_" + extensionCounter.getAndIncrement();
        return ProcessorProxyUtil.getExtensionsModule(baseClass.getRuntime()).defineClassUnder(rubyClassName, baseClass, objectAllocator);
    }

    public static void defineAnnotatedMethods(RubyClass rubyClass, Class<?> proxyClass) {
        for (Class<?> currentClass = proxyClass; currentClass != RubyObject.class; currentClass = currentClass.getSuperclass()) {
            rubyClass.defineAnnotatedMethods(currentClass);
        }
    }
}

