/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.converter.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import org.asciidoctor.ast.ContentNode;
import org.asciidoctor.converter.Converter;
import org.asciidoctor.converter.ConverterFor;
import org.asciidoctor.converter.OutputFormatWriter;
import org.asciidoctor.jruby.ast.impl.NodeConverter;
import org.asciidoctor.jruby.internal.JRubyAsciidoctor;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.asciidoctor.jruby.internal.RubyOutputStreamWrapper;
import org.asciidoctor.log.Logging;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ConverterProxy<T>
extends RubyObject {
    protected static final String METHOD_NAME_INITIALIZE = "initialize";
    private final JRubyAsciidoctor asciidoctor;
    private T output;
    private final Class<? extends Converter> converterClass;
    private Converter<T> delegate;

    public static <U, T extends Converter<U> & OutputFormatWriter<U>> RubyClass register(JRubyAsciidoctor asciidoctor, Class<T> converterClass) {
        Ruby rubyRuntime = asciidoctor.getRubyRuntime();
        RubyModule module = rubyRuntime.defineModule(ConverterProxy.getModuleName(converterClass));
        RubyClass clazz = module.defineClassUnder(converterClass.getSimpleName(), rubyRuntime.getObject(), new Allocator(converterClass, asciidoctor));
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Converter");
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Converter", "BackendTraits");
        clazz.defineAnnotatedMethod(ConverterProxy.class, METHOD_NAME_INITIALIZE);
        clazz.defineAnnotatedMethod(ConverterProxy.class, "convert");
        ConverterProxy.includeModule(clazz, "Asciidoctor", "Writer");
        clazz.defineAnnotatedMethod(ConverterProxy.class, "write");
        return clazz;
    }

    public ConverterProxy(Ruby runtime2, RubyClass metaClass, Class<? extends Converter> converterClass, JRubyAsciidoctor asciidoctor) {
        super(runtime2, metaClass);
        this.converterClass = converterClass;
        this.asciidoctor = asciidoctor;
    }

    @JRubyMethod(required=1, optional=1)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        try {
            String backend = JavaEmbedUtils.rubyToJava(this.getRuntime(), args2[0], String.class);
            Constructor<? extends Converter> constructor2 = this.converterClass.getConstructor(String.class, Map.class);
            this.delegate = constructor2.newInstance(backend, args2.length < 2 ? Collections.emptyMap() : new RubyHashMapDecorator((RubyHash)args2[1]));
            if (this.delegate instanceof Logging) {
                ((Logging)((Object)this.delegate)).setLogHandler(this.asciidoctor);
            }
            RubyHash options2 = RubyHashUtil.convertMapToRubyHashWithSymbols(context.getRuntime(), this.delegate.getOptions());
            Helpers.invokeSuper(context, (IRubyObject)this, (RubyModule)this.getMetaClass(), METHOD_NAME_INITIALIZE, new IRubyObject[]{args2[0], options2}, Block.NULL_BLOCK);
            String outfileSuffix = this.getOutfileSuffix();
            if (outfileSuffix != null) {
                this.callMethod(context, "outfilesuffix", (IRubyObject)this.getRuntime().newString(outfileSuffix));
            }
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private String getOutfileSuffix() {
        ConverterFor converterAnnotation;
        String outfileSuffix = this.delegate.getOutfileSuffix();
        if (outfileSuffix == null && this.delegate.getClass().getAnnotation(ConverterFor.class) != null && (converterAnnotation = this.delegate.getClass().getAnnotation(ConverterFor.class)).suffix() != "") {
            outfileSuffix = converterAnnotation.suffix();
            this.delegate.setOutfileSuffix(outfileSuffix);
        }
        return outfileSuffix;
    }

    @JRubyMethod(required=1, optional=2)
    public IRubyObject convert(ThreadContext context, IRubyObject[] args2) {
        ContentNode node = NodeConverter.createASTNode(args2[0]);
        Object ret = null;
        if (args2.length == 1) {
            ret = this.delegate.convert(node, null, Collections.emptyMap());
        } else if (args2.length == 2) {
            ret = this.delegate.convert(node, JavaEmbedUtils.rubyToJava(this.getRuntime(), args2[1], String.class), Collections.emptyMap());
        } else if (args2.length == 3) {
            ret = this.delegate.convert(node, JavaEmbedUtils.rubyToJava(this.getRuntime(), args2[1], String.class), JavaEmbedUtils.rubyToJava(this.getRuntime(), args2[2], Map.class));
        }
        this.output = ret;
        return JavaEmbedUtils.javaToRuby(this.getRuntime(), ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod
    public IRubyObject write(ThreadContext context, IRubyObject output, IRubyObject target2) throws IOException {
        OutputStream out = null;
        if (target2 instanceof JavaProxy) {
            JavaProxy javaProxy = (JavaProxy)target2;
            if (!(javaProxy.getObject() instanceof OutputStream)) throw new IllegalArgumentException("Can't write to a " + javaProxy.getObject());
            out = (OutputStream)((JavaProxy)target2).getObject();
        } else if (target2 instanceof RubyString) {
            File f = new File(((RubyString)target2).asJavaString());
            out = new FileOutputStream(f);
        } else {
            if (!(target2 instanceof RubyOutputStreamWrapper)) throw new IllegalArgumentException("Can't write to a " + target2);
            out = ((RubyOutputStreamWrapper)target2).getOut();
        }
        if (out == null) return null;
        try {
            ((OutputFormatWriter)this.delegate).write(this.output, out);
            return null;
        }
        finally {
            out.close();
        }
    }

    private static void includeModule(RubyClass clazz, String moduleName, String ... moduleNames) {
        RubyModule module = clazz.getRuntime().getModule(moduleName);
        if (moduleNames != null && moduleNames.length > 0) {
            for (String submoduleName : moduleNames) {
                module = module.getModule(submoduleName);
            }
        }
        clazz.includeModule(module);
    }

    private static String getModuleName(Class<?> converterClass) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : converterClass.getPackage().getName().split("\\.")) {
            sb.append(s2.substring(0, 1).toUpperCase()).append(s2.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static class Allocator
    implements ObjectAllocator {
        private final Class<? extends Converter> converterClass;
        private final JRubyAsciidoctor asciidoctor;

        public Allocator(Class<? extends Converter> converterClass, JRubyAsciidoctor asciidoctor) {
            this.converterClass = converterClass;
            this.asciidoctor = asciidoctor;
        }

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass rubyClass) {
            return new ConverterProxy(runtime2, rubyClass, this.converterClass, this.asciidoctor);
        }

        public Class<? extends Converter> getConverterClass() {
            return this.converterClass;
        }
    }
}

