/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.jruby.ast.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.ast.Author;
import org.asciidoctor.ast.Catalog;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.RevisionInfo;
import org.asciidoctor.ast.Title;
import org.asciidoctor.jruby.ast.impl.AuthorImpl;
import org.asciidoctor.jruby.ast.impl.CatalogImpl;
import org.asciidoctor.jruby.ast.impl.RevisionInfoImpl;
import org.asciidoctor.jruby.ast.impl.StructuralNodeImpl;
import org.asciidoctor.jruby.internal.RubyHashMapDecorator;
import org.asciidoctor.jruby.internal.RubyHashUtil;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;

public class DocumentImpl
extends StructuralNodeImpl
implements Document {
    public DocumentImpl(IRubyObject document) {
        super(document);
    }

    @Override
    public String getSource() {
        return this.getString("source", new Object[0]);
    }

    @Override
    public List<String> getSourceLines() {
        return this.getList("source_lines", String.class, new Object[0]);
    }

    @Override
    public boolean isBasebackend(String backend) {
        return this.getBoolean("basebackend?", backend);
    }

    @Override
    public Map<Object, Object> getOptions() {
        return RubyHashUtil.convertRubyHashMapToMap((RubyHash)this.getRubyProperty("options", new Object[0]));
    }

    @Override
    public Title getStructuredDoctitle() {
        Ruby runtime2 = this.getRubyObject().getRuntime();
        RubyHash options2 = RubyHash.newHash(runtime2);
        RubySymbol partitioned = RubySymbol.newSymbol(runtime2, "partition");
        options2.put(partitioned, RubyBoolean.newBoolean(runtime2, true));
        IRubyObject doctitle = this.getRubyProperty("doctitle", options2);
        return this.toJava(doctitle, Title.class);
    }

    @Override
    public String getDoctitle() {
        return this.getString("doctitle", new Object[0]);
    }

    @Override
    public List<Author> getAuthors() {
        return this.getList("authors", RubyStruct.class, new Object[0]).stream().map(AuthorImpl::getInstance).collect(Collectors.toList());
    }

    @Override
    public int getAndIncrementCounter(String name2) {
        return this.getInt("counter", name2);
    }

    @Override
    public int getAndIncrementCounter(String name2, int initialValue) {
        return this.getInt("counter", name2, initialValue);
    }

    @Override
    public boolean isSourcemap() {
        return this.getBoolean("sourcemap", new Object[0]);
    }

    @Override
    public void setSourcemap(boolean state2) {
        this.setBoolean("sourcemap", state2);
    }

    @Override
    public Catalog getCatalog() {
        return new CatalogImpl(new RubyHashMapDecorator((RubyHash)this.getProperty("catalog", new Object[0])));
    }

    @Override
    public RevisionInfo getRevisionInfo() {
        return RevisionInfoImpl.getInstance(this.getAttributes());
    }
}

