/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.UpgradeUtil;
import org.apache.tomcat.websocket.server.UriTemplate;
import org.apache.tomcat.websocket.server.WsFilter;
import org.apache.tomcat.websocket.server.WsMappingResult;
import org.apache.tomcat.websocket.server.WsWriteTimeout;

public class WsServerContainer
extends WsWebSocketContainer
implements ServerContainer {
    private static final StringManager sm = StringManager.getManager(WsServerContainer.class);
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason(CloseReason.CloseCodes.VIOLATED_POLICY, "This connection was established under an authenticated HTTP session that has ended.");
    private final WsWriteTimeout wsWriteTimeout = new WsWriteTimeout();
    private final ServletContext servletContext;
    private final Map<String, ExactPathMatch> configExactMatchMap = new ConcurrentHashMap<String, ExactPathMatch>();
    private final Map<Integer, ConcurrentSkipListMap<String, TemplatePathMatch>> configTemplateMatchMap = new ConcurrentHashMap<Integer, ConcurrentSkipListMap<String, TemplatePathMatch>>();
    private final Map<String, Set<WsSession>> authenticatedSessions = new ConcurrentHashMap<String, Set<WsSession>>();
    private volatile boolean endpointsRegistered = false;
    private volatile boolean deploymentFailed = false;

    WsServerContainer(ServletContext servletContext) {
        FilterRegistration.Dynamic fr;
        this.servletContext = servletContext;
        this.setInstanceManager((InstanceManager)servletContext.getAttribute(InstanceManager.class.getName()));
        String value2 = servletContext.getInitParameter("org.apache.tomcat.websocket.binaryBufferSize");
        if (value2 != null) {
            this.setDefaultMaxBinaryMessageBufferSize(Integer.parseInt(value2));
        }
        if ((value2 = servletContext.getInitParameter("org.apache.tomcat.websocket.textBufferSize")) != null) {
            this.setDefaultMaxTextMessageBufferSize(Integer.parseInt(value2));
        }
        if ((fr = servletContext.addFilter("Tomcat WebSocket (JSR356) Filter", new WsFilter())) != null) {
            fr.setAsyncSupported(true);
            EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD);
            fr.addMappingForUrlPatterns(types, true, "/*");
        }
    }

    @Override
    public void addEndpoint(ServerEndpointConfig sec2) throws DeploymentException {
        this.addEndpoint(sec2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addEndpoint(ServerEndpointConfig sec2, boolean fromAnnotatedPojo) throws DeploymentException {
        if (this.servletContext == null) {
            throw new DeploymentException(sm.getString("serverContainer.servletContextMissing"));
        }
        if (this.deploymentFailed) {
            throw new DeploymentException(sm.getString("serverContainer.failedDeployment", this.servletContext.getContextPath(), this.servletContext.getVirtualServerName()));
        }
        try {
            UriTemplate uriTemplate;
            String path2 = sec2.getPath();
            PojoMethodMapping methodMapping = new PojoMethodMapping(sec2.getEndpointClass(), sec2.getDecoders(), path2, this.getInstanceManager(Thread.currentThread().getContextClassLoader()));
            if (methodMapping.getOnClose() != null || methodMapping.getOnOpen() != null || methodMapping.getOnError() != null || methodMapping.hasMessageHandlers()) {
                sec2.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", methodMapping);
            }
            if ((uriTemplate = new UriTemplate(path2)).hasParameters()) {
                Integer key2 = uriTemplate.getSegmentCount();
                ConcurrentSkipListMap<String, TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key2);
                if (templateMatches == null) {
                    templateMatches = new ConcurrentSkipListMap();
                    this.configTemplateMatchMap.putIfAbsent(key2, templateMatches);
                    templateMatches = this.configTemplateMatchMap.get(key2);
                }
                TemplatePathMatch newMatch = new TemplatePathMatch(sec2, uriTemplate, fromAnnotatedPojo);
                TemplatePathMatch oldMatch = templateMatches.putIfAbsent(uriTemplate.getNormalizedPath(), newMatch);
                if (oldMatch != null) {
                    if (!oldMatch.isFromAnnotatedPojo() || newMatch.isFromAnnotatedPojo() || oldMatch.getConfig().getEndpointClass() != newMatch.getConfig().getEndpointClass()) throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", path2, sec2.getEndpointClass(), sec2.getEndpointClass()));
                    templateMatches.put(path2, oldMatch);
                }
            } else {
                ExactPathMatch newMatch = new ExactPathMatch(sec2, fromAnnotatedPojo);
                ExactPathMatch oldMatch = this.configExactMatchMap.put(path2, newMatch);
                if (oldMatch != null) {
                    if (!oldMatch.isFromAnnotatedPojo() || newMatch.isFromAnnotatedPojo() || oldMatch.getConfig().getEndpointClass() != newMatch.getConfig().getEndpointClass()) throw new DeploymentException(sm.getString("serverContainer.duplicatePaths", path2, oldMatch.getConfig().getEndpointClass(), sec2.getEndpointClass()));
                    this.configExactMatchMap.put(path2, oldMatch);
                }
            }
            this.endpointsRegistered = true;
            return;
        }
        catch (DeploymentException de) {
            this.failDeployment();
            throw de;
        }
    }

    @Override
    public void addEndpoint(Class<?> pojo) throws DeploymentException {
        this.addEndpoint(pojo, false);
    }

    void addEndpoint(Class<?> pojo, boolean fromAnnotatedPojo) throws DeploymentException {
        ServerEndpointConfig sec2;
        if (this.deploymentFailed) {
            throw new DeploymentException(sm.getString("serverContainer.failedDeployment", this.servletContext.getContextPath(), this.servletContext.getVirtualServerName()));
        }
        try {
            ServerEndpoint annotation = pojo.getAnnotation(ServerEndpoint.class);
            if (annotation == null) {
                throw new DeploymentException(sm.getString("serverContainer.missingAnnotation", pojo.getName()));
            }
            String path2 = annotation.value();
            WsServerContainer.validateEncoders(annotation.encoders(), this.getInstanceManager(Thread.currentThread().getContextClassLoader()));
            Class<? extends ServerEndpointConfig.Configurator> configuratorClazz = annotation.configurator();
            ServerEndpointConfig.Configurator configurator = null;
            if (!configuratorClazz.equals(ServerEndpointConfig.Configurator.class)) {
                try {
                    configurator = annotation.configurator().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new DeploymentException(sm.getString("serverContainer.configuratorFail", annotation.configurator().getName(), pojo.getClass().getName()), e);
                }
            }
            sec2 = ServerEndpointConfig.Builder.create(pojo, path2).decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).subprotocols(Arrays.asList(annotation.subprotocols())).configurator(configurator).build();
        }
        catch (DeploymentException de) {
            this.failDeployment();
            throw de;
        }
        this.addEndpoint(sec2, fromAnnotatedPojo);
    }

    void failDeployment() {
        this.deploymentFailed = true;
        this.endpointsRegistered = false;
        this.configExactMatchMap.clear();
        this.configTemplateMatchMap.clear();
    }

    boolean areEndpointsRegistered() {
        return this.endpointsRegistered;
    }

    @Override
    public void upgradeHttpToWebSocket(Object httpServletRequest, Object httpServletResponse, ServerEndpointConfig sec2, Map<String, String> pathParameters) throws IOException, DeploymentException {
        try {
            UpgradeUtil.doUpgrade(this, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, sec2, pathParameters);
        }
        catch (ServletException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    public WsMappingResult findMapping(String path2) {
        ExactPathMatch match2 = this.configExactMatchMap.get(path2);
        if (match2 != null) {
            return new WsMappingResult(match2.getConfig(), Collections.emptyMap());
        }
        UriTemplate pathUriTemplate = null;
        try {
            pathUriTemplate = new UriTemplate(path2);
        }
        catch (DeploymentException e) {
            return null;
        }
        Integer key2 = pathUriTemplate.getSegmentCount();
        ConcurrentSkipListMap<String, TemplatePathMatch> templateMatches = this.configTemplateMatchMap.get(key2);
        if (templateMatches == null) {
            return null;
        }
        ServerEndpointConfig sec2 = null;
        Map<String, String> pathParams = null;
        for (TemplatePathMatch templateMatch : templateMatches.values()) {
            pathParams = templateMatch.getUriTemplate().match(pathUriTemplate);
            if (pathParams == null) continue;
            sec2 = templateMatch.getConfig();
            break;
        }
        if (sec2 == null) {
            return null;
        }
        return new WsMappingResult(sec2, pathParams);
    }

    protected WsWriteTimeout getTimeout() {
        return this.wsWriteTimeout;
    }

    @Override
    protected InstanceManager getInstanceManager(ClassLoader classLoader) {
        return super.getInstanceManager(classLoader);
    }

    @Override
    protected void registerSession(Object key2, WsSession wsSession) {
        super.registerSession(key2, wsSession);
        if (wsSession.isOpen() && wsSession.getUserPrincipal() != null && wsSession.getHttpSessionId() != null) {
            this.registerAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
    }

    @Override
    protected void unregisterSession(Object key2, WsSession wsSession) {
        if (wsSession.getUserPrincipalInternal() != null && wsSession.getHttpSessionId() != null) {
            this.unregisterAuthenticatedSession(wsSession, wsSession.getHttpSessionId());
        }
        super.unregisterSession(key2, wsSession);
    }

    private void registerAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        if (wsSessions == null) {
            wsSessions = ConcurrentHashMap.newKeySet();
            this.authenticatedSessions.putIfAbsent(httpSessionId, wsSessions);
            wsSessions = this.authenticatedSessions.get(httpSessionId);
        }
        wsSessions.add(wsSession);
    }

    private void unregisterAuthenticatedSession(WsSession wsSession, String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.get(httpSessionId);
        if (wsSessions != null) {
            wsSessions.remove(wsSession);
        }
    }

    public void closeAuthenticatedSession(String httpSessionId) {
        Set<WsSession> wsSessions = this.authenticatedSessions.remove(httpSessionId);
        if (wsSessions != null && !wsSessions.isEmpty()) {
            for (WsSession wsSession : wsSessions) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void validateEncoders(Class<? extends Encoder>[] encoders, InstanceManager instanceManager) throws DeploymentException {
        for (Class<? extends Encoder> encoder : encoders) {
            try {
                Encoder instance;
                if (instanceManager == null) {
                    instance = encoder.getConstructor(new Class[0]).newInstance(new Object[0]);
                    continue;
                }
                instance = (Encoder)instanceManager.newInstance(encoder);
                instanceManager.destroyInstance(instance);
            }
            catch (ReflectiveOperationException | NamingException e) {
                throw new DeploymentException(sm.getString("serverContainer.encoderFail", encoder.getName()), e);
            }
        }
    }

    private static class TemplatePathMatch {
        private final ServerEndpointConfig config;
        private final UriTemplate uriTemplate;
        private final boolean fromAnnotatedPojo;

        TemplatePathMatch(ServerEndpointConfig config, UriTemplate uriTemplate, boolean fromAnnotatedPojo) {
            this.config = config;
            this.uriTemplate = uriTemplate;
            this.fromAnnotatedPojo = fromAnnotatedPojo;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public UriTemplate getUriTemplate() {
            return this.uriTemplate;
        }

        public boolean isFromAnnotatedPojo() {
            return this.fromAnnotatedPojo;
        }
    }

    private static class ExactPathMatch {
        private final ServerEndpointConfig config;
        private final boolean fromAnnotatedPojo;

        ExactPathMatch(ServerEndpointConfig config, boolean fromAnnotatedPojo) {
            this.config = config;
            this.fromAnnotatedPojo = fromAnnotatedPojo;
        }

        public ServerEndpointConfig getConfig() {
            return this.config;
        }

        public boolean isFromAnnotatedPojo() {
            return this.fromAnnotatedPojo;
        }
    }
}

