/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.websocket.DeploymentException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.res.StringManager;

public class UriTemplate {
    private static final StringManager sm = StringManager.getManager(UriTemplate.class);
    private final String normalized;
    private final List<Segment> segments = new ArrayList<Segment>();
    private final boolean hasParameters;

    public UriTemplate(String path2) throws DeploymentException {
        if (path2 == null || path2.length() == 0 || !path2.startsWith("/") || path2.contains("/../") || path2.contains("/./") || path2.contains("//")) {
            throw new DeploymentException(sm.getString("uriTemplate.invalidPath", path2));
        }
        StringBuilder normalized = new StringBuilder(path2.length());
        HashSet<String> paramNames = new HashSet<String>();
        String[] segments = path2.split("/", -1);
        int paramCount = 0;
        int segmentCount = 0;
        for (int i2 = 0; i2 < segments.length; ++i2) {
            String segment = segments[i2];
            if (segment.length() == 0) {
                if (i2 == 0 || i2 == segments.length - 1 && paramCount == 0) continue;
                throw new DeploymentException(sm.getString("uriTemplate.emptySegment", path2));
            }
            normalized.append('/');
            int index2 = -1;
            if (segment.startsWith("{") && segment.endsWith("}")) {
                index2 = segmentCount;
                segment = segment.substring(1, segment.length() - 1);
                normalized.append('{');
                normalized.append(paramCount++);
                normalized.append('}');
                if (!paramNames.add(segment)) {
                    throw new DeploymentException(sm.getString("uriTemplate.duplicateParameter", segment));
                }
            } else {
                if (segment.contains("{") || segment.contains("}")) {
                    throw new DeploymentException(sm.getString("uriTemplate.invalidSegment", segment, path2));
                }
                normalized.append(segment);
            }
            this.segments.add(new Segment(index2, segment));
            ++segmentCount;
        }
        this.normalized = normalized.toString();
        this.hasParameters = paramCount > 0;
    }

    public Map<String, String> match(UriTemplate candidate) {
        HashMap<String, String> result2 = new HashMap<String, String>();
        if (candidate.getSegmentCount() != this.getSegmentCount()) {
            return null;
        }
        Iterator<Segment> targetSegments = this.segments.iterator();
        for (Segment candidateSegment : candidate.getSegments()) {
            Segment targetSegment = targetSegments.next();
            if (targetSegment.getParameterIndex() == -1) {
                if (targetSegment.getValue().equals(candidateSegment.getValue())) continue;
                return null;
            }
            result2.put(targetSegment.getValue(), candidateSegment.getValue());
        }
        return result2;
    }

    public boolean hasParameters() {
        return this.hasParameters;
    }

    public int getSegmentCount() {
        return this.segments.size();
    }

    public String getNormalizedPath() {
        return this.normalized;
    }

    private List<Segment> getSegments() {
        return this.segments;
    }

    private static class Segment {
        private final int parameterIndex;
        private final String value;

        Segment(int parameterIndex, String value2) {
            this.parameterIndex = parameterIndex;
            this.value = value2;
        }

        public int getParameterIndex() {
            return this.parameterIndex;
        }

        public String getValue() {
            return this.value;
        }
    }
}

