/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DeploymentException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Util;

public class PojoPathParam {
    private static final StringManager sm = StringManager.getManager(PojoPathParam.class);
    private final Class<?> type;
    private final String name;

    public PojoPathParam(Class<?> type2, String name2) throws DeploymentException {
        if (name2 != null) {
            PojoPathParam.validateType(type2);
        }
        this.type = type2;
        this.name = name2;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    private static void validateType(Class<?> type2) throws DeploymentException {
        if (String.class == type2) {
            return;
        }
        if (Util.isPrimitive(type2)) {
            return;
        }
        throw new DeploymentException(sm.getString("pojoPathParam.wrongType", type2.getName()));
    }
}

