/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import javax.naming.NamingException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;

public class PojoMessageHandlerWholeText
extends PojoMessageHandlerWholeBase<String> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeText.class);
    private final Class<?> primitiveType;

    public PojoMessageHandlerWholeText(Object pojo, Method method2, Session session, EndpointConfig config, List<Class<? extends Decoder>> decoderClazzes, Object[] params2, int indexPayload, boolean convert2, int indexSession, long maxMessageSize) {
        super(pojo, method2, session, params2, indexPayload, convert2, indexSession, maxMessageSize);
        Class<?> type2;
        if (maxMessageSize > -1L && maxMessageSize > (long)session.getMaxTextMessageBufferSize()) {
            if (maxMessageSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxTextMessageBufferSize((int)maxMessageSize);
        }
        if (Util.isPrimitive(type2 = method2.getParameterTypes()[indexPayload])) {
            this.primitiveType = type2;
            return;
        }
        this.primitiveType = null;
        try {
            if (decoderClazzes != null) {
                for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                    Decoder decoder;
                    if (Decoder.Text.class.isAssignableFrom(decoderClazz)) {
                        decoder = (Decoder.Text)this.createDecoderInstance(decoderClazz);
                        decoder.init(config);
                        this.decoders.add(decoder);
                        continue;
                    }
                    if (!Decoder.TextStream.class.isAssignableFrom(decoderClazz)) continue;
                    decoder = (Decoder.TextStream)this.createDecoderInstance(decoderClazz);
                    decoder.init(config);
                    this.decoders.add(decoder);
                }
            }
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected Object decode(String message2) throws DecodeException {
        if (this.primitiveType != null) {
            return Util.coerceToType(this.primitiveType, message2);
        }
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Text) {
                if (!((Decoder.Text)decoder).willDecode(message2)) continue;
                return ((Decoder.Text)decoder).decode(message2);
            }
            StringReader r = new StringReader(message2);
            try {
                return ((Decoder.TextStream)decoder).decode(r);
            }
            catch (IOException ioe) {
                throw new DecodeException(message2, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    protected Object convert(String message2) {
        return new StringReader(message2);
    }
}

