/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.List;
import javax.naming.NamingException;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBase;

public class PojoMessageHandlerWholeBinary
extends PojoMessageHandlerWholeBase<ByteBuffer> {
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBinary.class);
    private final boolean isForInputStream;

    public PojoMessageHandlerWholeBinary(Object pojo, Method method2, Session session, EndpointConfig config, List<Class<? extends Decoder>> decoderClazzes, Object[] params2, int indexPayload, boolean convert2, int indexSession, boolean isForInputStream, long maxMessageSize) {
        super(pojo, method2, session, params2, indexPayload, convert2, indexSession, maxMessageSize);
        if (maxMessageSize > -1L && maxMessageSize > (long)session.getMaxBinaryMessageBufferSize()) {
            if (maxMessageSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(sm.getString("pojoMessageHandlerWhole.maxBufferSize"));
            }
            session.setMaxBinaryMessageBufferSize((int)maxMessageSize);
        }
        try {
            if (decoderClazzes != null) {
                for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                    Decoder decoder;
                    if (Decoder.Binary.class.isAssignableFrom(decoderClazz)) {
                        decoder = (Decoder.Binary)this.createDecoderInstance(decoderClazz);
                        decoder.init(config);
                        this.decoders.add(decoder);
                        continue;
                    }
                    if (!Decoder.BinaryStream.class.isAssignableFrom(decoderClazz)) continue;
                    decoder = (Decoder.BinaryStream)this.createDecoderInstance(decoderClazz);
                    decoder.init(config);
                    this.decoders.add(decoder);
                }
            }
        }
        catch (ReflectiveOperationException | NamingException e) {
            throw new IllegalArgumentException(e);
        }
        this.isForInputStream = isForInputStream;
    }

    @Override
    protected Object decode(ByteBuffer message2) throws DecodeException {
        for (Decoder decoder : this.decoders) {
            if (decoder instanceof Decoder.Binary) {
                if (!((Decoder.Binary)decoder).willDecode(message2)) continue;
                return ((Decoder.Binary)decoder).decode(message2);
            }
            byte[] array2 = new byte[message2.limit() - message2.position()];
            message2.get(array2);
            ByteArrayInputStream bais = new ByteArrayInputStream(array2);
            try {
                return ((Decoder.BinaryStream)decoder).decode(bais);
            }
            catch (IOException ioe) {
                throw new DecodeException(message2, sm.getString("pojoMessageHandlerWhole.decodeIoFail"), (Throwable)ioe);
            }
        }
        return null;
    }

    @Override
    protected Object convert(ByteBuffer message2) {
        byte[] array2 = new byte[message2.remaining()];
        message2.get(array2);
        if (this.isForInputStream) {
            return new ByteArrayInputStream(array2);
        }
        return array2;
    }
}

