/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerBase;

public abstract class PojoMessageHandlerWholeBase<T>
extends PojoMessageHandlerBase<T>
implements MessageHandler.Whole<T> {
    private final Log log = LogFactory.getLog(PojoMessageHandlerWholeBase.class);
    private static final StringManager sm = StringManager.getManager(PojoMessageHandlerWholeBase.class);
    protected final List<Decoder> decoders = new ArrayList<Decoder>();

    public PojoMessageHandlerWholeBase(Object pojo, Method method2, Session session, Object[] params2, int indexPayload, boolean convert2, int indexSession, long maxMessageSize) {
        super(pojo, method2, session, params2, indexPayload, convert2, indexSession, maxMessageSize);
    }

    protected Decoder createDecoderInstance(Class<? extends Decoder> clazz) throws ReflectiveOperationException, NamingException {
        InstanceManager instanceManager = ((WsSession)this.session).getInstanceManager();
        if (instanceManager == null) {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (Decoder)instanceManager.newInstance(clazz);
    }

    @Override
    public final void onMessage(T message2) {
        Object payload;
        if (this.params.length == 1 && this.params[0] instanceof DecodeException) {
            ((WsSession)this.session).getLocal().onError(this.session, (DecodeException)this.params[0]);
            return;
        }
        try {
            payload = this.decode(message2);
        }
        catch (DecodeException de) {
            ((WsSession)this.session).getLocal().onError(this.session, de);
            return;
        }
        if (payload == null) {
            payload = this.convert ? this.convert(message2) : message2;
        }
        Object[] parameters2 = (Object[])this.params.clone();
        if (this.indexSession != -1) {
            parameters2[this.indexSession] = this.session;
        }
        parameters2[this.indexPayload] = payload;
        Object result2 = null;
        try {
            result2 = this.method.invoke(this.pojo, parameters2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.handlePojoMethodException(e);
        }
        this.processResult(result2);
    }

    protected void onClose() {
        InstanceManager instanceManager = ((WsSession)this.session).getInstanceManager();
        for (Decoder decoder : this.decoders) {
            decoder.destroy();
            if (instanceManager == null) continue;
            try {
                instanceManager.destroyInstance(decoder);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.log.warn(sm.getString("pojoMessageHandlerWholeBase.decodeDestoryFailed", decoder.getClass()), e);
            }
        }
    }

    protected Object convert(T message2) {
        return message2;
    }

    protected abstract Object decode(T var1) throws DecodeException;
}

