/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.DecodeException;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerBase;

public abstract class PojoMessageHandlerPartialBase<T>
extends PojoMessageHandlerBase<T>
implements MessageHandler.Partial<T> {
    private final int indexBoolean;

    public PojoMessageHandlerPartialBase(Object pojo, Method method2, Session session, Object[] params2, int indexPayload, boolean convert2, int indexBoolean, int indexSession, long maxMessageSize) {
        super(pojo, method2, session, params2, indexPayload, convert2, indexSession, maxMessageSize);
        this.indexBoolean = indexBoolean;
    }

    @Override
    public final void onMessage(T message2, boolean last2) {
        if (this.params.length == 1 && this.params[0] instanceof DecodeException) {
            ((WsSession)this.session).getLocal().onError(this.session, (DecodeException)this.params[0]);
            return;
        }
        Object[] parameters2 = (Object[])this.params.clone();
        if (this.indexBoolean != -1) {
            parameters2[this.indexBoolean] = last2;
        }
        if (this.indexSession != -1) {
            parameters2[this.indexSession] = this.session;
        }
        parameters2[this.indexPayload] = this.convert ? (Object)((ByteBuffer)message2).array() : message2;
        Object result2 = null;
        try {
            result2 = this.method.invoke(this.pojo, parameters2);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.handlePojoMethodException(e);
        }
        this.processResult(result2);
    }
}

