/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.pojo;

import jakarta.websocket.EncodeException;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.websocket.WrappedMessageHandler;

public abstract class PojoMessageHandlerBase<T>
implements WrappedMessageHandler {
    protected final Object pojo;
    protected final Method method;
    protected final Session session;
    protected final Object[] params;
    protected final int indexPayload;
    protected final boolean convert;
    protected final int indexSession;
    protected final long maxMessageSize;

    public PojoMessageHandlerBase(Object pojo, Method method2, Session session, Object[] params2, int indexPayload, boolean convert2, int indexSession, long maxMessageSize) {
        this.pojo = pojo;
        this.method = method2;
        try {
            this.method.setAccessible(true);
        }
        catch (Exception exception2) {
            // empty catch block
        }
        this.session = session;
        this.params = params2;
        this.indexPayload = indexPayload;
        this.convert = convert2;
        this.indexSession = indexSession;
        this.maxMessageSize = maxMessageSize;
    }

    protected final void processResult(Object result2) {
        if (result2 == null) {
            return;
        }
        RemoteEndpoint.Basic remoteEndpoint = this.session.getBasicRemote();
        try {
            if (result2 instanceof String) {
                remoteEndpoint.sendText((String)result2);
            } else if (result2 instanceof ByteBuffer) {
                remoteEndpoint.sendBinary((ByteBuffer)result2);
            } else if (result2 instanceof byte[]) {
                remoteEndpoint.sendBinary(ByteBuffer.wrap((byte[])result2));
            } else {
                remoteEndpoint.sendObject(result2);
            }
        }
        catch (EncodeException | IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public final MessageHandler getWrappedHandler() {
        if (this.pojo instanceof MessageHandler) {
            return (MessageHandler)this.pojo;
        }
        return null;
    }

    @Override
    public final long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    protected final void handlePojoMethodException(Throwable t) {
        t = ExceptionUtils.unwrapInvocationTargetException(t);
        ExceptionUtils.handleThrowable(t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t.getMessage(), t);
    }
}

