/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.DecoderEntry;
import org.apache.tomcat.websocket.MessageHandlerResult;
import org.apache.tomcat.websocket.MessageHandlerResultType;
import org.apache.tomcat.websocket.WsExtension;
import org.apache.tomcat.websocket.WsExtensionParameter;
import org.apache.tomcat.websocket.WsSession;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerPartialBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeBinary;
import org.apache.tomcat.websocket.pojo.PojoMessageHandlerWholeText;

public class Util {
    private static final StringManager sm = StringManager.getManager(Util.class);
    private static final Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();

    private Util() {
    }

    static boolean isControl(byte opCode) {
        return (opCode & 8) != 0;
    }

    static boolean isText(byte opCode) {
        return opCode == 1;
    }

    static boolean isContinuation(byte opCode) {
        return opCode == 0;
    }

    static CloseReason.CloseCode getCloseCode(int code) {
        if (code > 2999 && code < 5000) {
            return CloseReason.CloseCodes.getCloseCode(code);
        }
        switch (code) {
            case 1000: {
                return CloseReason.CloseCodes.NORMAL_CLOSURE;
            }
            case 1001: {
                return CloseReason.CloseCodes.GOING_AWAY;
            }
            case 1002: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1003: {
                return CloseReason.CloseCodes.CANNOT_ACCEPT;
            }
            case 1004: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1005: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1006: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1007: {
                return CloseReason.CloseCodes.NOT_CONSISTENT;
            }
            case 1008: {
                return CloseReason.CloseCodes.VIOLATED_POLICY;
            }
            case 1009: {
                return CloseReason.CloseCodes.TOO_BIG;
            }
            case 1010: {
                return CloseReason.CloseCodes.NO_EXTENSION;
            }
            case 1011: {
                return CloseReason.CloseCodes.UNEXPECTED_CONDITION;
            }
            case 1012: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1013: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
            case 1015: {
                return CloseReason.CloseCodes.PROTOCOL_ERROR;
            }
        }
        return CloseReason.CloseCodes.PROTOCOL_ERROR;
    }

    static byte[] generateMask() {
        SecureRandom sr = randoms.poll();
        if (sr == null) {
            try {
                sr = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (NoSuchAlgorithmException e) {
                sr = new SecureRandom();
            }
        }
        byte[] result2 = new byte[4];
        sr.nextBytes(result2);
        randoms.add(sr);
        return result2;
    }

    static Class<?> getMessageType(MessageHandler listener) {
        return Util.getGenericType(MessageHandler.class, listener.getClass()).getClazz();
    }

    private static Class<?> getDecoderType(Class<? extends Decoder> decoder) {
        return Util.getGenericType(Decoder.class, decoder).getClazz();
    }

    static Class<?> getEncoderType(Class<? extends Encoder> encoder) {
        return Util.getGenericType(Encoder.class, encoder).getClazz();
    }

    private static <T> TypeResult getGenericType(Class<T> type2, Class<? extends T> clazz) {
        Type[] interfaces2;
        for (Type iface : interfaces2 = clazz.getGenericInterfaces()) {
            ParameterizedType pi;
            if (!(iface instanceof ParameterizedType) || !((pi = (ParameterizedType)iface).getRawType() instanceof Class) || !type2.isAssignableFrom((Class)pi.getRawType())) continue;
            return Util.getTypeParameter(clazz, pi.getActualTypeArguments()[0]);
        }
        Class<? extends T> superClazz = clazz.getSuperclass();
        if (superClazz == null) {
            return null;
        }
        TypeResult superClassTypeResult = Util.getGenericType(type2, superClazz);
        int dimension = superClassTypeResult.getDimension();
        if (superClassTypeResult.getIndex() == -1 && dimension == 0) {
            return superClassTypeResult;
        }
        if (superClassTypeResult.getIndex() > -1) {
            ParameterizedType superClassType = (ParameterizedType)clazz.getGenericSuperclass();
            TypeResult result2 = Util.getTypeParameter(clazz, superClassType.getActualTypeArguments()[superClassTypeResult.getIndex()]);
            result2.incrementDimension(superClassTypeResult.getDimension());
            if (result2.getClazz() != null && result2.getDimension() > 0) {
                superClassTypeResult = result2;
            } else {
                return result2;
            }
        }
        if (superClassTypeResult.getDimension() > 0) {
            Class<?> arrayClazz;
            StringBuilder className = new StringBuilder();
            for (int i2 = 0; i2 < dimension; ++i2) {
                className.append('[');
            }
            className.append('L');
            className.append(superClassTypeResult.getClazz().getCanonicalName());
            className.append(';');
            try {
                arrayClazz = Class.forName(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            return new TypeResult(arrayClazz, -1, 0);
        }
        return null;
    }

    private static TypeResult getTypeParameter(Class<?> clazz, Type argType) {
        if (argType instanceof Class) {
            return new TypeResult((Class)argType, -1, 0);
        }
        if (argType instanceof ParameterizedType) {
            return new TypeResult((Class)((ParameterizedType)argType).getRawType(), -1, 0);
        }
        if (argType instanceof GenericArrayType) {
            Type arrayElementType = ((GenericArrayType)argType).getGenericComponentType();
            TypeResult result2 = Util.getTypeParameter(clazz, arrayElementType);
            result2.incrementDimension(1);
            return result2;
        }
        TypeVariable<Class<?>>[] tvs = clazz.getTypeParameters();
        for (int i2 = 0; i2 < tvs.length; ++i2) {
            if (!tvs[i2].equals(argType)) continue;
            return new TypeResult(null, i2, 0);
        }
        return null;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return clazz.equals(Boolean.class) || clazz.equals(Byte.class) || clazz.equals(Character.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Short.class);
    }

    public static Object coerceToType(Class<?> type2, String value2) {
        if (type2.equals(String.class)) {
            return value2;
        }
        if (type2.equals(Boolean.TYPE) || type2.equals(Boolean.class)) {
            return Boolean.valueOf(value2);
        }
        if (type2.equals(Byte.TYPE) || type2.equals(Byte.class)) {
            return Byte.valueOf(value2);
        }
        if (type2.equals(Character.TYPE) || type2.equals(Character.class)) {
            return Character.valueOf(value2.charAt(0));
        }
        if (type2.equals(Double.TYPE) || type2.equals(Double.class)) {
            return Double.valueOf(value2);
        }
        if (type2.equals(Float.TYPE) || type2.equals(Float.class)) {
            return Float.valueOf(value2);
        }
        if (type2.equals(Integer.TYPE) || type2.equals(Integer.class)) {
            return Integer.valueOf(value2);
        }
        if (type2.equals(Long.TYPE) || type2.equals(Long.class)) {
            return Long.valueOf(value2);
        }
        if (type2.equals(Short.TYPE) || type2.equals(Short.class)) {
            return Short.valueOf(value2);
        }
        throw new IllegalArgumentException(sm.getString("util.invalidType", value2, type2.getName()));
    }

    public static List<DecoderEntry> getDecoders(List<Class<? extends Decoder>> decoderClazzes, InstanceManager instanceManager) throws DeploymentException {
        ArrayList<DecoderEntry> result2 = new ArrayList<DecoderEntry>();
        if (decoderClazzes != null) {
            for (Class<? extends Decoder> decoderClazz : decoderClazzes) {
                try {
                    Decoder instance;
                    if (instanceManager == null) {
                        instance = decoderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    } else {
                        instance = (Decoder)instanceManager.newInstance(decoderClazz);
                        instanceManager.destroyInstance(instance);
                    }
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException | NamingException e) {
                    throw new DeploymentException(sm.getString("pojoMethodMapping.invalidDecoder", decoderClazz.getName()), e);
                }
                DecoderEntry entry = new DecoderEntry(Util.getDecoderType(decoderClazz), decoderClazz);
                result2.add(entry);
            }
        }
        return result2;
    }

    static Set<MessageHandlerResult> getMessageHandlers(Class<?> target2, MessageHandler listener, EndpointConfig endpointConfig, Session session) {
        HashSet<MessageHandlerResult> results = new HashSet<MessageHandlerResult>(2);
        if (String.class.isAssignableFrom(target2)) {
            MessageHandlerResult result2 = new MessageHandlerResult(listener, MessageHandlerResultType.TEXT);
            results.add(result2);
        } else if (ByteBuffer.class.isAssignableFrom(target2)) {
            MessageHandlerResult result3 = new MessageHandlerResult(listener, MessageHandlerResultType.BINARY);
            results.add(result3);
        } else if (PongMessage.class.isAssignableFrom(target2)) {
            MessageHandlerResult result4 = new MessageHandlerResult(listener, MessageHandlerResultType.PONG);
            results.add(result4);
        } else if (byte[].class.isAssignableFrom(target2)) {
            boolean whole = MessageHandler.Whole.class.isAssignableFrom(listener.getClass());
            MessageHandlerResult result5 = new MessageHandlerResult((MessageHandler)((Object)(whole ? new PojoMessageHandlerWholeBinary(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target2, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, false, -1L) : new PojoMessageHandlerPartialBinary(listener, Util.getOnMessagePartialMethod(listener), session, new Object[2], 0, true, 1, -1, -1L))), MessageHandlerResultType.BINARY);
            results.add(result5);
        } else if (InputStream.class.isAssignableFrom(target2)) {
            MessageHandlerResult result6 = new MessageHandlerResult(new PojoMessageHandlerWholeBinary(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target2, endpointConfig, true, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, true, -1L), MessageHandlerResultType.BINARY);
            results.add(result6);
        } else if (Reader.class.isAssignableFrom(target2)) {
            MessageHandlerResult result7 = new MessageHandlerResult(new PojoMessageHandlerWholeText(listener, Util.getOnMessageMethod(listener), session, endpointConfig, Util.matchDecoders(target2, endpointConfig, false, ((WsSession)session).getInstanceManager()), new Object[1], 0, true, -1, -1L), MessageHandlerResultType.TEXT);
            results.add(result7);
        } else {
            MessageHandlerResult result8;
            DecoderMatch decoderMatch = Util.matchDecoders(target2, endpointConfig, ((WsSession)session).getInstanceManager());
            Method m = Util.getOnMessageMethod(listener);
            if (decoderMatch.getBinaryDecoders().size() > 0) {
                result8 = new MessageHandlerResult(new PojoMessageHandlerWholeBinary(listener, m, session, endpointConfig, decoderMatch.getBinaryDecoders(), new Object[1], 0, false, -1, false, -1L), MessageHandlerResultType.BINARY);
                results.add(result8);
            }
            if (decoderMatch.getTextDecoders().size() > 0) {
                result8 = new MessageHandlerResult(new PojoMessageHandlerWholeText(listener, m, session, endpointConfig, decoderMatch.getTextDecoders(), new Object[1], 0, false, -1, -1L), MessageHandlerResultType.TEXT);
                results.add(result8);
            }
        }
        if (results.size() == 0) {
            throw new IllegalArgumentException(sm.getString("wsSession.unknownHandler", listener, target2));
        }
        return results;
    }

    private static List<Class<? extends Decoder>> matchDecoders(Class<?> target2, EndpointConfig endpointConfig, boolean binary, InstanceManager instanceManager) {
        DecoderMatch decoderMatch = Util.matchDecoders(target2, endpointConfig, instanceManager);
        if (binary) {
            if (decoderMatch.getBinaryDecoders().size() > 0) {
                return decoderMatch.getBinaryDecoders();
            }
        } else if (decoderMatch.getTextDecoders().size() > 0) {
            return decoderMatch.getTextDecoders();
        }
        return null;
    }

    private static DecoderMatch matchDecoders(Class<?> target2, EndpointConfig endpointConfig, InstanceManager instanceManager) {
        DecoderMatch decoderMatch;
        try {
            List<Class<? extends Decoder>> decoders = endpointConfig.getDecoders();
            List<DecoderEntry> decoderEntries = Util.getDecoders(decoders, instanceManager);
            decoderMatch = new DecoderMatch(target2, decoderEntries);
        }
        catch (DeploymentException e) {
            throw new IllegalArgumentException(e);
        }
        return decoderMatch;
    }

    public static void parseExtensionHeader(List<Extension> extensions, String header) {
        String[] unparsedExtensions;
        for (String unparsedExtension : unparsedExtensions = header.split(",")) {
            String[] unparsedParameters = unparsedExtension.split(";");
            WsExtension extension = new WsExtension(unparsedParameters[0].trim());
            for (int i2 = 1; i2 < unparsedParameters.length; ++i2) {
                String value2;
                String name2;
                int equalsPos = unparsedParameters[i2].indexOf(61);
                if (equalsPos == -1) {
                    name2 = unparsedParameters[i2].trim();
                    value2 = null;
                } else {
                    name2 = unparsedParameters[i2].substring(0, equalsPos).trim();
                    value2 = unparsedParameters[i2].substring(equalsPos + 1).trim();
                    int len = value2.length();
                    if (len > 1 && value2.charAt(0) == '\"' && value2.charAt(len - 1) == '\"') {
                        value2 = value2.substring(1, value2.length() - 1);
                    }
                }
                if (Util.containsDelims(name2) || Util.containsDelims(value2)) {
                    throw new IllegalArgumentException(sm.getString("util.notToken", name2, value2));
                }
                if (value2 != null && (value2.indexOf(44) > -1 || value2.indexOf(59) > -1 || value2.indexOf(34) > -1 || value2.indexOf(61) > -1)) {
                    throw new IllegalArgumentException(sm.getString("util.invalidValue", value2));
                }
                extension.addParameter(new WsExtensionParameter(name2, value2));
            }
            extensions.add(extension);
        }
    }

    private static boolean containsDelims(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        for (char c : input.toCharArray()) {
            switch (c) {
                case '\"': 
                case ',': 
                case ';': 
                case '=': {
                    return true;
                }
            }
        }
        return false;
    }

    private static Method getOnMessageMethod(MessageHandler listener) {
        try {
            return listener.getClass().getMethod("onMessage", Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), e);
        }
    }

    private static Method getOnMessagePartialMethod(MessageHandler listener) {
        try {
            return listener.getClass().getMethod("onMessage", Object.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(sm.getString("util.invalidMessageHandler"), e);
        }
    }

    private static class TypeResult {
        private final Class<?> clazz;
        private final int index;
        private int dimension;

        TypeResult(Class<?> clazz, int index2, int dimension) {
            this.clazz = clazz;
            this.index = index2;
            this.dimension = dimension;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public int getIndex() {
            return this.index;
        }

        public int getDimension() {
            return this.dimension;
        }

        public void incrementDimension(int inc) {
            this.dimension += inc;
        }
    }

    public static class DecoderMatch {
        private final List<Class<? extends Decoder>> textDecoders = new ArrayList<Class<? extends Decoder>>();
        private final List<Class<? extends Decoder>> binaryDecoders = new ArrayList<Class<? extends Decoder>>();
        private final Class<?> target;

        public DecoderMatch(Class<?> target2, List<DecoderEntry> decoderEntries) {
            this.target = target2;
            for (DecoderEntry decoderEntry : decoderEntries) {
                if (!decoderEntry.getClazz().isAssignableFrom(target2)) continue;
                if (Decoder.Binary.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.getDecoderClazz());
                    continue;
                }
                if (Decoder.BinaryStream.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.binaryDecoders.add(decoderEntry.getDecoderClazz());
                    break;
                }
                if (Decoder.Text.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.textDecoders.add(decoderEntry.getDecoderClazz());
                    continue;
                }
                if (Decoder.TextStream.class.isAssignableFrom(decoderEntry.getDecoderClazz())) {
                    this.textDecoders.add(decoderEntry.getDecoderClazz());
                    break;
                }
                throw new IllegalArgumentException(sm.getString("util.unknownDecoderType"));
            }
        }

        public List<Class<? extends Decoder>> getTextDecoders() {
            return this.textDecoders;
        }

        public List<Class<? extends Decoder>> getBinaryDecoders() {
            return this.binaryDecoders;
        }

        public Class<?> getTarget() {
            return this.target;
        }

        public boolean hasMatches() {
            return this.textDecoders.size() > 0 || this.binaryDecoders.size() > 0;
        }
    }
}

