/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.StopPooledThreadException;

public class TaskThread
extends Thread {
    private static final Log log = LogFactory.getLog(TaskThread.class);
    private static final StringManager sm = StringManager.getManager(TaskThread.class);
    private final long creationTime = System.currentTimeMillis();

    public TaskThread(ThreadGroup group2, Runnable target2, String name2) {
        super(group2, new WrappingRunnable(target2), name2);
    }

    public TaskThread(ThreadGroup group2, Runnable target2, String name2, long stackSize) {
        super(group2, new WrappingRunnable(target2), name2, stackSize);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private static class WrappingRunnable
    implements Runnable {
        private Runnable wrappedRunnable;

        WrappingRunnable(Runnable wrappedRunnable) {
            this.wrappedRunnable = wrappedRunnable;
        }

        @Override
        public void run() {
            try {
                this.wrappedRunnable.run();
            }
            catch (StopPooledThreadException exc) {
                log.debug(sm.getString("taskThread.exiting"), exc);
            }
        }
    }
}

