/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.scan.JarFactory;

public class ReferenceCountedJar
implements Jar {
    private final URL url;
    private Jar wrappedJar;
    private int referenceCount = 0;

    public ReferenceCountedJar(URL url) throws IOException {
        this.url = url;
        this.open();
    }

    private synchronized ReferenceCountedJar open() throws IOException {
        if (this.wrappedJar == null) {
            this.wrappedJar = JarFactory.newInstance(this.url);
        }
        ++this.referenceCount;
        return this;
    }

    @Override
    public synchronized void close() {
        --this.referenceCount;
        if (this.referenceCount == 0) {
            this.wrappedJar.close();
            this.wrappedJar = null;
        }
    }

    @Override
    public URL getJarFileURL() {
        return this.url;
    }

    @Override
    public InputStream getInputStream(String name2) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            InputStream inputStream = jar.wrappedJar.getInputStream(name2);
            return inputStream;
        }
    }

    @Override
    public long getLastModified(String name2) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            long l = jar.wrappedJar.getLastModified(name2);
            return l;
        }
    }

    @Override
    public boolean exists(String name2) throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            boolean bl = jar.wrappedJar.exists(name2);
            return bl;
        }
    }

    @Override
    public void nextEntry() {
        try (ReferenceCountedJar jar = this.open();){
            jar.wrappedJar.nextEntry();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    @Override
    public String getEntryName() {
        ReferenceCountedJar jar = this.open();
        try {
            String string2 = jar.wrappedJar.getEntryName();
            if (jar != null) {
                jar.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            InputStream inputStream = jar.wrappedJar.getEntryInputStream();
            return inputStream;
        }
    }

    @Override
    public String getURL(String entry) {
        ReferenceCountedJar jar = this.open();
        try {
            String string2 = jar.wrappedJar.getURL(entry);
            if (jar != null) {
                jar.close();
            }
            return string2;
        }
        catch (Throwable throwable) {
            try {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
    }

    @Override
    public Manifest getManifest() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            Manifest manifest = jar.wrappedJar.getManifest();
            return manifest;
        }
    }

    @Override
    public void reset() throws IOException {
        try (ReferenceCountedJar jar = this.open();){
            jar.wrappedJar.reset();
        }
    }
}

