/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Cleaner;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.CertificateVerifier;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.OpenSSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.net.openssl.OpenSSLEngine;
import org.apache.tomcat.util.net.openssl.OpenSSLSessionContext;
import org.apache.tomcat.util.net.openssl.OpenSSLUtil;
import org.apache.tomcat.util.net.openssl.OpenSSLX509Certificate;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLContext
implements SSLContext {
    private static final Log log = LogFactory.getLog(OpenSSLContext.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLContext.class);
    private static final String defaultProtocol = "TLS";
    private static final String BEGIN_KEY = "-----BEGIN PRIVATE KEY-----\n";
    private static final Object END_KEY = "\n-----END PRIVATE KEY-----";
    static final CertificateFactory X509_CERT_FACTORY;
    private static final Cleaner cleaner;
    private final SSLHostConfig sslHostConfig;
    private final SSLHostConfigCertificate certificate;
    private final List<String> negotiableProtocols;
    private OpenSSLSessionContext sessionContext;
    private X509TrustManager x509TrustManager;
    private String enabledProtocol;
    private boolean initialized = false;
    private final OpenSSLState state;
    private final Cleaner.Cleanable cleanable;

    public OpenSSLContext(SSLHostConfigCertificate certificate, List<String> negotiableProtocols) throws SSLException {
        this.sslHostConfig = certificate.getSSLHostConfig();
        this.certificate = certificate;
        long aprPool = Pool.create(0L);
        long cctx = 0L;
        long ctx = 0L;
        boolean success = false;
        try {
            OpenSSLConf openSslConf = this.sslHostConfig.getOpenSslConf();
            if (openSslConf != null) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace(sm.getString("openssl.makeConf"));
                    }
                    cctx = SSLConf.make(aprPool, 58);
                }
                catch (Exception e) {
                    throw new SSLException(sm.getString("openssl.errMakeConf"), e);
                }
            }
            this.sslHostConfig.setOpenSslConfContext(cctx);
            int value2 = 0;
            for (String protocol2 : this.sslHostConfig.getEnabledProtocols()) {
                if ("SSLv2Hello".equalsIgnoreCase(protocol2)) continue;
                if ("SSLv2".equalsIgnoreCase(protocol2)) {
                    value2 |= 1;
                    continue;
                }
                if ("SSLv3".equalsIgnoreCase(protocol2)) {
                    value2 |= 2;
                    continue;
                }
                if ("TLSv1".equalsIgnoreCase(protocol2)) {
                    value2 |= 4;
                    continue;
                }
                if ("TLSv1.1".equalsIgnoreCase(protocol2)) {
                    value2 |= 8;
                    continue;
                }
                if ("TLSv1.2".equalsIgnoreCase(protocol2)) {
                    value2 |= 0x10;
                    continue;
                }
                if ("TLSv1.3".equalsIgnoreCase(protocol2)) {
                    value2 |= 0x20;
                    continue;
                }
                if ("all".equalsIgnoreCase(protocol2)) {
                    value2 |= SSL.SSL_PROTOCOL_ALL;
                    continue;
                }
                throw new Exception(sm.getString("openssl.invalidSslProtocol", protocol2));
            }
            try {
                ctx = org.apache.tomcat.jni.SSLContext.make(aprPool, value2, 1);
            }
            catch (Exception e) {
                throw new Exception(sm.getString("openssl.failSslContextMake"), e);
            }
            this.negotiableProtocols = negotiableProtocols;
            success = true;
        }
        catch (Exception e) {
            throw new SSLException(sm.getString("openssl.errorSSLCtxInit"), e);
        }
        finally {
            this.state = new OpenSSLState(aprPool, cctx, ctx);
            this.cleanable = cleaner.register(this, this.state);
            if (!success) {
                this.destroy();
            }
        }
    }

    public String getEnabledProtocol() {
        return this.enabledProtocol;
    }

    public void setEnabledProtocol(String protocol2) {
        this.enabledProtocol = protocol2 == null ? defaultProtocol : protocol2;
    }

    @Override
    public void destroy() {
        this.cleanable.clean();
    }

    protected static boolean checkConf(OpenSSLConf conf, long cctx) throws Exception {
        boolean result2 = true;
        Iterator<OpenSSLConfCmd> iterator = conf.getCommands().iterator();
        while (iterator.hasNext()) {
            int rc;
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name2 = cmd.getName();
            String value2 = cmd.getValue();
            if (name2 == null) {
                log.error(sm.getString("opensslconf.noCommandName", value2));
                result2 = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace(sm.getString("opensslconf.checkCommand", name2, value2));
            }
            try {
                rc = SSLConf.check(cctx, name2, value2);
            }
            catch (Exception e) {
                log.error(sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error(sm.getString("opensslconf.failedCommand", name2, value2, Integer.toString(rc)));
                result2 = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace(sm.getString("opensslconf.resultCommand", name2, value2, Integer.toString(rc)));
        }
        if (!result2) {
            log.error(sm.getString("opensslconf.checkFailed"));
        }
        return result2;
    }

    protected static boolean applyConf(OpenSSLConf conf, long cctx, long ctx) throws Exception {
        int rc;
        boolean result2 = true;
        SSLConf.assign(cctx, ctx);
        Iterator<OpenSSLConfCmd> iterator = conf.getCommands().iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd command;
            OpenSSLConfCmd cmd = command = iterator.next();
            String name2 = cmd.getName();
            String value2 = cmd.getValue();
            if (name2 == null) {
                log.error(sm.getString("opensslconf.noCommandName", value2));
                result2 = false;
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace(sm.getString("opensslconf.applyCommand", name2, value2));
            }
            try {
                rc = SSLConf.apply(cctx, name2, value2);
            }
            catch (Exception e) {
                log.error(sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (rc <= 0) {
                log.error(sm.getString("opensslconf.failedCommand", name2, value2, Integer.toString(rc)));
                result2 = false;
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace(sm.getString("opensslconf.resultCommand", name2, value2, Integer.toString(rc)));
        }
        rc = SSLConf.finish(cctx);
        if (rc <= 0) {
            log.error(sm.getString("opensslconf.finishFailed", Integer.toString(rc)));
            result2 = false;
        }
        if (!result2) {
            log.error(sm.getString("opensslconf.applyFailed"));
        }
        return result2;
    }

    @Override
    public void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) {
        if (this.initialized) {
            log.warn(sm.getString("openssl.doubleInit"));
            return;
        }
        try {
            OpenSSLConf openSslConf;
            if (this.sslHostConfig.getInsecureRenegotiation()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.state.ctx, 262144);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.state.ctx, 262144);
            }
            if (this.sslHostConfig.getHonorCipherOrder()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.state.ctx, 0x400000);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.state.ctx, 0x400000);
            }
            if (this.sslHostConfig.getDisableCompression()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.state.ctx, 131072);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.state.ctx, 131072);
            }
            if (this.sslHostConfig.getDisableSessionTickets()) {
                org.apache.tomcat.jni.SSLContext.setOptions(this.state.ctx, 16384);
            } else {
                org.apache.tomcat.jni.SSLContext.clearOptions(this.state.ctx, 16384);
            }
            org.apache.tomcat.jni.SSLContext.setCipherSuite(this.state.ctx, this.sslHostConfig.getCiphers());
            this.certificate.setCertificateKeyManager(OpenSSLUtil.chooseKeyManager(kms, this.certificate.getCertificateFile() == null));
            this.addCertificate(this.certificate);
            int value2 = 0;
            switch (this.sslHostConfig.getCertificateVerification()) {
                case NONE: {
                    value2 = 0;
                    break;
                }
                case OPTIONAL: {
                    value2 = 1;
                    break;
                }
                case OPTIONAL_NO_CA: {
                    value2 = 3;
                    break;
                }
                case REQUIRED: {
                    value2 = 2;
                }
            }
            org.apache.tomcat.jni.SSLContext.setVerify(this.state.ctx, value2, this.sslHostConfig.getCertificateVerificationDepth());
            if (tms != null) {
                this.x509TrustManager = OpenSSLContext.chooseTrustManager(tms);
                org.apache.tomcat.jni.SSLContext.setCertVerifyCallback(this.state.ctx, new CertificateVerifier(){

                    @Override
                    public boolean verify(long ssl, byte[][] chain2, String auth) {
                        X509Certificate[] peerCerts = OpenSSLContext.certificates(chain2);
                        try {
                            OpenSSLContext.this.x509TrustManager.checkClientTrusted(peerCerts, auth);
                            return true;
                        }
                        catch (Exception e) {
                            log.debug(sm.getString("openssl.certificateVerificationFailed"), e);
                            return false;
                        }
                    }
                });
                for (X509Certificate caCert : this.x509TrustManager.getAcceptedIssuers()) {
                    org.apache.tomcat.jni.SSLContext.addClientCACertificateRaw(this.state.ctx, caCert.getEncoded());
                    if (!log.isDebugEnabled()) continue;
                    log.debug(sm.getString("openssl.addedClientCaCert", caCert.toString()));
                }
            } else {
                org.apache.tomcat.jni.SSLContext.setCACertificate(this.state.ctx, SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificateFile()), SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCaCertificatePath()));
            }
            if (this.negotiableProtocols != null && this.negotiableProtocols.size() > 0) {
                ArrayList<String> protocols = new ArrayList<String>(this.negotiableProtocols);
                protocols.add("http/1.1");
                String[] protocolsArray = protocols.toArray(new String[0]);
                org.apache.tomcat.jni.SSLContext.setAlpnProtos(this.state.ctx, protocolsArray, 0);
            }
            if ((openSslConf = this.sslHostConfig.getOpenSslConf()) != null && this.state.cctx != 0L) {
                if (log.isTraceEnabled()) {
                    log.trace(sm.getString("openssl.checkConf"));
                }
                try {
                    if (!OpenSSLContext.checkConf(openSslConf, this.state.cctx)) {
                        log.error(sm.getString("openssl.errCheckConf"));
                        throw new Exception(sm.getString("openssl.errCheckConf"));
                    }
                }
                catch (Exception e) {
                    throw new Exception(sm.getString("openssl.errCheckConf"), e);
                }
                if (log.isTraceEnabled()) {
                    log.trace(sm.getString("openssl.applyConf"));
                }
                try {
                    if (!OpenSSLContext.applyConf(openSslConf, this.state.cctx, this.state.ctx)) {
                        log.error(sm.getString("openssl.errApplyConf"));
                        throw new SSLException(sm.getString("openssl.errApplyConf"));
                    }
                }
                catch (Exception e) {
                    throw new SSLException(sm.getString("openssl.errApplyConf"), e);
                }
                int opts = org.apache.tomcat.jni.SSLContext.getOptions(this.state.ctx);
                ArrayList<String> enabled = new ArrayList<String>();
                enabled.add("SSLv2Hello");
                if ((opts & 0x4000000) == 0) {
                    enabled.add("TLSv1");
                }
                if ((opts & 0x10000000) == 0) {
                    enabled.add("TLSv1.1");
                }
                if ((opts & 0x8000000) == 0) {
                    enabled.add("TLSv1.2");
                }
                if ((opts & 0x1000000) == 0) {
                    enabled.add("SSLv2");
                }
                if ((opts & 0x2000000) == 0) {
                    enabled.add("SSLv3");
                }
                this.sslHostConfig.setEnabledProtocols(enabled.toArray(new String[0]));
                this.sslHostConfig.setEnabledCiphers(org.apache.tomcat.jni.SSLContext.getCiphers(this.state.ctx));
            }
            this.sessionContext = new OpenSSLSessionContext(this);
            this.sessionContext.setSessionIdContext(org.apache.tomcat.jni.SSLContext.DEFAULT_SESSION_ID_CONTEXT);
            this.sslHostConfig.setOpenSslContext(this.state.ctx);
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn(sm.getString("openssl.errorSSLCtxInit"), e);
            this.destroy();
        }
    }

    public void addCertificate(SSLHostConfigCertificate certificate) throws Exception {
        if (certificate.getCertificateFile() != null) {
            String passwordToUse = null;
            if (certificate.getCertificateKeyPasswordFile() != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(SSLHostConfig.adjustRelativePath(certificate.getCertificateKeyPasswordFile())), StandardCharsets.UTF_8));){
                    passwordToUse = reader.readLine();
                }
            } else {
                passwordToUse = certificate.getCertificateKeyPassword();
            }
            org.apache.tomcat.jni.SSLContext.setCertificate(this.state.ctx, SSLHostConfig.adjustRelativePath(certificate.getCertificateFile()), SSLHostConfig.adjustRelativePath(certificate.getCertificateKeyFile()), passwordToUse, OpenSSLContext.getCertificateIndex(certificate));
            org.apache.tomcat.jni.SSLContext.setCertificateChainFile(this.state.ctx, SSLHostConfig.adjustRelativePath(certificate.getCertificateChainFile()), false);
            org.apache.tomcat.jni.SSLContext.setCARevocation(this.state.ctx, SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListFile()), SSLHostConfig.adjustRelativePath(this.sslHostConfig.getCertificateRevocationListPath()));
        } else {
            X509Certificate[] chain2;
            String alias = certificate.getCertificateKeyAlias();
            X509KeyManager x509KeyManager = certificate.getCertificateKeyManager();
            if (alias == null) {
                alias = "tomcat";
            }
            if ((chain2 = x509KeyManager.getCertificateChain(alias)) == null) {
                alias = OpenSSLContext.findAlias(x509KeyManager, certificate);
                chain2 = x509KeyManager.getCertificateChain(alias);
            }
            PrivateKey key2 = x509KeyManager.getPrivateKey(alias);
            StringBuilder sb = new StringBuilder(BEGIN_KEY);
            sb.append(Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(key2.getEncoded()));
            sb.append(END_KEY);
            org.apache.tomcat.jni.SSLContext.setCertificateRaw(this.state.ctx, chain2[0].getEncoded(), sb.toString().getBytes(StandardCharsets.US_ASCII), OpenSSLContext.getCertificateIndex(certificate));
            for (int i2 = 1; i2 < chain2.length; ++i2) {
                org.apache.tomcat.jni.SSLContext.addChainCertificateRaw(this.state.ctx, chain2[i2].getEncoded());
            }
        }
    }

    private static int getCertificateIndex(SSLHostConfigCertificate certificate) {
        int result2 = certificate.getType() == SSLHostConfigCertificate.Type.RSA || certificate.getType() == SSLHostConfigCertificate.Type.UNDEFINED ? 0 : (certificate.getType() == SSLHostConfigCertificate.Type.EC ? 3 : (certificate.getType() == SSLHostConfigCertificate.Type.DSA ? 1 : 4));
        return result2;
    }

    private static String findAlias(X509KeyManager keyManager, SSLHostConfigCertificate certificate) {
        SSLHostConfigCertificate.Type type2 = certificate.getType();
        String result2 = null;
        ArrayList<SSLHostConfigCertificate.Type> candidateTypes = new ArrayList<SSLHostConfigCertificate.Type>();
        if (SSLHostConfigCertificate.Type.UNDEFINED.equals((Object)type2)) {
            candidateTypes.addAll(Arrays.asList(SSLHostConfigCertificate.Type.values()));
            candidateTypes.remove((Object)SSLHostConfigCertificate.Type.UNDEFINED);
        } else {
            candidateTypes.add(type2);
        }
        Iterator iter = candidateTypes.iterator();
        while (result2 == null && iter.hasNext()) {
            result2 = keyManager.chooseServerAlias(((SSLHostConfigCertificate.Type)((Object)iter.next())).toString(), null, null);
        }
        return result2;
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(sm.getString("openssl.trustManagerMissing"));
    }

    private static X509Certificate[] certificates(byte[][] chain2) {
        X509Certificate[] peerCerts = new X509Certificate[chain2.length];
        for (int i2 = 0; i2 < peerCerts.length; ++i2) {
            peerCerts[i2] = new OpenSSLX509Certificate(chain2[i2]);
        }
        return peerCerts;
    }

    long getSSLContextID() {
        return this.state.ctx;
    }

    @Override
    public SSLSessionContext getServerSessionContext() {
        return this.sessionContext;
    }

    @Override
    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(cleaner, this.state.ctx, defaultProtocol, false, this.sessionContext, this.negotiableProtocols != null && this.negotiableProtocols.size() > 0, this.initialized, this.sslHostConfig.getCertificateVerificationDepth(), this.sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.OPTIONAL_NO_CA);
    }

    @Override
    public SSLServerSocketFactory getServerSocketFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SSLParameters getSupportedSSLParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain2 = null;
        X509KeyManager x509KeyManager = this.certificate.getCertificateKeyManager();
        if (x509KeyManager != null) {
            if (alias == null) {
                alias = "tomcat";
            }
            if ((chain2 = x509KeyManager.getCertificateChain(alias)) == null) {
                alias = OpenSSLContext.findAlias(x509KeyManager, this.certificate);
                chain2 = x509KeyManager.getCertificateChain(alias);
            }
        }
        return chain2;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] acceptedCerts = null;
        if (this.x509TrustManager != null) {
            acceptedCerts = this.x509TrustManager.getAcceptedIssuers();
        }
        return acceptedCerts;
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(sm.getString("openssl.X509FactoryError"), e);
        }
        cleaner = Cleaner.create();
    }

    private static class OpenSSLState
    implements Runnable {
        final long aprPool;
        final long cctx;
        final long ctx;

        private OpenSSLState(long aprPool, long cctx, long ctx) {
            this.aprPool = aprPool;
            this.cctx = cctx;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (this.ctx != 0L) {
                org.apache.tomcat.jni.SSLContext.free(this.ctx);
            }
            if (this.cctx != 0L) {
                SSLConf.free(this.cctx);
            }
            if (this.aprPool != 0L) {
                Pool.destroy(this.aprPool);
            }
        }
    }
}

