/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.tomcat.util.buf.ByteBufferHolder;
import org.apache.tomcat.util.net.SocketWrapperBase;

public class WriteBuffer {
    private final int bufferSize;
    private final LinkedBlockingDeque<ByteBufferHolder> buffers = new LinkedBlockingDeque();

    public WriteBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    void clear() {
        this.buffers.clear();
    }

    void add(byte[] buf, int offset2, int length2) {
        ByteBufferHolder holder = this.getByteBufferHolder(length2);
        holder.getBuf().put(buf, offset2, length2);
    }

    public void add(ByteBuffer from) {
        ByteBufferHolder holder = this.getByteBufferHolder(from.remaining());
        holder.getBuf().put(from);
    }

    private ByteBufferHolder getByteBufferHolder(int capacity) {
        ByteBufferHolder holder = this.buffers.peekLast();
        if (holder == null || holder.isFlipped() || holder.getBuf().remaining() < capacity) {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferSize, capacity));
            holder = new ByteBufferHolder(buffer, false);
            this.buffers.add(holder);
        }
        return holder;
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    ByteBuffer[] toArray(ByteBuffer ... prefixes) {
        ArrayList<ByteBuffer> result2 = new ArrayList<ByteBuffer>();
        for (ByteBuffer prefix : prefixes) {
            if (!prefix.hasRemaining()) continue;
            result2.add(prefix);
        }
        for (ByteBufferHolder buffer : this.buffers) {
            buffer.flip();
            result2.add(buffer.getBuf());
        }
        this.buffers.clear();
        return result2.toArray(new ByteBuffer[0]);
    }

    boolean write(SocketWrapperBase<?> socketWrapper, boolean blocking2) throws IOException {
        Iterator<ByteBufferHolder> bufIter = this.buffers.iterator();
        boolean dataLeft = false;
        while (!dataLeft && bufIter.hasNext()) {
            ByteBufferHolder buffer = bufIter.next();
            buffer.flip();
            if (blocking2) {
                socketWrapper.writeBlocking(buffer.getBuf());
            } else {
                socketWrapper.writeNonBlockingInternal(buffer.getBuf());
            }
            if (buffer.getBuf().remaining() == 0) {
                bufIter.remove();
                continue;
            }
            dataLeft = true;
        }
        return dataLeft;
    }

    public boolean write(Sink sink, boolean blocking2) throws IOException {
        Iterator<ByteBufferHolder> bufIter = this.buffers.iterator();
        boolean dataLeft = false;
        while (!dataLeft && bufIter.hasNext()) {
            ByteBufferHolder buffer = bufIter.next();
            buffer.flip();
            dataLeft = sink.writeFromBuffer(buffer.getBuf(), blocking2);
            if (dataLeft) continue;
            bufIter.remove();
        }
        return dataLeft;
    }

    public static interface Sink {
        public boolean writeFromBuffer(ByteBuffer var1, boolean var2) throws IOException;
    }
}

