/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;

public abstract class SocketProcessorBase<S>
implements Runnable {
    protected SocketWrapperBase<S> socketWrapper;
    protected SocketEvent event;

    public SocketProcessorBase(SocketWrapperBase<S> socketWrapper, SocketEvent event2) {
        this.reset(socketWrapper, event2);
    }

    public void reset(SocketWrapperBase<S> socketWrapper, SocketEvent event2) {
        Objects.requireNonNull(event2);
        this.socketWrapper = socketWrapper;
        this.event = event2;
    }

    @Override
    public final void run() {
        Lock lock2 = this.socketWrapper.getLock();
        lock2.lock();
        try {
            if (this.socketWrapper.isClosed()) {
                return;
            }
            this.doRun();
        }
        finally {
            lock2.unlock();
        }
    }

    protected abstract void doRun();
}

