/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class MbeansDescriptorsIntrospectionSource
extends ModelerSource {
    private static final Log log = LogFactory.getLog(MbeansDescriptorsIntrospectionSource.class);
    private static final StringManager sm = StringManager.getManager(MbeansDescriptorsIntrospectionSource.class);
    private Registry registry;
    private String type;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private static final Map<String, String> specialMethods = new HashMap<String, String>();
    private static final Class<?>[] supportedTypes;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setSource(Object source2) {
        this.source = source2;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String type2, Object source2) throws Exception {
        this.setRegistry(registry);
        this.setType(type2);
        this.setSource(source2);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, (Class)this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.registry.addManagedBean(managed);
        }
        catch (Exception ex) {
            log.error(sm.getString("modules.readDescriptorsError"), ex);
        }
    }

    private boolean supportedType(Class<?> ret) {
        for (Class<?> supportedType : supportedTypes) {
            if (ret != supportedType) continue;
            return true;
        }
        return this.isBeanCompatible(ret);
    }

    private boolean isBeanCompatible(Class<?> javaType) {
        if (javaType.isArray() || javaType.isPrimitive()) {
            return false;
        }
        if (javaType.getName().startsWith("java.") || javaType.getName().startsWith("javax.")) {
            return false;
        }
        try {
            javaType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        Class<?> superClass = javaType.getSuperclass();
        return superClass == null || superClass == Object.class || superClass == Exception.class || superClass == Throwable.class || this.isBeanCompatible(superClass);
    }

    private void initMethods(Class<?> realClass, Set<String> attNames, Map<String, Method> getAttMap, Map<String, Method> setAttMap, List<Method> invokeAttList) {
        Method[] methods2;
        for (Method method2 : methods2 = realClass.getMethods()) {
            String name2 = method2.getName();
            if (Modifier.isStatic(method2.getModifiers())) continue;
            if (!Modifier.isPublic(method2.getModifiers())) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Not public " + String.valueOf(method2));
                continue;
            }
            if (method2.getDeclaringClass() == Object.class) continue;
            Class<?>[] params2 = method2.getParameterTypes();
            if (name2.startsWith("get") && params2.length == 0) {
                Class<?> ret = method2.getReturnType();
                if (!this.supportedType(ret)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Unsupported type " + String.valueOf(method2));
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(3));
                getAttMap.put(name2, method2);
                attNames.add(name2);
                continue;
            }
            if (name2.startsWith("is") && params2.length == 0) {
                Class<?> ret = method2.getReturnType();
                if (Boolean.TYPE != ret) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Unsupported type " + String.valueOf(method2) + " " + String.valueOf(ret));
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(2));
                getAttMap.put(name2, method2);
                attNames.add(name2);
                continue;
            }
            if (name2.startsWith("set") && params2.length == 1) {
                if (!this.supportedType(params2[0])) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Unsupported type " + String.valueOf(method2) + " " + String.valueOf(params2[0]));
                    continue;
                }
                name2 = MbeansDescriptorsIntrospectionSource.unCapitalize(name2.substring(3));
                setAttMap.put(name2, method2);
                attNames.add(name2);
                continue;
            }
            if (params2.length == 0) {
                if (specialMethods.get(name2) != null) continue;
                invokeAttList.add(method2);
                continue;
            }
            boolean supported = true;
            for (Class<?> param : params2) {
                if (this.supportedType(param)) continue;
                supported = false;
                break;
            }
            if (!supported) continue;
            invokeAttList.add(method2);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Class<?> realClass, String type2) {
        ManagedBean mbean = new ManagedBean();
        HashSet<String> attrNames = new HashSet<String>();
        HashMap<String, Method> getAttMap = new HashMap<String, Method>();
        HashMap<String, Method> setAttMap = new HashMap<String, Method>();
        ArrayList<Method> invokeAttList = new ArrayList<Method>();
        this.initMethods(realClass, attrNames, getAttMap, setAttMap, invokeAttList);
        try {
            for (String name2 : attrNames) {
                Method sm;
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name2);
                Method gm = (Method)getAttMap.get(name2);
                if (gm != null) {
                    ai.setGetMethod(gm.getName());
                    Class<?> t = gm.getReturnType();
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                }
                if ((sm = (Method)setAttMap.get(name2)) != null) {
                    Class<?> t = sm.getParameterTypes()[0];
                    if (t != null) {
                        ai.setType(t.getName());
                    }
                    ai.setSetMethod(sm.getName());
                }
                ai.setDescription("Introspected attribute " + name2);
                if (log.isTraceEnabled()) {
                    log.trace("Introspected attribute " + name2 + " " + String.valueOf(gm) + " " + String.valueOf(sm));
                }
                if (gm == null) {
                    ai.setReadable(false);
                }
                if (sm == null) {
                    ai.setWriteable(false);
                }
                if (sm == null && gm == null) continue;
                mbean.addAttribute(ai);
            }
            for (Method method2 : invokeAttList) {
                String name3 = method2.getName();
                OperationInfo op = new OperationInfo();
                op.setName(name3);
                op.setReturnType(method2.getReturnType().getName());
                op.setDescription("Introspected operation " + name3);
                Class<?>[] params2 = method2.getParameterTypes();
                for (int i2 = 0; i2 < params2.length; ++i2) {
                    ParameterInfo pi = new ParameterInfo();
                    pi.setType(params2[i2].getName());
                    pi.setName(("param" + i2).intern());
                    pi.setDescription(("Introspected parameter param" + i2).intern());
                    op.addParameter(pi);
                }
                mbean.addOperation(op);
            }
            if (log.isTraceEnabled()) {
                log.trace("Setting name: " + type2);
            }
            mbean.setName(type2);
            return mbean;
        }
        catch (Exception ex) {
            log.error(sm.getString("source.introspectionError", realClass.getName()), ex);
            return null;
        }
    }

    private static String unCapitalize(String name2) {
        if (name2 == null || name2.length() == 0) {
            return name2;
        }
        char[] chars2 = name2.toCharArray();
        chars2[0] = Character.toLowerCase(chars2[0]);
        return new String(chars2);
    }

    static {
        specialMethods.put("preDeregister", "");
        specialMethods.put("postDeregister", "");
        supportedTypes = new Class[]{Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, String.class, String[].class, BigDecimal.class, BigInteger.class, ObjectName.class, Object[].class, File.class};
    }
}

