/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.NoDescriptorRegistry;
import org.apache.tomcat.util.modeler.RegistryMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.apache.tomcat.util.res.StringManager;

public class Registry
implements RegistryMBean,
MBeanRegistration {
    private static final Log log = LogFactory.getLog(Registry.class);
    private static final StringManager sm = StringManager.getManager(Registry.class);
    private static Registry registry = null;
    private volatile MBeanServer server = null;
    private final Object serverLock = new Object();
    private Map<String, ManagedBean> descriptors = new HashMap<String, ManagedBean>();
    private Map<String, ManagedBean> descriptorsByClass = new HashMap<String, ManagedBean>();
    private Map<String, URL> searchedPaths = new HashMap<String, URL>();
    private Object guard;
    private final Hashtable<String, Hashtable<String, Integer>> idDomains = new Hashtable();
    private final Hashtable<String, int[]> ids = new Hashtable();

    protected Registry() {
    }

    public static synchronized Registry getRegistry(Object key2, Object guard) {
        if (registry == null) {
            registry = new Registry();
            Registry.registry.guard = guard;
        }
        if (Registry.registry.guard != null && Registry.registry.guard != guard) {
            return null;
        }
        return registry;
    }

    public static synchronized void disableRegistry() {
        if (registry == null) {
            registry = new NoDescriptorRegistry();
        } else if (!(registry instanceof NoDescriptorRegistry)) {
            log.warn(sm.getString("registry.noDisable"));
        }
    }

    @Override
    public void stop() {
        this.descriptorsByClass = new HashMap<String, ManagedBean>();
        this.descriptors = new HashMap<String, ManagedBean>();
        this.searchedPaths = new HashMap<String, URL>();
    }

    @Override
    public void registerComponent(Object bean2, String oname, String type2) throws Exception {
        this.registerComponent(bean2, new ObjectName(oname), type2);
    }

    @Override
    public void unregisterComponent(String oname) {
        try {
            this.unregisterComponent(new ObjectName(oname));
        }
        catch (MalformedObjectNameException e) {
            log.info(sm.getString("registry.objectNameCreateError"), e);
        }
    }

    @Override
    public void invoke(List<ObjectName> mbeans, String operation, boolean failFirst) throws Exception {
        if (mbeans == null) {
            return;
        }
        for (ObjectName current2 : mbeans) {
            try {
                if (current2 == null || this.getMethodInfo(current2, operation) == null) continue;
                this.getMBeanServer().invoke(current2, operation, new Object[0], new String[0]);
            }
            catch (Exception t) {
                if (failFirst) {
                    throw t;
                }
                log.info(sm.getString("registry.initError"), t);
            }
        }
    }

    @Override
    public synchronized int getId(String domain, String name2) {
        Integer i2;
        if (domain == null) {
            domain = "";
        }
        Hashtable domainTable = this.idDomains.computeIfAbsent(domain, k -> new Hashtable());
        if (name2 == null) {
            name2 = "";
        }
        if ((i2 = (Integer)domainTable.get(name2)) != null) {
            return i2;
        }
        int[] id2 = this.ids.computeIfAbsent(domain, k -> new int[1]);
        int n = id2[0];
        id2[0] = n + 1;
        int code = n;
        domainTable.put(name2, code);
        return code;
    }

    public void addManagedBean(ManagedBean bean2) {
        this.descriptors.put(bean2.getName(), bean2);
        if (bean2.getType() != null) {
            this.descriptorsByClass.put(bean2.getType(), bean2);
        }
    }

    public ManagedBean findManagedBean(String name2) {
        ManagedBean mb = this.descriptors.get(name2);
        if (mb == null) {
            mb = this.descriptorsByClass.get(name2);
        }
        return mb;
    }

    public String getType(ObjectName oname, String attName) {
        MBeanAttributeInfo[] attInfo;
        String type2 = null;
        MBeanInfo info = null;
        try {
            info = this.getMBeanServer().getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.info(sm.getString("registry.noMetadata", oname));
            return null;
        }
        for (MBeanAttributeInfo mBeanAttributeInfo : attInfo = info.getAttributes()) {
            if (!attName.equals(mBeanAttributeInfo.getName())) continue;
            type2 = mBeanAttributeInfo.getType();
            return type2;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName) {
        MBeanOperationInfo[] attInfo;
        MBeanInfo info = null;
        try {
            info = this.getMBeanServer().getMBeanInfo(oname);
        }
        catch (Exception e) {
            log.info(sm.getString("registry.noMetadata", oname));
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : attInfo = info.getOperations()) {
            if (!opName.equals(mBeanOperationInfo.getName())) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public MBeanOperationInfo getMethodInfo(ObjectName oname, String opName, int argCount) throws InstanceNotFoundException {
        MBeanOperationInfo[] attInfo;
        MBeanInfo info = null;
        try {
            info = this.getMBeanServer().getMBeanInfo(oname);
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (Exception e) {
            log.warn(sm.getString("registry.noMetadata", oname), e);
            return null;
        }
        for (MBeanOperationInfo mBeanOperationInfo : attInfo = info.getOperations()) {
            if (!opName.equals(mBeanOperationInfo.getName()) || argCount != mBeanOperationInfo.getSignature().length) continue;
            return mBeanOperationInfo;
        }
        return null;
    }

    public void unregisterComponent(ObjectName oname) {
        try {
            if (oname != null && this.getMBeanServer().isRegistered(oname)) {
                this.getMBeanServer().unregisterMBean(oname);
            }
        }
        catch (Throwable t) {
            log.error(sm.getString("registry.unregisterError"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanServer getMBeanServer() {
        if (this.server == null) {
            Object object = this.serverLock;
            synchronized (object) {
                if (this.server == null) {
                    if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                        this.server = MBeanServerFactory.findMBeanServer(null).get(0);
                        if (log.isDebugEnabled()) {
                            log.debug(sm.getString("registry.existingServer"));
                        }
                    } else {
                        this.server = ManagementFactory.getPlatformMBeanServer();
                        if (log.isDebugEnabled()) {
                            log.debug(sm.getString("registry.createdServer"));
                        }
                    }
                }
            }
        }
        return this.server;
    }

    public ManagedBean findManagedBean(Object bean2, Class<?> beanClass, String type2) throws Exception {
        ManagedBean managed;
        if (bean2 != null && beanClass == null) {
            beanClass = bean2.getClass();
        }
        if (type2 == null) {
            type2 = beanClass.getName();
        }
        if ((managed = this.findManagedBean(type2)) == null) {
            if (log.isTraceEnabled()) {
                log.trace("Looking for descriptor ");
            }
            this.findDescriptor(beanClass, type2);
            managed = this.findManagedBean(type2);
        }
        if (managed == null) {
            if (log.isTraceEnabled()) {
                log.trace("Introspecting ");
            }
            this.load("MbeansDescriptorsIntrospectionSource", beanClass, type2);
            managed = this.findManagedBean(type2);
            if (managed == null) {
                log.warn(sm.getString("registry.noTypeMetadata", type2));
                return null;
            }
            managed.setName(type2);
            this.addManagedBean(managed);
        }
        return managed;
    }

    public Object convertValue(String type2, String value2) {
        Object objValue = value2;
        if (type2 == null || "java.lang.String".equals(type2)) {
            objValue = value2;
        } else if ("javax.management.ObjectName".equals(type2) || "ObjectName".equals(type2)) {
            try {
                objValue = new ObjectName(value2);
            }
            catch (MalformedObjectNameException e) {
                return null;
            }
        } else if ("java.lang.Integer".equals(type2) || "int".equals(type2)) {
            objValue = Integer.valueOf(value2);
        } else if ("java.lang.Long".equals(type2) || "long".equals(type2)) {
            objValue = Long.valueOf(value2);
        } else if ("java.lang.Boolean".equals(type2) || "boolean".equals(type2)) {
            objValue = Boolean.valueOf(value2);
        }
        return objValue;
    }

    public List<ObjectName> load(String sourceType, Object source2, String param) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("load " + String.valueOf(source2));
        }
        String location = null;
        String type2 = null;
        Object inputsource = null;
        if (source2 instanceof URL) {
            URL url = (URL)source2;
            location = url.toString();
            type2 = param;
            inputsource = url.openStream();
            if (sourceType == null && location.endsWith(".xml")) {
                sourceType = "MbeansDescriptorsDigesterSource";
            }
        } else if (source2 instanceof File) {
            location = ((File)source2).getAbsolutePath();
            inputsource = new FileInputStream((File)source2);
            type2 = param;
            if (sourceType == null && location.endsWith(".xml")) {
                sourceType = "MbeansDescriptorsDigesterSource";
            }
        } else if (source2 instanceof InputStream) {
            type2 = param;
            inputsource = source2;
        } else if (source2 instanceof Class) {
            location = ((Class)source2).getName();
            type2 = param;
            inputsource = source2;
            if (sourceType == null) {
                sourceType = "MbeansDescriptorsIntrospectionSource";
            }
        } else {
            throw new IllegalArgumentException(sm.getString("registry.invalidSource"));
        }
        if (sourceType == null) {
            sourceType = "MbeansDescriptorsDigesterSource";
        }
        ModelerSource ds = this.getModelerSource(sourceType);
        List<ObjectName> mbeans = ds.loadDescriptors(this, type2, inputsource);
        return mbeans;
    }

    public void registerComponent(Object bean2, ObjectName oname, String type2) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("Managed= " + String.valueOf(oname));
        }
        if (bean2 == null) {
            log.error(sm.getString("registry.nullBean", oname));
            return;
        }
        try {
            if (type2 == null) {
                type2 = bean2.getClass().getName();
            }
            ManagedBean managed = this.findManagedBean(null, bean2.getClass(), type2);
            DynamicMBean mbean = managed.createMBean(bean2);
            if (this.getMBeanServer().isRegistered(oname)) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("registry.unregisterExisting", oname));
                }
                this.getMBeanServer().unregisterMBean(oname);
            }
            this.getMBeanServer().registerMBean(mbean, oname);
        }
        catch (Exception ex) {
            log.error(sm.getString("registry.registerError", oname), ex);
            throw ex;
        }
    }

    public void loadDescriptors(String packageName, ClassLoader classLoader) {
        String res = packageName.replace('.', '/');
        if (log.isTraceEnabled()) {
            log.trace("Finding descriptor " + res);
        }
        if (this.searchedPaths.get(packageName) != null) {
            return;
        }
        String descriptors = res + "/mbeans-descriptors.xml";
        URL dURL = classLoader.getResource(descriptors);
        if (dURL == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Found " + String.valueOf(dURL));
        }
        this.searchedPaths.put(packageName, dURL);
        try {
            this.load("MbeansDescriptorsDigesterSource", dURL, null);
        }
        catch (Exception ex) {
            log.error(sm.getString("registry.loadError", dURL));
        }
    }

    private void findDescriptor(Class<?> beanClass, String type2) {
        String className;
        if (type2 == null) {
            type2 = beanClass.getName();
        }
        ClassLoader classLoader = null;
        if (beanClass != null) {
            classLoader = beanClass.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        String pkg = className = type2;
        while (pkg.indexOf(46) > 0) {
            int lastComp = pkg.lastIndexOf(46);
            if (lastComp <= 0) {
                return;
            }
            if (this.searchedPaths.get(pkg = pkg.substring(0, lastComp)) != null) {
                return;
            }
            this.loadDescriptors(pkg, classLoader);
        }
    }

    private ModelerSource getModelerSource(String type2) throws Exception {
        if (type2 == null) {
            type2 = "MbeansDescriptorsDigesterSource";
        }
        if (!((String)type2).contains(".")) {
            type2 = "org.apache.tomcat.util.modeler.modules." + (String)type2;
        }
        Class<?> c = Class.forName((String)type2);
        ModelerSource ds = (ModelerSource)c.getConstructor(new Class[0]).newInstance(new Object[0]);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name2) throws Exception {
        Object object = this.serverLock;
        synchronized (object) {
            this.server = server;
        }
        return name2;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

