/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tomcat.util.log.CaptureLog;

public class SystemLogHandler
extends PrintStream {
    private final PrintStream out;
    private static final ThreadLocal<Deque<CaptureLog>> logs = new ThreadLocal();
    private static final Queue<CaptureLog> reuse = new ConcurrentLinkedQueue<CaptureLog>();

    public SystemLogHandler(PrintStream wrapped) {
        super(wrapped);
        this.out = wrapped;
    }

    public static void startCapture() {
        Deque<CaptureLog> stack;
        CaptureLog log3 = null;
        if (!reuse.isEmpty()) {
            try {
                log3 = reuse.remove();
            }
            catch (NoSuchElementException e) {
                log3 = new CaptureLog();
            }
        } else {
            log3 = new CaptureLog();
        }
        if ((stack = logs.get()) == null) {
            stack = new ArrayDeque<CaptureLog>();
            logs.set(stack);
        }
        stack.addFirst(log3);
    }

    public static String stopCapture() {
        Queue stack = logs.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        CaptureLog log3 = (CaptureLog)stack.remove();
        if (log3 == null) {
            return null;
        }
        String capture = log3.getCapture();
        log3.reset();
        reuse.add(log3);
        return capture;
    }

    protected PrintStream findStream() {
        PrintStream ps;
        CaptureLog log3;
        Queue stack = logs.get();
        if (stack != null && !stack.isEmpty() && (log3 = (CaptureLog)stack.peek()) != null && (ps = log3.getStream()) != null) {
            return ps;
        }
        return this.out;
    }

    @Override
    public void flush() {
        this.findStream().flush();
    }

    @Override
    public void close() {
        this.findStream().close();
    }

    @Override
    public boolean checkError() {
        return this.findStream().checkError();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int b2) {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.findStream().write(b2);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.findStream().write(buf, off, len);
    }

    @Override
    public void print(boolean b2) {
        this.findStream().print(b2);
    }

    @Override
    public void print(char c) {
        this.findStream().print(c);
    }

    @Override
    public void print(int i2) {
        this.findStream().print(i2);
    }

    @Override
    public void print(long l) {
        this.findStream().print(l);
    }

    @Override
    public void print(float f) {
        this.findStream().print(f);
    }

    @Override
    public void print(double d) {
        this.findStream().print(d);
    }

    @Override
    public void print(char[] s2) {
        this.findStream().print(s2);
    }

    @Override
    public void print(String s2) {
        this.findStream().print(s2);
    }

    @Override
    public void print(Object obj) {
        this.findStream().print(obj);
    }

    @Override
    public void println() {
        this.findStream().println();
    }

    @Override
    public void println(boolean x) {
        this.findStream().println(x);
    }

    @Override
    public void println(char x) {
        this.findStream().println(x);
    }

    @Override
    public void println(int x) {
        this.findStream().println(x);
    }

    @Override
    public void println(long x) {
        this.findStream().println(x);
    }

    @Override
    public void println(float x) {
        this.findStream().println(x);
    }

    @Override
    public void println(double x) {
        this.findStream().println(x);
    }

    @Override
    public void println(char[] x) {
        this.findStream().println(x);
    }

    @Override
    public void println(String x) {
        this.findStream().println(x);
    }

    @Override
    public void println(Object x) {
        this.findStream().println(x);
    }
}

