/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class StructuredField {
    private static final StringManager sm;
    private static final int ARRAY_SIZE = 128;
    private static final boolean[] IS_KEY_FIRST;
    private static final boolean[] IS_KEY;
    private static final boolean[] IS_OWS;
    private static final boolean[] IS_BASE64;
    private static final boolean[] IS_TOKEN;

    static SfList parseSfList(Reader input) throws IOException {
        StructuredField.skipSP(input);
        SfList result2 = new SfList();
        if (StructuredField.peek(input) != -1) {
            while (true) {
                SfListMember listMember = StructuredField.parseSfListMember(input);
                result2.addListMember(listMember);
                StructuredField.skipOWS(input);
                if (StructuredField.peek(input) == -1) break;
                StructuredField.requireChar(input, 44);
                StructuredField.skipOWS(input);
                StructuredField.requireNotChar(input, -1);
            }
        }
        StructuredField.skipSP(input);
        StructuredField.requireChar(input, -1);
        return result2;
    }

    static SfListMember parseSfListMember(Reader input) throws IOException {
        SfListMember listMember = StructuredField.peek(input) == 40 ? StructuredField.parseSfInnerList(input) : StructuredField.parseSfBareItem(input);
        StructuredField.parseSfParameters(input, listMember);
        return listMember;
    }

    static SfInnerList parseSfInnerList(Reader input) throws IOException {
        StructuredField.requireChar(input, 40);
        SfInnerList innerList = new SfInnerList();
        while (true) {
            StructuredField.skipSP(input);
            if (StructuredField.peek(input) == 41) break;
            SfItem<?> item = StructuredField.parseSfBareItem(input);
            StructuredField.parseSfParameters(input, item);
            innerList.addListItem(item);
            input.mark(1);
            StructuredField.requireChar(input, 32, 41);
            input.reset();
        }
        StructuredField.requireChar(input, 41);
        return innerList;
    }

    static SfDictionary parseSfDictionary(Reader input) throws IOException {
        StructuredField.skipSP(input);
        SfDictionary result2 = new SfDictionary();
        if (StructuredField.peek(input) != -1) {
            while (true) {
                SfListMember listMember;
                String key2 = StructuredField.parseSfKey(input);
                input.mark(1);
                int c = input.read();
                if (c == 61) {
                    listMember = StructuredField.parseSfListMember(input);
                } else {
                    listMember = new SfBoolean(true);
                    input.reset();
                }
                StructuredField.parseSfParameters(input, listMember);
                result2.addDictionaryMember(key2, listMember);
                StructuredField.skipOWS(input);
                if (StructuredField.peek(input) == -1) break;
                StructuredField.requireChar(input, 44);
                StructuredField.skipOWS(input);
                StructuredField.requireNotChar(input, -1);
            }
        }
        StructuredField.skipSP(input);
        StructuredField.requireChar(input, -1);
        return result2;
    }

    static SfItem<?> parseSfItem(Reader input) throws IOException {
        StructuredField.skipSP(input);
        SfItem<?> item = StructuredField.parseSfBareItem(input);
        StructuredField.parseSfParameters(input, item);
        StructuredField.skipSP(input);
        StructuredField.requireChar(input, -1);
        return item;
    }

    static SfItem<?> parseSfBareItem(Reader input) throws IOException {
        SfItem item;
        int c = input.read();
        if (c == 45 || HttpParser.isNumeric(c)) {
            item = StructuredField.parseSfNumeric(input, c);
        } else if (c == 34) {
            item = StructuredField.parseSfString(input);
        } else if (c == 42 || HttpParser.isAlpha(c)) {
            item = StructuredField.parseSfToken(input, c);
        } else if (c == 58) {
            item = StructuredField.parseSfByteSequence(input);
        } else if (c == 63) {
            item = StructuredField.parseSfBoolean(input);
        } else {
            throw new IllegalArgumentException(sm.getString("sf.bareitem.invalidCharacter", String.format("\\u%40X", c)));
        }
        return item;
    }

    static void parseSfParameters(Reader input, SfListMember listMember) throws IOException {
        while (StructuredField.peek(input) == 59) {
            SfBoolean item;
            StructuredField.requireChar(input, 59);
            StructuredField.skipSP(input);
            String key2 = StructuredField.parseSfKey(input);
            input.mark(1);
            int c = input.read();
            if (c == 61) {
                item = StructuredField.parseSfBareItem(input);
            } else {
                item = new SfBoolean(true);
                input.reset();
            }
            listMember.addParameter(key2, item);
        }
    }

    static String parseSfKey(Reader input) throws IOException {
        StringBuilder result2 = new StringBuilder();
        input.mark(1);
        int c = input.read();
        if (!StructuredField.isKeyFirst(c)) {
            throw new IllegalArgumentException(sm.getString("sf.key.invalidFirstCharacter", String.format("\\u%40X", c)));
        }
        while (c != -1 && StructuredField.isKey(c)) {
            result2.append((char)c);
            input.mark(1);
            c = input.read();
        }
        input.reset();
        return result2.toString();
    }

    static SfItem<?> parseSfNumeric(Reader input, int first2) throws IOException {
        int c;
        int sign2 = 1;
        boolean integer = true;
        int decimalPos = 0;
        StringBuilder result2 = new StringBuilder();
        if (first2 == 45) {
            sign2 = -1;
            c = input.read();
        } else {
            c = first2;
        }
        if (!HttpParser.isNumeric(c)) {
            throw new IllegalArgumentException(sm.getString("sf.numeric.invalidCharacter", String.format("\\u%40X", c)));
        }
        result2.append((char)c);
        input.mark(1);
        c = input.read();
        while (c != -1) {
            if (HttpParser.isNumeric(c)) {
                result2.append((char)c);
            } else if (integer && c == 46) {
                if (result2.length() > 12) {
                    throw new IllegalArgumentException(sm.getString("sf.numeric.integralPartTooLong"));
                }
                integer = false;
                result2.append((char)c);
                decimalPos = result2.length();
            } else {
                input.reset();
                break;
            }
            if (integer && result2.length() > 15) {
                throw new IllegalArgumentException(sm.getString("sf.numeric.integerTooLong"));
            }
            if (!integer && result2.length() > 16) {
                throw new IllegalArgumentException(sm.getString("sf.numeric.decimalTooLong"));
            }
            input.mark(1);
            c = input.read();
        }
        if (integer) {
            return new SfInteger(Long.parseLong(result2.toString()) * (long)sign2);
        }
        if (result2.charAt(result2.length() - 1) == '.') {
            throw new IllegalArgumentException(sm.getString("sf.numeric.decimalInvalidFinal"));
        }
        if (result2.length() - decimalPos > 3) {
            throw new IllegalArgumentException(sm.getString("sf.numeric.decimalPartTooLong"));
        }
        return new SfDecimal(Double.parseDouble(result2.toString()) * (double)sign2);
    }

    static SfString parseSfString(Reader input) throws IOException {
        StringBuilder result2 = new StringBuilder();
        while (true) {
            int c;
            if ((c = input.read()) == 92) {
                StructuredField.requireNotChar(input, -1);
                c = input.read();
                if (c != 92 && c != 34) {
                    throw new IllegalArgumentException(sm.getString("sf.string.invalidEscape", String.format("\\u%40X", c)));
                }
            } else {
                if (c == 34) break;
                if (c < 32 || c > 126) {
                    throw new IllegalArgumentException(sm.getString("sf.string.invalidCharacter", String.format("\\u%40X", c)));
                }
            }
            result2.append((char)c);
        }
        return new SfString(result2.toString());
    }

    static SfToken parseSfToken(Reader input, int first2) throws IOException {
        StringBuilder result2 = new StringBuilder();
        result2.append((char)first2);
        while (true) {
            input.mark(1);
            int c = input.read();
            if (!StructuredField.isToken(c)) break;
            result2.append((char)c);
        }
        input.reset();
        return new SfToken(result2.toString());
    }

    static SfByteSequence parseSfByteSequence(Reader input) throws IOException {
        int c;
        StringBuilder base64 = new StringBuilder();
        while ((c = input.read()) != 58) {
            if (StructuredField.isBase64(c)) {
                base64.append((char)c);
                continue;
            }
            throw new IllegalArgumentException(sm.getString("sf.base64.invalidCharacter", String.format("\\u%40X", c)));
        }
        return new SfByteSequence(Base64.getDecoder().decode(base64.toString()));
    }

    static SfBoolean parseSfBoolean(Reader input) throws IOException {
        int c = input.read();
        if (c == 49) {
            return new SfBoolean(true);
        }
        if (c == 48) {
            return new SfBoolean(false);
        }
        throw new IllegalArgumentException(sm.getString("sf.boolean.invalidCharacter", String.format("\\u%40X", c)));
    }

    static void skipSP(Reader input) throws IOException {
        input.mark(1);
        int c = input.read();
        while (c == 32) {
            input.mark(1);
            c = input.read();
        }
        input.reset();
    }

    static void skipOWS(Reader input) throws IOException {
        input.mark(1);
        int c = input.read();
        while (StructuredField.isOws(c)) {
            input.mark(1);
            c = input.read();
        }
        input.reset();
    }

    static void requireChar(Reader input, int ... required) throws IOException {
        int c = input.read();
        for (int r : required) {
            if (c != r) continue;
            return;
        }
        throw new IllegalArgumentException(sm.getString("sf.invalidCharacter", String.format("\\u%40X", c)));
    }

    static void requireNotChar(Reader input, int required) throws IOException {
        input.mark(1);
        int c = input.read();
        if (c == required) {
            throw new IllegalArgumentException(sm.getString("sf.invalidCharacter", String.format("\\u%40X", c)));
        }
        input.reset();
    }

    static int peek(Reader input) throws IOException {
        input.mark(1);
        int c = input.read();
        input.reset();
        return c;
    }

    static boolean isKeyFirst(int c) {
        try {
            return IS_KEY_FIRST[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static boolean isKey(int c) {
        try {
            return IS_KEY[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static boolean isOws(int c) {
        try {
            return IS_OWS[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static boolean isBase64(int c) {
        try {
            return IS_BASE64[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static boolean isToken(int c) {
        try {
            return IS_TOKEN[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    private StructuredField() {
    }

    static {
        int i2;
        sm = StringManager.getManager(StructuredField.class);
        IS_KEY_FIRST = new boolean[128];
        IS_KEY = new boolean[128];
        IS_OWS = new boolean[128];
        IS_BASE64 = new boolean[128];
        IS_TOKEN = new boolean[128];
        for (i2 = 0; i2 < 128; ++i2) {
            if (i2 == 42 || i2 >= 97 && i2 <= 122) {
                StructuredField.IS_KEY_FIRST[i2] = true;
                StructuredField.IS_KEY[i2] = true;
                continue;
            }
            if ((i2 < 48 || i2 > 57) && i2 != 95 && i2 != 45 && i2 != 46) continue;
            StructuredField.IS_KEY[i2] = true;
        }
        for (i2 = 0; i2 < 128; ++i2) {
            if (i2 != 9 && i2 != 32) continue;
            StructuredField.IS_OWS[i2] = true;
        }
        for (i2 = 0; i2 < 128; ++i2) {
            if (!(i2 == 43 || i2 == 47 || i2 >= 48 && i2 <= 57 || i2 == 61 || i2 >= 65 && i2 <= 90) && (i2 < 97 || i2 > 122)) continue;
            StructuredField.IS_BASE64[i2] = true;
        }
        for (i2 = 0; i2 < 128; ++i2) {
            if (!HttpParser.isToken(i2) && i2 != 58 && i2 != 47) continue;
            StructuredField.IS_TOKEN[i2] = true;
        }
    }

    static class SfList {
        private List<SfListMember> listMembers = new ArrayList<SfListMember>();

        SfList() {
        }

        void addListMember(SfListMember listMember) {
            this.listMembers.add(listMember);
        }
    }

    static class SfListMember {
        private Map<String, SfItem<?>> parameters = null;

        SfListMember() {
        }

        void addParameter(String key2, SfItem<?> value2) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap();
            }
            this.parameters.put(key2, value2);
        }
    }

    static class SfInnerList
    extends SfListMember {
        List<SfItem<?>> listItems = new ArrayList();

        SfInnerList() {
        }

        void addListItem(SfItem<?> item) {
            this.listItems.add(item);
        }

        List<SfItem<?>> getListItem() {
            return this.listItems;
        }
    }

    static abstract class SfItem<T>
    extends SfListMember {
        private final T value;

        SfItem(T value2) {
            this.value = value2;
        }

        T getVaue() {
            return this.value;
        }
    }

    static class SfDictionary {
        private Map<String, SfListMember> dictionary = new LinkedHashMap<String, SfListMember>();

        SfDictionary() {
        }

        void addDictionaryMember(String key2, SfListMember value2) {
            this.dictionary.put(key2, value2);
        }

        SfListMember getDictionaryMember(String key2) {
            return this.dictionary.get(key2);
        }
    }

    static class SfBoolean
    extends SfItem<Boolean> {
        SfBoolean(boolean value2) {
            super(value2);
        }
    }

    static class SfString
    extends SfItem<String> {
        SfString(String value2) {
            super(value2);
        }
    }

    static class SfToken
    extends SfItem<String> {
        SfToken(String value2) {
            super(value2);
        }
    }

    static class SfByteSequence
    extends SfItem<byte[]> {
        SfByteSequence(byte[] value2) {
            super(value2);
        }
    }

    static class SfInteger
    extends SfItem<Long> {
        SfInteger(long value2) {
            super(value2);
        }
    }

    static class SfDecimal
    extends SfItem<Double> {
        SfDecimal(double value2) {
            super(value2);
        }
    }
}

