/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class Ranges {
    private final String units;
    private final List<Entry> entries;

    public Ranges(String units, List<Entry> entries2) {
        this.units = units == null ? null : units.toLowerCase(Locale.ENGLISH);
        this.entries = Collections.unmodifiableList(entries2);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public String getUnits() {
        return this.units;
    }

    public static Ranges parse(StringReader input) throws IOException {
        SkipResult skipResult;
        String units = HttpParser.readToken(input);
        if (units == null || units.length() == 0) {
            return null;
        }
        if (HttpParser.skipConstant(input, "=") != SkipResult.FOUND) {
            return null;
        }
        ArrayList<Entry> entries2 = new ArrayList<Entry>();
        do {
            long start2 = HttpParser.readLong(input);
            if (HttpParser.skipConstant(input, "-") != SkipResult.FOUND) {
                return null;
            }
            long end2 = HttpParser.readLong(input);
            if (start2 == -1L && end2 == -1L) {
                return null;
            }
            entries2.add(new Entry(start2, end2));
            skipResult = HttpParser.skipConstant(input, ",");
            if (skipResult != SkipResult.NOT_FOUND) continue;
            return null;
        } while (skipResult == SkipResult.FOUND);
        return new Ranges(units, entries2);
    }

    public static class Entry {
        private final long start;
        private final long end;

        public Entry(long start2, long end2) {
            this.start = start2;
            this.end = end2;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }
}

