/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import org.apache.tomcat.util.collections.ConcurrentCache;
import org.apache.tomcat.util.http.parser.MediaType;

public class MediaTypeCache {
    private final ConcurrentCache<String, String[]> cache;

    public MediaTypeCache(int size2) {
        this.cache = new ConcurrentCache(size2);
    }

    public String[] parse(String input) {
        String[] result2 = this.cache.get(input);
        if (result2 != null) {
            return result2;
        }
        MediaType m = null;
        try {
            m = MediaType.parseMediaType(new StringReader(input));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (m != null) {
            result2 = new String[]{m.toStringNoCharset(), m.getCharset()};
            this.cache.put(input, result2);
        }
        return result2;
    }
}

