/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.nio.charset.StandardCharsets;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public class Cookie {
    private static final Log log;
    private static final UserDataHelper invalidCookieLog;
    private static final StringManager sm;
    private static final boolean[] isCookieOctet;
    private static final boolean[] isText;
    private static final byte[] EMPTY_BYTES;
    private static final byte TAB_BYTE = 9;
    private static final byte SPACE_BYTE = 32;
    private static final byte QUOTE_BYTE = 34;
    private static final byte COMMA_BYTE = 44;
    private static final byte SEMICOLON_BYTE = 59;
    private static final byte EQUALS_BYTE = 61;
    private static final byte SLASH_BYTE = 92;
    private static final byte DEL_BYTE = 127;

    private Cookie() {
    }

    public static void parseCookie(byte[] bytes2, int offset2, int len, ServerCookies serverCookies) {
        ByteBuffer bb = new ByteBuffer(bytes2, offset2, len);
        boolean moreToProcess = true;
        while (moreToProcess) {
            Cookie.skipLWS(bb);
            int start2 = bb.position();
            ByteBuffer name2 = Cookie.readToken(bb);
            ByteBuffer value2 = null;
            Cookie.skipLWS(bb);
            SkipResult skipResult = Cookie.skipByte(bb, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                Cookie.skipLWS(bb);
                value2 = Cookie.readCookieValueRfc6265(bb);
                if (value2 == null) {
                    Cookie.skipUntilSemiColon(bb);
                    Cookie.logInvalidHeader(start2, bb);
                    continue;
                }
                Cookie.skipLWS(bb);
            }
            if ((skipResult = Cookie.skipByte(bb, (byte)59)) != SkipResult.FOUND) {
                if (skipResult == SkipResult.NOT_FOUND) {
                    Cookie.skipUntilSemiColon(bb);
                    Cookie.logInvalidHeader(start2, bb);
                    continue;
                }
                moreToProcess = false;
            }
            if (!name2.hasRemaining()) continue;
            ServerCookie sc = serverCookies.addCookie();
            sc.getName().setBytes(name2.array(), name2.position(), name2.remaining());
            if (value2 == null) {
                sc.getValue().setBytes(EMPTY_BYTES, 0, EMPTY_BYTES.length);
                continue;
            }
            sc.getValue().setBytes(value2.array(), value2.position(), value2.remaining());
        }
    }

    private static void skipLWS(ByteBuffer bb) {
        while (bb.hasRemaining()) {
            byte b2 = bb.get();
            if (b2 == 9 || b2 == 32) continue;
            bb.rewind();
            break;
        }
    }

    private static void skipUntilSemiColon(ByteBuffer bb) {
        while (bb.hasRemaining() && bb.get() != 59) {
        }
    }

    private static SkipResult skipByte(ByteBuffer bb, byte target2) {
        if (!bb.hasRemaining()) {
            return SkipResult.EOF;
        }
        if (bb.get() == target2) {
            return SkipResult.FOUND;
        }
        bb.rewind();
        return SkipResult.NOT_FOUND;
    }

    private static ByteBuffer readCookieValueRfc6265(ByteBuffer bb) {
        boolean quoted = false;
        if (bb.hasRemaining()) {
            if (bb.get() == 34) {
                quoted = true;
            } else {
                bb.rewind();
            }
        }
        int start2 = bb.position();
        int end2 = bb.limit();
        while (bb.hasRemaining()) {
            byte b2 = bb.get();
            if (isCookieOctet[b2 & 0xFF]) continue;
            if (b2 == 59 || b2 == 32 || b2 == 9) {
                end2 = bb.position() - 1;
                bb.position(end2);
                break;
            }
            if (quoted && b2 == 34) {
                end2 = bb.position() - 1;
                break;
            }
            return null;
        }
        return new ByteBuffer(bb.bytes, start2, end2 - start2);
    }

    private static ByteBuffer readToken(ByteBuffer bb) {
        int start2 = bb.position();
        int end2 = bb.limit();
        while (bb.hasRemaining()) {
            if (HttpParser.isToken(bb.get())) continue;
            end2 = bb.position() - 1;
            bb.position(end2);
            break;
        }
        return new ByteBuffer(bb.bytes, start2, end2 - start2);
    }

    private static void logInvalidHeader(int start2, ByteBuffer bb) {
        UserDataHelper.Mode logMode = invalidCookieLog.getNextMode();
        if (logMode != null) {
            String headerValue = new String(bb.array(), start2, bb.position() - start2, StandardCharsets.UTF_8);
            Object message2 = sm.getString("cookie.invalidCookieValue", headerValue);
            switch (logMode) {
                case INFO_THEN_DEBUG: {
                    message2 = (String)message2 + sm.getString("cookie.fallToDebug");
                }
                case INFO: {
                    log.info(message2);
                    break;
                }
                case DEBUG: {
                    log.debug(message2);
                }
            }
        }
    }

    static {
        int i2;
        log = LogFactory.getLog(Cookie.class);
        invalidCookieLog = new UserDataHelper(log);
        sm = StringManager.getManager("org.apache.tomcat.util.http.parser");
        isCookieOctet = new boolean[256];
        isText = new boolean[256];
        EMPTY_BYTES = new byte[0];
        for (i2 = 0; i2 < 256; ++i2) {
            Cookie.isCookieOctet[i2] = i2 >= 33 && i2 != 34 && i2 != 44 && i2 != 59 && i2 != 92 && i2 != 127;
        }
        for (i2 = 0; i2 < 256; ++i2) {
            Cookie.isText[i2] = i2 >= 9 && (i2 <= 9 || i2 >= 32) && i2 != 127;
        }
    }

    private static class ByteBuffer {
        private final byte[] bytes;
        private int limit;
        private int position = 0;

        ByteBuffer(byte[] bytes2, int offset2, int len) {
            this.bytes = bytes2;
            this.position = offset2;
            this.limit = offset2 + len;
        }

        public int position() {
            return this.position;
        }

        public void position(int position) {
            this.position = position;
        }

        public int limit() {
            return this.limit;
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public boolean hasRemaining() {
            return this.position < this.limit;
        }

        public byte get() {
            return this.bytes[this.position++];
        }

        public void rewind() {
            --this.position;
        }

        public byte[] array() {
            return this.bytes;
        }

        public String toString() {
            return "position [" + this.position + "], limit [" + this.limit + "]";
        }
    }
}

