/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.StringReader;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;

public class ContentRange {
    private final String units;
    private final long start;
    private final long end;
    private final long length;

    public ContentRange(String units, long start2, long end2, long length2) {
        this.units = units;
        this.start = start2;
        this.end = end2;
        this.length = length2;
    }

    public String getUnits() {
        return this.units;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public static ContentRange parse(StringReader input) throws IOException {
        String units = HttpParser.readToken(input);
        if (units == null || units.length() == 0) {
            return null;
        }
        long start2 = HttpParser.readLong(input);
        if (HttpParser.skipConstant(input, "-") == SkipResult.NOT_FOUND) {
            return null;
        }
        long end2 = HttpParser.readLong(input);
        if (HttpParser.skipConstant(input, "/") == SkipResult.NOT_FOUND) {
            return null;
        }
        long length2 = HttpParser.readLong(input);
        SkipResult skipResult = HttpParser.skipConstant(input, "X");
        if (skipResult != SkipResult.EOF) {
            return null;
        }
        return new ContentRange(units, start2, end2, length2);
    }
}

